/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationEventType;
import com.powsybl.openloadflow.equations.EquationSystemIndex;
import com.powsybl.openloadflow.equations.EquationSystemListener;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.EquationTermEventType;
import com.powsybl.openloadflow.equations.Quantity;
import com.powsybl.openloadflow.equations.StateVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.equations.VariableSet;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class EquationSystem<V extends Enum<V>, E extends Enum<E>> {
    private final Map<Pair<Integer, E>, Equation<V, E>> equations = new HashMap<Pair<Integer, E>, Equation<V, E>>();
    private final Map<Pair<ElementType, Integer>, List<Equation<V, E>>> equationsByElement = new HashMap<Pair<ElementType, Integer>, List<Equation<V, E>>>();
    private Map<Pair<ElementType, Integer>, List<EquationTerm<V, E>>> equationTermsByElement;
    private final List<EquationSystemListener<V, E>> listeners = new ArrayList<EquationSystemListener<V, E>>();
    private final VariableSet<V> variableSet;
    private final StateVector stateVector = new StateVector();
    private final EquationSystemIndex<V, E> index;

    public EquationSystem() {
        this(new VariableSet());
    }

    public EquationSystem(VariableSet<V> variableSet) {
        this.variableSet = Objects.requireNonNull(variableSet);
        this.index = new EquationSystemIndex(this);
    }

    public VariableSet<V> getVariableSet() {
        return this.variableSet;
    }

    public Variable<V> getVariable(int elementNum, V type) {
        return this.variableSet.getVariable(elementNum, type);
    }

    public StateVector getStateVector() {
        return this.stateVector;
    }

    public EquationSystemIndex<V, E> getIndex() {
        return this.index;
    }

    public Collection<Equation<V, E>> getEquations() {
        return this.equations.values();
    }

    private void indexTerm(EquationTerm<V, E> equationTerm) {
        if (this.equationTermsByElement != null) {
            if (equationTerm.getElementType() != null && equationTerm.getElementNum() != -1) {
                Pair element = Pair.of((Object)((Object)equationTerm.getElementType()), (Object)equationTerm.getElementNum());
                this.equationTermsByElement.computeIfAbsent((Pair<ElementType, Integer>)element, k -> new ArrayList()).add(equationTerm);
            }
            for (EquationTerm<V, E> child : equationTerm.getChildren()) {
                this.indexTerm(child);
            }
        }
    }

    private void indexAllTerms() {
        if (this.equationTermsByElement == null) {
            this.equationTermsByElement = new HashMap<Pair<ElementType, Integer>, List<EquationTerm<V, E>>>();
            for (Equation<V, E> equation : this.equations.values()) {
                for (EquationTerm<V, E> term : equation.getTerms()) {
                    this.indexTerm(term);
                }
            }
        }
    }

    void addEquationTerm(EquationTerm<V, E> equationTerm) {
        this.indexTerm(equationTerm);
        this.attach(equationTerm);
    }

    public List<EquationTerm<V, E>> getEquationTerms(ElementType elementType, int elementNum) {
        Objects.requireNonNull(elementType);
        this.indexAllTerms();
        Pair element = Pair.of((Object)((Object)elementType), (Object)elementNum);
        return this.equationTermsByElement.getOrDefault(element, Collections.emptyList());
    }

    public <T extends EquationTerm<V, E>> T getEquationTerm(ElementType elementType, int elementNum, Class<T> clazz) {
        return (T)this.getEquationTerms(elementType, elementNum).stream().filter(term -> clazz.isAssignableFrom(term.getClass())).map(clazz::cast).findFirst().orElseThrow(() -> new PowsyblException("Equation term not found"));
    }

    public Equation<V, E> createEquation(LfElement element, E type) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(type);
        if (element.getType() != ((Quantity)type).getElementType()) {
            throw new PowsyblException("Incorrect equation type: " + type);
        }
        Pair p = Pair.of((Object)element.getNum(), type);
        Equation<V, E> equation = this.equations.get(p);
        if (equation == null) {
            equation = this.addEquation(p).setActive(!element.isDisabled());
        }
        return equation;
    }

    public Equation<V, E> createEquation(int num, E type) {
        Pair p = Pair.of((Object)num, type);
        Equation<V, E> equation = this.equations.get(p);
        if (equation == null) {
            equation = this.addEquation(p);
        }
        return equation;
    }

    public Optional<Equation<V, E>> getEquation(int num, E type) {
        Pair p = Pair.of((Object)num, type);
        return Optional.ofNullable(this.equations.get(p));
    }

    public boolean hasEquation(int num, E type) {
        Pair p = Pair.of((Object)num, type);
        return this.equations.containsKey(p);
    }

    private void deindexTerm(EquationTerm<V, E> term) {
        List<EquationTerm<V, E>> termsForThisElement;
        if (term.getElementType() != null && term.getElementNum() != -1 && (termsForThisElement = this.equationTermsByElement.get(Pair.of((Object)((Object)term.getElementType()), (Object)term.getElementNum()))) != null) {
            termsForThisElement.remove(term);
        }
        for (EquationTerm<V, E> child : term.getChildren()) {
            this.deindexTerm(child);
        }
    }

    public Equation<V, E> removeEquation(int num, E type) {
        Pair p = Pair.of((Object)num, type);
        Equation<V, E> equation = this.equations.remove(p);
        if (equation != null) {
            Pair element = Pair.of((Object)((Object)((Quantity)type).getElementType()), (Object)num);
            this.equationsByElement.get(element).remove(equation);
            if (this.equationTermsByElement != null) {
                for (EquationTerm<V, E> term : equation.getTerms()) {
                    this.deindexTerm(term);
                }
            }
            equation.setRemoved();
            this.notifyEquationChange(equation, EquationEventType.EQUATION_REMOVED);
        }
        return equation;
    }

    private Equation<V, E> addEquation(Pair<Integer, E> p) {
        Equation equation = new Equation((Integer)p.getLeft(), (Enum)p.getRight(), this);
        this.equations.put(p, equation);
        Pair element = Pair.of((Object)((Object)((Quantity)((Object)((Enum)p.getRight()))).getElementType()), (Object)((Integer)p.getLeft()));
        this.equationsByElement.computeIfAbsent((Pair<ElementType, Integer>)element, k -> new ArrayList()).add(equation);
        this.notifyEquationChange(equation, EquationEventType.EQUATION_CREATED);
        return equation;
    }

    public List<Equation<V, E>> getEquations(ElementType elementType, int elementNum) {
        Objects.requireNonNull(elementType);
        Pair element = Pair.of((Object)((Object)elementType), (Object)elementNum);
        return this.equationsByElement.getOrDefault(element, Collections.emptyList());
    }

    public void attach(EquationTerm<V, E> term) {
        Objects.requireNonNull(term);
        term.setStateVector(this.stateVector);
    }

    public List<String> getRowNames(LfNetwork network) {
        return this.index.getSortedVariablesToFind().stream().map(eq -> network.getBus(eq.getElementNum()).getId() + "/" + eq.getType()).collect(Collectors.toList());
    }

    public List<String> getColumnNames(LfNetwork network) {
        return this.index.getSortedEquationsToSolve().stream().map(v -> network.getBus(v.getElementNum()).getId() + "/" + v.getType()).collect(Collectors.toList());
    }

    public void addListener(EquationSystemListener<V, E> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void removeListener(EquationSystemListener<V, E> listener) {
        this.listeners.remove(listener);
    }

    void notifyEquationChange(Equation<V, E> equation, EquationEventType eventType) {
        Objects.requireNonNull(equation);
        Objects.requireNonNull(eventType);
        this.listeners.forEach(listener -> listener.onEquationChange(equation, eventType));
    }

    void notifyEquationTermChange(EquationTerm<V, E> term, EquationTermEventType eventType) {
        Objects.requireNonNull(term);
        Objects.requireNonNull(eventType);
        this.listeners.forEach(listener -> listener.onEquationTermChange(term, eventType));
    }

    public void write(Writer writer, boolean writeInactiveEquations) {
        try {
            for (Equation equation : this.equations.values().stream().sorted().collect(Collectors.toList())) {
                if (!writeInactiveEquations && !equation.isActive()) continue;
                if (!equation.isActive()) {
                    writer.write("[ ");
                }
                equation.write(writer, writeInactiveEquations);
                if (!equation.isActive()) {
                    writer.write(" ]");
                }
                writer.write(System.lineSeparator());
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String writeToString(boolean writeInactiveEquations) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            this.write(writer, writeInactiveEquations);
            writer.flush();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        writer.close();
        return string;
    }

    public String writeToString() {
        return this.writeToString(false);
    }
}

