/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationEventType;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationSystemIndexListener;
import com.powsybl.openloadflow.equations.EquationSystemListener;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.EquationTermEventType;
import com.powsybl.openloadflow.equations.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquationSystemIndex<V extends Enum<V>, E extends Enum<E>>
implements EquationSystemListener<V, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EquationSystemIndex.class);
    private final Set<Equation<V, E>> equationsToSolve = new HashSet<Equation<V, E>>();
    private final Map<Variable<V>, MutableInt> variablesToFindRefCount = new HashMap<Variable<V>, MutableInt>();
    private List<Equation<V, E>> sortedEquationsToSolve = Collections.emptyList();
    private List<Variable<V>> sortedVariablesToFind = Collections.emptyList();
    private boolean equationsIndexValid = false;
    private boolean variablesIndexValid = false;
    private final List<EquationSystemIndexListener<V, E>> listeners = new ArrayList<EquationSystemIndexListener<V, E>>();

    public EquationSystemIndex(EquationSystem<V, E> equationSystem) {
        Objects.requireNonNull(equationSystem).addListener(this);
    }

    public void addListener(EquationSystemIndexListener<V, E> listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(EquationSystemIndexListener<V, E> listener) {
        this.listeners.remove(Objects.requireNonNull(listener));
    }

    private void notifyEquationChange(Equation<V, E> equation, EquationSystemIndexListener.ChangeType changeType) {
        this.listeners.forEach(listener -> listener.onEquationChange(equation, changeType));
    }

    private void notifyVariableChange(Variable<V> variable, EquationSystemIndexListener.ChangeType changeType) {
        this.listeners.forEach(listener -> listener.onVariableChange(variable, changeType));
    }

    private void notifyEquationTermChange(EquationTerm<V, E> term) {
        this.listeners.forEach(listener -> listener.onEquationTermChange(term));
    }

    private void update() {
        if (!this.equationsIndexValid) {
            this.sortedEquationsToSolve = this.equationsToSolve.stream().sorted().collect(Collectors.toList());
            int columnCount = 0;
            for (Equation<V, E> equation : this.sortedEquationsToSolve) {
                equation.setColumn(columnCount++);
            }
            this.equationsIndexValid = true;
            LOGGER.debug("Equations index updated ({} columns)", (Object)columnCount);
        }
        if (!this.variablesIndexValid) {
            this.sortedVariablesToFind = this.variablesToFindRefCount.keySet().stream().sorted().collect(Collectors.toList());
            int rowCount = 0;
            for (Variable variable : this.sortedVariablesToFind) {
                variable.setRow(rowCount++);
            }
            this.variablesIndexValid = true;
            LOGGER.debug("Variables index updated ({} rows)", (Object)rowCount);
        }
    }

    private void addTerm(EquationTerm<V, E> term) {
        this.notifyEquationTermChange(term);
        for (Variable<V> variable : term.getVariables()) {
            MutableInt variableRefCount = this.variablesToFindRefCount.get(variable);
            if (variableRefCount == null) {
                variableRefCount = new MutableInt(1);
                this.variablesToFindRefCount.put(variable, variableRefCount);
                this.variablesIndexValid = false;
                this.notifyVariableChange(variable, EquationSystemIndexListener.ChangeType.ADDED);
                continue;
            }
            variableRefCount.increment();
        }
    }

    private void addEquation(Equation<V, E> equation) {
        this.equationsToSolve.add(equation);
        this.equationsIndexValid = false;
        for (EquationTerm<V, E> term : equation.getTerms()) {
            if (!term.isActive()) continue;
            this.addTerm(term);
        }
        this.notifyEquationChange(equation, EquationSystemIndexListener.ChangeType.ADDED);
    }

    private void removeTerm(EquationTerm<V, E> term) {
        this.notifyEquationTermChange(term);
        for (Variable<V> variable : term.getVariables()) {
            MutableInt variableRefCount = this.variablesToFindRefCount.get(variable);
            if (variableRefCount == null) continue;
            variableRefCount.decrement();
            if (variableRefCount.intValue() != 0) continue;
            variable.setRow(-1);
            this.variablesToFindRefCount.remove(variable);
            this.variablesIndexValid = false;
            this.notifyVariableChange(variable, EquationSystemIndexListener.ChangeType.REMOVED);
        }
    }

    private void removeEquation(Equation<V, E> equation) {
        equation.setColumn(-1);
        this.equationsToSolve.remove(equation);
        this.equationsIndexValid = false;
        for (EquationTerm<V, E> term : equation.getTerms()) {
            if (!term.isActive()) continue;
            this.removeTerm(term);
        }
        this.notifyEquationChange(equation, EquationSystemIndexListener.ChangeType.REMOVED);
    }

    @Override
    public void onEquationChange(Equation<V, E> equation, EquationEventType eventType) {
        switch (eventType) {
            case EQUATION_REMOVED: {
                if (!equation.isActive()) break;
                this.removeEquation(equation);
                break;
            }
            case EQUATION_DEACTIVATED: {
                this.removeEquation(equation);
                break;
            }
            case EQUATION_CREATED: {
                if (!equation.isActive()) break;
                this.addEquation(equation);
                break;
            }
            case EQUATION_ACTIVATED: {
                this.addEquation(equation);
                break;
            }
            default: {
                throw new IllegalStateException("Event type not supported: " + eventType);
            }
        }
    }

    @Override
    public void onEquationTermChange(EquationTerm<V, E> term, EquationTermEventType eventType) {
        if (term.getEquation().isActive()) {
            switch (eventType) {
                case EQUATION_TERM_ADDED: {
                    if (!term.isActive()) break;
                    this.addTerm(term);
                    break;
                }
                case EQUATION_TERM_ACTIVATED: {
                    this.addTerm(term);
                    break;
                }
                case EQUATION_TERM_DEACTIVATED: {
                    this.removeTerm(term);
                    break;
                }
                default: {
                    throw new IllegalStateException("Event type not supported: " + eventType);
                }
            }
        }
    }

    public List<Equation<V, E>> getSortedEquationsToSolve() {
        this.update();
        return this.sortedEquationsToSolve;
    }

    public List<Variable<V>> getSortedVariablesToFind() {
        this.update();
        return this.sortedVariablesToFind;
    }
}

