/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.StateVector;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.util.Derivable;
import com.powsybl.openloadflow.util.Evaluable;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleSupplier;

public interface EquationTerm<V extends Enum<V>, E extends Enum<E>>
extends Derivable<V> {
    public static void setActive(Evaluable evaluable, boolean active) {
        if (evaluable instanceof EquationTerm) {
            EquationTerm term = (EquationTerm)evaluable;
            term.setActive(active);
        }
    }

    public static <V extends Enum<V>, E extends Enum<E>> EquationTerm<V, E> multiply(EquationTerm<V, E> term, DoubleSupplier scalarSupplier) {
        return new MultiplyByScalarEquationTerm<V, E>(term, scalarSupplier);
    }

    public static <V extends Enum<V>, E extends Enum<E>> EquationTerm<V, E> multiply(EquationTerm<V, E> term, double scalar) {
        return new MultiplyByScalarEquationTerm<V, E>(term, scalar);
    }

    public List<EquationTerm<V, E>> getChildren();

    public Equation<V, E> getEquation();

    public void setEquation(Equation<V, E> var1);

    @Override
    public boolean isActive();

    public void setActive(boolean var1);

    public void setSelf(EquationTerm<V, E> var1);

    public ElementType getElementType();

    public int getElementNum();

    public List<Variable<V>> getVariables();

    public void setStateVector(StateVector var1);

    @Override
    public double eval();

    @Override
    default public double eval(StateVector sv) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public double der(Variable<V> var1);

    public boolean hasRhs();

    public double rhs();

    @Override
    public double calculateSensi(DenseMatrix var1, int var2);

    public void write(Writer var1) throws IOException;

    default public EquationTerm<V, E> multiply(DoubleSupplier scalarSupplier) {
        return EquationTerm.multiply(this, scalarSupplier);
    }

    default public EquationTerm<V, E> multiply(double scalar) {
        return EquationTerm.multiply(this, scalar);
    }

    default public EquationTerm<V, E> minus() {
        return this.multiply(-1.0);
    }

    public static class MultiplyByScalarEquationTerm<V extends Enum<V>, E extends Enum<E>>
    implements EquationTerm<V, E> {
        private final EquationTerm<V, E> term;
        private final DoubleSupplier scalarSupplier;

        MultiplyByScalarEquationTerm(EquationTerm<V, E> term, double scalar) {
            this(term, () -> scalar);
        }

        MultiplyByScalarEquationTerm(EquationTerm<V, E> term, DoubleSupplier scalarSupplier) {
            this.term = Objects.requireNonNull(term);
            this.scalarSupplier = Objects.requireNonNull(scalarSupplier);
            term.setSelf(this);
        }

        @Override
        public List<EquationTerm<V, E>> getChildren() {
            return Collections.singletonList(this.term);
        }

        @Override
        public Equation<V, E> getEquation() {
            return this.term.getEquation();
        }

        @Override
        public void setEquation(Equation<V, E> equation) {
            this.term.setEquation(equation);
        }

        @Override
        public void setActive(boolean active) {
            this.term.setActive(active);
        }

        @Override
        public boolean isActive() {
            return this.term.isActive();
        }

        @Override
        public void setSelf(EquationTerm<V, E> self) {
            this.term.setSelf(self);
        }

        @Override
        public ElementType getElementType() {
            return null;
        }

        @Override
        public int getElementNum() {
            return -1;
        }

        @Override
        public List<Variable<V>> getVariables() {
            return this.term.getVariables();
        }

        @Override
        public void setStateVector(StateVector sv) {
            this.term.setStateVector(sv);
        }

        @Override
        public double eval() {
            return this.scalarSupplier.getAsDouble() * this.term.eval();
        }

        @Override
        public double der(Variable<V> variable) {
            return this.scalarSupplier.getAsDouble() * this.term.der(variable);
        }

        @Override
        public boolean hasRhs() {
            return this.term.hasRhs();
        }

        @Override
        public double rhs() {
            return this.scalarSupplier.getAsDouble() * this.term.rhs();
        }

        @Override
        public double calculateSensi(DenseMatrix x, int column) {
            return this.scalarSupplier.getAsDouble() * this.term.calculateSensi(x, column);
        }

        @Override
        public void write(Writer writer) throws IOException {
            writer.write(Double.toString(this.scalarSupplier.getAsDouble()));
            writer.write(" * ");
            this.term.write(writer);
        }
    }
}

