/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.google.common.base.Stopwatch;
import com.powsybl.openloadflow.equations.AbstractVector;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.StateVectorListener;
import com.powsybl.openloadflow.util.Markers;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EquationVector<V extends Enum<V>, E extends Enum<E>>
extends AbstractVector<V, E>
implements StateVectorListener,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EquationVector.class);

    public EquationVector(EquationSystem<V, E> equationSystem) {
        super(equationSystem);
        equationSystem.getStateVector().addListener(this);
    }

    @Override
    public void onStateUpdate() {
        this.invalidateValues();
    }

    @Override
    protected double[] createArray() {
        double[] array = new double[this.equationSystem.getIndex().getSortedEquationsToSolve().size()];
        this.updateArray(array);
        return array;
    }

    private void eval(double[] array, List<Equation<V, E>> equations) {
        Arrays.fill(array, 0.0);
        for (Equation<V, E> equation : equations) {
            array[equation.getColumn()] = equation.eval();
        }
    }

    @Override
    protected void updateArray(double[] array) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List equations = this.equationSystem.getIndex().getSortedEquationsToSolve();
        if (array.length != equations.size()) {
            throw new IllegalArgumentException("Bad equation vector length: " + array.length);
        }
        this.eval(array, equations);
        LOGGER.debug(Markers.PERFORMANCE_MARKER, "Equation vector updated in {} us", (Object)stopwatch.elapsed(TimeUnit.MICROSECONDS));
    }

    @Override
    public void close() {
        this.equationSystem.getStateVector().removeListener(this);
    }
}

