/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.google.common.base.Stopwatch;
import com.powsybl.commons.PowsyblException;
import com.powsybl.math.matrix.DenseMatrix;
import com.powsybl.math.matrix.LUDecomposition;
import com.powsybl.math.matrix.Matrix;
import com.powsybl.math.matrix.MatrixFactory;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationSystemIndexListener;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.StateVectorListener;
import com.powsybl.openloadflow.equations.Variable;
import com.powsybl.openloadflow.util.Markers;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacobianMatrix<V extends Enum<V>, E extends Enum<E>>
implements EquationSystemIndexListener<V, E>,
StateVectorListener,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacobianMatrix.class);
    private final EquationSystem<V, E> equationSystem;
    private final MatrixFactory matrixFactory;
    private Matrix matrix;
    private LUDecomposition lu;
    private Status status = Status.STRUCTURE_INVALID;

    public JacobianMatrix(EquationSystem<V, E> equationSystem, MatrixFactory matrixFactory) {
        this.equationSystem = Objects.requireNonNull(equationSystem);
        this.matrixFactory = Objects.requireNonNull(matrixFactory);
        equationSystem.getIndex().addListener(this);
        equationSystem.getStateVector().addListener(this);
    }

    protected void updateStatus(Status status) {
        if (status.ordinal() > this.status.ordinal()) {
            this.status = status;
        }
    }

    @Override
    public void onEquationChange(Equation<V, E> equation, EquationSystemIndexListener.ChangeType changeType) {
        this.updateStatus(Status.STRUCTURE_INVALID);
    }

    @Override
    public void onVariableChange(Variable<V> variable, EquationSystemIndexListener.ChangeType changeType) {
        this.updateStatus(Status.STRUCTURE_INVALID);
    }

    @Override
    public void onEquationTermChange(EquationTerm<V, E> term) {
        this.updateStatus(Status.VALUES_AND_ZEROS_INVALID);
    }

    @Override
    public void onStateUpdate() {
        this.updateStatus(Status.VALUES_INVALID);
    }

    private void initDer() {
        int columnCount;
        Stopwatch stopwatch = Stopwatch.createStarted();
        int rowCount = this.equationSystem.getIndex().getSortedEquationsToSolve().size();
        if (rowCount != (columnCount = this.equationSystem.getIndex().getSortedVariablesToFind().size())) {
            throw new PowsyblException("Expected to have same number of equations (" + rowCount + ") and variables (" + columnCount + ")");
        }
        int estimatedNonZeroValueCount = rowCount * 3;
        this.matrix = this.matrixFactory.create(rowCount, columnCount, estimatedNonZeroValueCount);
        for (Equation eq : this.equationSystem.getIndex().getSortedEquationsToSolve()) {
            int column = eq.getColumn();
            eq.der((variable, value, matrixElementIndex) -> {
                int row = variable.getRow();
                return this.matrix.addAndGetIndex(row, column, value);
            });
        }
        LOGGER.debug(Markers.PERFORMANCE_MARKER, "Jacobian matrix built in {} us", (Object)stopwatch.elapsed(TimeUnit.MICROSECONDS));
    }

    private void clearLu() {
        if (this.lu != null) {
            this.lu.close();
        }
        this.lu = null;
    }

    private void initMatrix() {
        this.initDer();
        this.clearLu();
    }

    private void updateDer() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.matrix.reset();
        for (Equation eq : this.equationSystem.getIndex().getSortedEquationsToSolve()) {
            eq.der((variable, value, matrixElementIndex) -> {
                this.matrix.addAtIndex(matrixElementIndex, value);
                return matrixElementIndex;
            });
        }
        LOGGER.debug(Markers.PERFORMANCE_MARKER, "Jacobian matrix values updated in {} us", (Object)stopwatch.elapsed(TimeUnit.MICROSECONDS));
    }

    private void updateLu(boolean allowIncrementalUpdate) {
        if (this.lu != null) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.lu.update(allowIncrementalUpdate);
            LOGGER.debug(Markers.PERFORMANCE_MARKER, "LU decomposition updated in {} us", (Object)stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
    }

    private void updateValues(boolean allowIncrementalUpdate) {
        this.updateDer();
        this.updateLu(allowIncrementalUpdate);
    }

    public void forceUpdate() {
        this.update();
    }

    private void update() {
        if (this.status != Status.VALID) {
            switch (this.status) {
                case STRUCTURE_INVALID: {
                    this.initMatrix();
                    break;
                }
                case VALUES_INVALID: {
                    this.updateValues(true);
                    break;
                }
                case VALUES_AND_ZEROS_INVALID: {
                    this.updateValues(false);
                    break;
                }
            }
            this.status = Status.VALID;
        }
    }

    public Matrix getMatrix() {
        this.update();
        return this.matrix;
    }

    private LUDecomposition getLUDecomposition() {
        Matrix m = this.getMatrix();
        if (this.lu == null) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.lu = m.decomposeLU();
            LOGGER.debug(Markers.PERFORMANCE_MARKER, "LU decomposition done in {} us", (Object)stopwatch.elapsed(TimeUnit.MICROSECONDS));
        }
        return this.lu;
    }

    public void solve(double[] b) {
        this.getLUDecomposition().solve(b);
    }

    public void solveTransposed(double[] b) {
        this.getLUDecomposition().solveTransposed(b);
    }

    public void solve(DenseMatrix b) {
        this.getLUDecomposition().solve(b);
    }

    public void solveTransposed(DenseMatrix b) {
        this.getLUDecomposition().solveTransposed(b);
    }

    @Override
    public void close() {
        this.equationSystem.getIndex().removeListener(this);
        this.equationSystem.getStateVector().removeListener(this);
        this.matrix = null;
        this.clearLu();
    }

    protected static enum Status {
        VALID,
        VALUES_INVALID,
        VALUES_AND_ZEROS_INVALID,
        STRUCTURE_INVALID;

    }
}

