/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.openloadflow.equations.AbstractVector;
import com.powsybl.openloadflow.equations.Equation;
import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.network.AbstractLfNetworkListener;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import java.util.List;
import java.util.Objects;

public class TargetVector<V extends Enum<V>, E extends Enum<E>>
extends AbstractVector<V, E>
implements AutoCloseable {
    private final LfNetwork network;
    private final Initializer<V, E> initializer;
    private final LfNetworkListener networkListener = new AbstractLfNetworkListener(){

        @Override
        public void onGeneratorVoltageControlTargetChange(GeneratorVoltageControl control, double newTargetVoltage) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onTransformerVoltageControlTargetChange(TransformerVoltageControl transformerVoltageControl, double newTargetVoltage) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onLoadActivePowerTargetChange(LfLoad load, double oldTargetP, double newTargetP) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onLoadReactivePowerTargetChange(LfLoad load, double oldTargetQ, double newTargetQ) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onGenerationActivePowerTargetChange(LfGenerator generator, double oldGenerationTargetP, double newGenerationTargetP) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onGenerationReactivePowerTargetChange(LfBus bus, double oldGenerationTargetQ, double newGenerationTargetQ) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onTapPositionChange(LfBranch branch, int oldPosition, int newPosition) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onShuntSusceptanceChange(LfShunt shunt, double b) {
            TargetVector.this.invalidateValues();
        }

        @Override
        public void onDisableChange(LfElement element, boolean disabled) {
            for (EquationTerm equationTerm : TargetVector.this.equationSystem.getEquationTerms(element.getType(), element.getNum())) {
                if (!equationTerm.hasRhs()) continue;
                TargetVector.this.invalidateValues();
            }
        }
    };

    public TargetVector(LfNetwork network, EquationSystem<V, E> equationSystem, Initializer<V, E> initializer) {
        super(equationSystem);
        this.network = Objects.requireNonNull(network);
        this.initializer = Objects.requireNonNull(initializer);
        network.addListener(this.networkListener);
    }

    public static <V extends Enum<V>, E extends Enum<E>> double[] createArray(LfNetwork network, EquationSystem<V, E> equationSystem, Initializer<V, E> initializer) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(equationSystem);
        Objects.requireNonNull(initializer);
        List<Equation<V, E>> sortedEquationsToSolve = equationSystem.getIndex().getSortedEquationsToSolve();
        double[] array = new double[sortedEquationsToSolve.size()];
        for (Equation<V, E> equation : sortedEquationsToSolve) {
            initializer.initialize(equation, network, array);
        }
        return array;
    }

    @Override
    protected double[] createArray() {
        return TargetVector.createArray(this.network, this.equationSystem, this.initializer);
    }

    @Override
    protected void updateArray(double[] array) {
        List sortedEquationsToSolve = this.equationSystem.getIndex().getSortedEquationsToSolve();
        for (Equation equation : sortedEquationsToSolve) {
            this.initializer.initialize(equation, this.network, array);
        }
    }

    @Override
    public void close() {
        this.network.removeListener(this.networkListener);
    }

    @FunctionalInterface
    public static interface Initializer<V extends Enum<V>, E extends Enum<E>> {
        public void initialize(Equation<V, E> var1, LfNetwork var2, double[] var3);
    }
}

