/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import com.powsybl.openloadflow.equations.EquationTerm;
import com.powsybl.openloadflow.equations.Quantity;
import com.powsybl.openloadflow.equations.VariableEquationTerm;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class Variable<V extends Enum<V>>
implements Comparable<Variable<V>> {
    private final int elementNum;
    private final V type;
    private int row = -1;

    Variable(int elementNum, V type) {
        this.elementNum = elementNum;
        this.type = (Enum)Objects.requireNonNull(type);
    }

    public int getElementNum() {
        return this.elementNum;
    }

    public V getType() {
        return this.type;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int hashCode() {
        return this.elementNum + ((Enum)this.type).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Variable) {
            Variable variable = (Variable)obj;
            return this.compareTo(variable) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Variable<V> o) {
        if (o == this) {
            return 0;
        }
        int c = this.elementNum - o.elementNum;
        if (c == 0) {
            c = ((Enum)this.type).ordinal() - ((Enum)o.type).ordinal();
        }
        return c;
    }

    public void write(Writer writer) throws IOException {
        writer.write(((Quantity)this.type).getSymbol());
        writer.write(Integer.toString(this.elementNum));
    }

    public <E extends Enum<E>> EquationTerm<V, E> createTerm() {
        return new VariableEquationTerm(this);
    }

    public String toString() {
        return "Variable(elementNum=" + this.elementNum + ", type=" + this.type + ", row=" + this.row + ")";
    }
}

