/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.equations;

import net.jafama.FastMath;

public final class Vectors {
    private Vectors() {
    }

    public static void minus(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("a and b have different length");
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] - b[i];
        }
    }

    public static void plus(double[] a, double[] b, double c) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("a and b have different length");
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i] * c;
        }
    }

    public static void mult(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] * b;
        }
    }

    public static double norm2(double[] vector) {
        double norm = 0.0;
        for (double v : vector) {
            norm += v * v;
        }
        return FastMath.sqrt((double)norm);
    }
}

