/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.graph;

import com.powsybl.commons.PowsyblException;
import com.powsybl.openloadflow.graph.AbstractGraphConnectivity;
import com.powsybl.openloadflow.graph.EdgeAdd;
import com.powsybl.openloadflow.graph.EdgeRemove;
import com.powsybl.openloadflow.graph.GraphModification;
import com.powsybl.openloadflow.graph.VertexAdd;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graphs;

public class EvenShiloachGraphDecrementalConnectivity<V, E>
extends AbstractGraphConnectivity<V, E> {
    private Map<V, Integer> vertexToConnectedComponent;
    private final List<Set<V>> newConnectedComponents = new ArrayList<Set<V>>();
    private final Map<V, LevelNeighbours> levelNeighboursMap = new HashMap<V, LevelNeighbours>();
    private final Deque<Map<V, LevelNeighbours>> allSavedChangedLevels = new ArrayDeque<Map<V, LevelNeighbours>>();

    @Override
    protected void updateConnectivity(EdgeRemove<V, E> edgeRemoval) {
        this.vertexToConnectedComponent = null;
        this.componentSets = null;
        GraphProcessA processA = new GraphProcessA(edgeRemoval.v1, edgeRemoval.v2);
        GraphProcessB processB = new GraphProcessB(edgeRemoval.v1, edgeRemoval.v2);
        while (!processA.isHalted() && !processB.isHalted()) {
            processA.next();
            if (processA.isHalted()) continue;
            processB.next();
        }
        if (processA.isHalted()) {
            processB.undoChanges();
            this.updateNewConnectedComponents(processA.verticesOut);
        } else {
            this.allSavedChangedLevels.add(processB.savedChangedLevels);
        }
    }

    private void updateNewConnectedComponents(Set<V> verticesOut) {
        this.newConnectedComponents.forEach(cc -> cc.removeAll(verticesOut));
        this.newConnectedComponents.add(verticesOut);
    }

    @Override
    protected void updateConnectivity(EdgeAdd<V, E> edgeAdd) {
        throw new PowsyblException("This implementation does not support incremental connectivity: edges cannot be added once that connectivity is saved");
    }

    @Override
    protected void updateConnectivity(VertexAdd<V, E> vertexAdd) {
        throw new PowsyblException("This implementation does not support incremental connectivity: vertices cannot be added once that connectivity is saved");
    }

    @Override
    protected void resetConnectivity(Deque<GraphModification<V, E>> m) {
        this.vertexToConnectedComponent = null;
        this.componentSets = null;
        this.newConnectedComponents.clear();
        this.allSavedChangedLevels.descendingIterator().forEachRemaining(this.levelNeighboursMap::putAll);
        this.allSavedChangedLevels.clear();
    }

    @Override
    protected void updateComponents() {
        this.computeConnectivity();
    }

    @Override
    public boolean supportTemporaryChangesNesting() {
        return false;
    }

    @Override
    public void startTemporaryChanges() {
        if (!this.getModificationsContexts().isEmpty()) {
            throw new PowsyblException("This implementation supports only one level of temporary changes");
        }
        super.startTemporaryChanges();
        if (this.levelNeighboursMap.isEmpty()) {
            Set vertices = this.getGraph().vertexSet();
            vertices.stream().max(Comparator.comparingInt(v -> this.getGraph().degreeOf(v))).ifPresent(v -> this.buildLevelNeighbours(Collections.singleton(v), 0));
            if (vertices.size() > this.levelNeighboursMap.size()) {
                throw new PowsyblException("This implementation does not support saving a graph with several connected components");
            }
        }
    }

    private void buildLevelNeighbours(Collection<V> level, int levelIndex) {
        HashSet nextLevel = new HashSet();
        for (V v : level) {
            LevelNeighbours neighbours = this.levelNeighboursMap.computeIfAbsent((LevelNeighbours)v, (Function<LevelNeighbours, LevelNeighbours>)((Function<Object, LevelNeighbours>)value -> new LevelNeighbours(levelIndex)));
            for (Object adj : Graphs.neighborListOf(this.getGraph(), v)) {
                LevelNeighbours adjNeighbours = this.levelNeighboursMap.computeIfAbsent((LevelNeighbours)adj, (Function<LevelNeighbours, LevelNeighbours>)((Function<Object, LevelNeighbours>)value -> new LevelNeighbours(levelIndex + 1)));
                this.fillNeighbours(neighbours, adj, adjNeighbours.level);
            }
            nextLevel.addAll(neighbours.upperLevel);
        }
        if (!nextLevel.isEmpty()) {
            this.buildLevelNeighbours(nextLevel, levelIndex + 1);
        }
    }

    @Override
    protected int getQuickComponentNumber(V vertex) {
        Integer ccIndex = this.getVertexToConnectedComponentMap().get(vertex);
        return ccIndex != null ? ccIndex : 0;
    }

    private Map<V, Integer> getVertexToConnectedComponentMap() {
        if (this.vertexToConnectedComponent == null) {
            this.vertexToConnectedComponent = new HashMap<V, Integer>();
            int i = 0;
            for (Set newConnectedComponent : this.getSmallComponents()) {
                int indxCC = ++i;
                newConnectedComponent.forEach(v -> this.vertexToConnectedComponent.put((Integer)v, indxCC));
            }
        }
        return this.vertexToConnectedComponent;
    }

    @Override
    public Set<V> getConnectedComponent(V vertex) {
        int componentNumber = this.getComponentNumber(vertex);
        if (componentNumber == 0) {
            this.computeMainConnectedComponent();
        }
        return (Set)this.componentSets.get(componentNumber);
    }

    @Override
    public Set<V> getLargestConnectedComponent() {
        this.checkSavedContext();
        this.updateComponents();
        this.computeMainConnectedComponent();
        return (Set)this.componentSets.get(0);
    }

    private void computeMainConnectedComponent() {
        if (this.componentSets.get(0) == null) {
            HashSet mainConnectedComponent = new HashSet(this.getGraph().vertexSet());
            this.getSmallComponents().forEach(mainConnectedComponent::removeAll);
            this.componentSets.set(0, mainConnectedComponent);
        }
    }

    @Override
    public Set<V> getNonConnectedVertices(V vertex) {
        int componentNumber = this.getComponentNumber(vertex);
        if (componentNumber != 0) {
            this.computeMainConnectedComponent();
        }
        ArrayList nonConnectedComponents = new ArrayList(this.componentSets);
        nonConnectedComponents.remove(componentNumber);
        return nonConnectedComponents.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private void computeConnectivity() {
        if (this.componentSets != null) {
            return;
        }
        this.componentSets = new ArrayList();
        this.componentSets.add(null);
        this.newConnectedComponents.sort(Comparator.comparingInt(c -> -c.size()));
        this.componentSets.addAll(this.newConnectedComponents);
        int nbVerticesOut = this.newConnectedComponents.stream().mapToInt(Set::size).sum();
        int maxNewComponentsSize = this.newConnectedComponents.stream().findFirst().map(Set::size).orElse(0);
        Set vertices = this.getGraph().vertexSet();
        if (vertices.size() - nbVerticesOut < maxNewComponentsSize) {
            this.computeMainConnectedComponent();
            this.componentSets.sort(Comparator.comparingInt(c -> -c.size()));
        }
    }

    private void fillNeighbours(LevelNeighbours neighbours, V neighbour, int neighbourLevel) {
        switch (neighbourLevel - neighbours.level) {
            case -1: {
                neighbours.lowerLevel.add(neighbour);
                break;
            }
            case 0: {
                neighbours.sameLevel.add(neighbour);
                break;
            }
            case 1: {
                neighbours.upperLevel.add(neighbour);
                break;
            }
            default: {
                throw new PowsyblException("Unexpected level for vertex " + neighbour);
            }
        }
    }

    private class GraphProcessA
    implements GraphProcess {
        private final Traverser t1;
        private final Traverser t2;
        private Set<V> verticesOut;

        public GraphProcessA(V vertex1, V vertex2) {
            LinkedHashSet visitedVerticesT1 = new LinkedHashSet();
            LinkedHashSet visitedVerticesT2 = new LinkedHashSet();
            this.t1 = new Traverser(vertex1, visitedVerticesT2, visitedVerticesT1);
            this.t2 = new Traverser(vertex2, visitedVerticesT1, visitedVerticesT2);
            this.verticesOut = null;
        }

        @Override
        public void next() {
            if (this.t1.hasEnded() || this.t2.hasEnded() || this.isHalted()) {
                return;
            }
            if (this.t1.componentBreakDetected()) {
                this.verticesOut = this.t1.visitedVertices;
                return;
            }
            this.t1.next();
            if (this.t2.componentBreakDetected()) {
                this.verticesOut = this.t2.visitedVertices;
                return;
            }
            this.t2.next();
        }

        @Override
        public boolean isHalted() {
            return this.verticesOut != null;
        }
    }

    private class GraphProcessB
    implements GraphProcess {
        private final Deque<V> verticesToUpdate;
        private final Map<V, LevelNeighbours> savedChangedLevels;
        private final V vertex1;
        private final V vertex2;
        private boolean init;

        public GraphProcessB(V vertex1, V vertex2) {
            this.vertex1 = vertex1;
            this.vertex2 = vertex2;
            this.verticesToUpdate = new LinkedList();
            this.savedChangedLevels = new HashMap();
            this.init = false;
        }

        private void initialStep() {
            LevelNeighbours ln1 = this.getLevelNeighbour(this.vertex1);
            LevelNeighbours ln2 = this.getLevelNeighbour(this.vertex2);
            if (ln1.level == ln2.level) {
                ln1.sameLevel.remove(this.vertex2);
                ln2.sameLevel.remove(this.vertex1);
            } else {
                Object vertexLowLevel = ln1.level < ln2.level ? this.vertex1 : this.vertex2;
                Object vertexBigLevel = ln1.level < ln2.level ? this.vertex2 : this.vertex1;
                LevelNeighbours nLowLevel = ln1.level < ln2.level ? ln1 : ln2;
                LevelNeighbours nBigLevel = ln1.level < ln2.level ? ln2 : ln1;
                nLowLevel.upperLevel.remove(vertexBigLevel);
                nBigLevel.lowerLevel.remove(vertexLowLevel);
                if (nBigLevel.lowerLevel.isEmpty() && EvenShiloachGraphDecrementalConnectivity.this.getGraph().getAllEdges(this.vertex1, this.vertex2).isEmpty()) {
                    this.verticesToUpdate.add(vertexBigLevel);
                }
            }
        }

        private LevelNeighbours getLevelNeighbour(V v) {
            LevelNeighbours levelNeighbours = EvenShiloachGraphDecrementalConnectivity.this.levelNeighboursMap.get(v);
            this.savedChangedLevels.computeIfAbsent((LevelNeighbours)v, (Function<LevelNeighbours, LevelNeighbours>)((Function<Object, LevelNeighbours>)vertex -> new LevelNeighbours(levelNeighbours)));
            return levelNeighbours;
        }

        @Override
        public void next() {
            if (!this.init) {
                this.initialStep();
                this.init = true;
            }
            if (this.verticesToUpdate.isEmpty()) {
                return;
            }
            Object w = this.verticesToUpdate.removeFirst();
            LevelNeighbours levelNeighbours = this.getLevelNeighbour(w);
            ++levelNeighbours.level;
            for (Object localNeighbour : levelNeighbours.sameLevel) {
                if (w == localNeighbour) continue;
                LevelNeighbours lnln = this.getLevelNeighbour(localNeighbour);
                lnln.sameLevel.remove(w);
                lnln.upperLevel.add(w);
            }
            levelNeighbours.lowerLevel.addAll(levelNeighbours.sameLevel);
            for (Object upperNeighbour : levelNeighbours.upperLevel) {
                LevelNeighbours lnun = this.getLevelNeighbour(upperNeighbour);
                lnun.lowerLevel.remove(w);
                lnun.sameLevel.add(w);
                if (!lnun.lowerLevel.isEmpty()) continue;
                this.verticesToUpdate.add(upperNeighbour);
            }
            levelNeighbours.sameLevel.clear();
            levelNeighbours.sameLevel.addAll(levelNeighbours.upperLevel);
            levelNeighbours.upperLevel.clear();
            if (levelNeighbours.lowerLevel.isEmpty()) {
                this.verticesToUpdate.add(w);
            }
        }

        @Override
        public boolean isHalted() {
            return this.init && this.verticesToUpdate.isEmpty();
        }

        public void undoChanges() {
            EvenShiloachGraphDecrementalConnectivity.this.levelNeighboursMap.putAll(this.savedChangedLevels);
            this.savedChangedLevels.clear();
            this.verticesToUpdate.clear();
        }
    }

    private class LevelNeighbours {
        private final Collection<V> lowerLevel = new LinkedList();
        private final Collection<V> sameLevel = new LinkedList();
        private final Collection<V> upperLevel = new LinkedList();
        private int level;

        public LevelNeighbours(int level) {
            this.level = level;
        }

        public LevelNeighbours(LevelNeighbours origin) {
            this.level = origin.level;
            this.lowerLevel.addAll(origin.lowerLevel);
            this.sameLevel.addAll(origin.sameLevel);
            this.upperLevel.addAll(origin.upperLevel);
        }
    }

    private class Traverser {
        private final Set<V> visitedVertices;
        private final Deque<V> verticesToTraverse;
        private final Set<V> vertexEnd;
        private boolean ended;

        public Traverser(V vertexStart, Set<V> vertexEnd, Set<V> visitedVertices) {
            this.vertexEnd = vertexEnd;
            this.visitedVertices = visitedVertices;
            this.visitedVertices.add(vertexStart);
            this.verticesToTraverse = new LinkedList();
            this.verticesToTraverse.add(vertexStart);
            this.ended = vertexEnd.contains(vertexStart);
        }

        public void next() {
            Object v = this.verticesToTraverse.removeLast();
            for (Object adj : Graphs.neighborListOf(EvenShiloachGraphDecrementalConnectivity.this.getGraph(), v)) {
                if (!this.visitedVertices.add(adj)) continue;
                this.verticesToTraverse.add(adj);
                if (!this.vertexEnd.contains(adj)) continue;
                this.ended = true;
                return;
            }
        }

        public boolean componentBreakDetected() {
            return this.verticesToTraverse.isEmpty();
        }

        public boolean hasEnded() {
            return this.ended;
        }
    }

    private static interface GraphProcess {
        public void next();

        public boolean isHalted();
    }
}

