/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.graph;

import com.powsybl.openloadflow.graph.AbstractEdgeModification;
import com.powsybl.openloadflow.graph.EdgeAdd;
import com.powsybl.openloadflow.graph.EdgeRemove;
import com.powsybl.openloadflow.graph.GraphModification;
import com.powsybl.openloadflow.graph.VertexAdd;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.Graph;

public class ModificationsContext<V, E> {
    private final Deque<GraphModification<V, E>> modifications = new ArrayDeque<GraphModification<V, E>>();
    private final Function<V, Set<V>> verticesNotInMainComponentGetter;
    private Set<V> verticesNotInMainComponentBefore;
    private Set<V> verticesAddedToMainComponent;
    private Set<V> verticesRemovedFromMainComponent;
    private Set<E> edgesAddedToMainComponent;
    private Set<E> edgesRemovedFromMainComponent;
    private Map<E, AbstractEdgeModification<V, E>> edgeFirstModificationMap;
    private V mainComponentVertex;

    public ModificationsContext(Function<V, Set<V>> verticesNotInMainComponentGetter, V mainComponentVertex) {
        this.mainComponentVertex = mainComponentVertex;
        this.verticesNotInMainComponentGetter = verticesNotInMainComponentGetter;
    }

    public void computeVerticesNotInMainComponentBefore() {
        this.verticesNotInMainComponentBefore = this.verticesNotInMainComponentGetter.apply(this.mainComponentVertex);
    }

    public void add(GraphModification<V, E> graphModification) {
        this.invalidateComparisons();
        this.modifications.add(graphModification);
    }

    private void invalidateComparisons() {
        this.verticesAddedToMainComponent = null;
        this.edgesAddedToMainComponent = null;
        this.verticesRemovedFromMainComponent = null;
        this.edgesRemovedFromMainComponent = null;
        this.edgeFirstModificationMap = null;
    }

    public Deque<GraphModification<V, E>> getModifications() {
        return this.modifications;
    }

    public Set<E> getEdgesRemovedFromMainComponent(Graph<V, E> graph) {
        if (this.edgesRemovedFromMainComponent == null) {
            this.edgesRemovedFromMainComponent = this.computeEdgesRemovedFromMainComponent(graph);
        }
        return this.edgesRemovedFromMainComponent;
    }

    public Set<V> getVerticesRemovedFromMainComponent() {
        if (this.verticesRemovedFromMainComponent == null) {
            HashSet<V> result = new HashSet<V>(this.getVerticesNotInMainComponentAfter());
            result.removeAll(this.verticesNotInMainComponentBefore);
            if (!result.isEmpty()) {
                this.getAddedVertexStream().forEach(result::remove);
            }
            this.verticesRemovedFromMainComponent = result;
        }
        return this.verticesRemovedFromMainComponent;
    }

    public Set<E> getEdgesAddedToMainComponent(Graph<V, E> graph) {
        if (this.edgesAddedToMainComponent == null) {
            this.edgesAddedToMainComponent = this.computeEdgesAddedToMainComponent(graph);
        }
        return this.edgesAddedToMainComponent;
    }

    public Set<V> getVerticesAddedToMainComponent() {
        if (this.verticesAddedToMainComponent == null) {
            HashSet<V> result = new HashSet<V>(this.verticesNotInMainComponentBefore);
            Set verticesNotInMainComponentAfter = this.getVerticesNotInMainComponentAfter();
            result.removeAll(verticesNotInMainComponentAfter);
            this.getAddedVertexStream().filter(addedVertex -> !verticesNotInMainComponentAfter.contains(addedVertex)).forEach(result::add);
            this.verticesAddedToMainComponent = result;
        }
        return this.verticesAddedToMainComponent;
    }

    private Set<V> getVerticesNotInMainComponentAfter() {
        return this.verticesNotInMainComponentGetter.apply(this.mainComponentVertex);
    }

    private Set<E> computeEdgesRemovedFromMainComponent(Graph<V, E> graph) {
        Set<V> verticesRemoved = this.getVerticesRemovedFromMainComponent();
        Set result = verticesRemoved.stream().map(arg_0 -> graph.edgesOf(arg_0)).flatMap(Collection::stream).collect(Collectors.toSet());
        this.computeEdgeFirstModificationMap();
        this.modifications.stream().filter(EdgeAdd.class::isInstance).map(m -> ((EdgeAdd)m).e).filter(arg_0 -> graph.containsEdge(arg_0)).filter(edgeAdded -> !this.graphContainedEdgeBefore(edgeAdded)).forEach(result::remove);
        this.modifications.stream().filter(EdgeRemove.class::isInstance).map(m -> ((EdgeRemove)m).e).filter(edgeRemoved -> !graph.containsEdge(edgeRemoved)).filter(this::graphContainedEdgeBefore).filter(edgeRemoved -> !this.verticesNotInMainComponentBefore.contains(this.edgeFirstModificationMap.get((Object)edgeRemoved).v1)).forEach(result::add);
        return result;
    }

    private Set<E> computeEdgesAddedToMainComponent(Graph<V, E> graph) {
        Set result = this.getVerticesAddedToMainComponent().stream().map(arg_0 -> graph.edgesOf(arg_0)).flatMap(Collection::stream).collect(Collectors.toSet());
        this.computeEdgeFirstModificationMap();
        Set verticesNotInMainComponentAfter = this.getVerticesNotInMainComponentAfter();
        this.modifications.stream().filter(EdgeAdd.class::isInstance).map(m -> ((EdgeAdd)m).e).filter(arg_0 -> graph.containsEdge(arg_0)).filter(edgeAdded -> !this.graphContainedEdgeBefore(edgeAdded)).filter(edgeAdded -> !verticesNotInMainComponentAfter.contains(graph.getEdgeSource(edgeAdded))).forEach(result::add);
        return result;
    }

    private void computeEdgeFirstModificationMap() {
        if (this.edgeFirstModificationMap == null) {
            this.edgeFirstModificationMap = this.modifications.stream().filter(AbstractEdgeModification.class::isInstance).map(m -> (AbstractEdgeModification)m).collect(Collectors.toMap(m -> m.e, m -> m, (m1, m2) -> m1));
        }
    }

    private boolean graphContainedEdgeBefore(E edge) {
        return this.edgeFirstModificationMap.get(edge) instanceof EdgeRemove;
    }

    private Stream<V> getAddedVertexStream() {
        return this.modifications.stream().filter(VertexAdd.class::isInstance).map(m -> ((VertexAdd)m).v);
    }

    public void setMainComponentVertex(V mainComponentVertex) {
        this.invalidateComparisons();
        this.mainComponentVertex = mainComponentVertex;
    }

    public boolean isInMainComponentBefore(V vertex) {
        return !this.verticesNotInMainComponentBefore.contains(vertex);
    }
}

