/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.lf;

import com.powsybl.openloadflow.equations.EquationSystem;
import com.powsybl.openloadflow.equations.JacobianMatrix;
import com.powsybl.openloadflow.lf.AbstractLoadFlowParameters;
import com.powsybl.openloadflow.lf.LoadFlowContext;
import com.powsybl.openloadflow.network.LfNetwork;
import java.util.Objects;

public abstract class AbstractLoadFlowContext<V extends Enum<V>, E extends Enum<E>, P extends AbstractLoadFlowParameters>
implements LoadFlowContext<V, E, P>,
AutoCloseable {
    protected final LfNetwork network;
    protected final P parameters;
    protected EquationSystem<V, E> equationSystem;
    protected JacobianMatrix<V, E> jacobianMatrix;

    protected AbstractLoadFlowContext(LfNetwork network, P parameters) {
        this.network = Objects.requireNonNull(network);
        this.parameters = (AbstractLoadFlowParameters)Objects.requireNonNull(parameters);
    }

    @Override
    public P getParameters() {
        return this.parameters;
    }

    @Override
    public LfNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void close() {
        if (this.jacobianMatrix != null) {
            this.jacobianMatrix.close();
        }
    }
}

