/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.ElementState;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.PiModelArray;

public class BranchState
extends ElementState<LfBranch> {
    private final double a1;
    private final double r1;
    private final boolean phaseControlEnabled;
    private final boolean voltageControlEnabled;
    private Integer tapPosition;
    private Boolean connectedSide1;
    private Boolean connectedSide2;

    public BranchState(LfBranch branch) {
        super(branch);
        PiModel piModel = branch.getPiModel();
        if (piModel instanceof PiModelArray) {
            PiModelArray piModelArray = (PiModelArray)piModel;
            this.tapPosition = piModel.getTapPosition();
            this.a1 = piModelArray.getModifiedA1();
            this.r1 = piModelArray.getModifiedR1();
        } else {
            this.a1 = piModel.getA1();
            this.r1 = piModel.getR1();
        }
        this.phaseControlEnabled = branch.isPhaseControlEnabled();
        this.voltageControlEnabled = branch.isVoltageControlEnabled();
        if (branch.isDisconnectionAllowedSide1()) {
            this.connectedSide1 = branch.isConnectedSide1();
        }
        if (branch.isDisconnectionAllowedSide2()) {
            this.connectedSide2 = branch.isConnectedSide2();
        }
    }

    @Override
    public void restore() {
        super.restore();
        PiModel piModel = ((LfBranch)this.element).getPiModel();
        if (piModel instanceof PiModelArray) {
            piModel.setTapPosition(this.tapPosition);
        }
        piModel.setA1(this.a1);
        piModel.setR1(this.r1);
        ((LfBranch)this.element).setPhaseControlEnabled(this.phaseControlEnabled);
        ((LfBranch)this.element).setVoltageControlEnabled(this.voltageControlEnabled);
        if (this.connectedSide1 != null) {
            ((LfBranch)this.element).setConnectedSide1(this.connectedSide1);
        }
        if (this.connectedSide2 != null) {
            ((LfBranch)this.element).setConnectedSide2(this.connectedSide2);
        }
    }

    public static BranchState save(LfBranch branch) {
        return new BranchState(branch);
    }
}

