/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.BusDcState;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfShunt;
import java.util.Map;
import java.util.stream.Collectors;

public class BusState
extends BusDcState {
    private final double angle;
    private final double voltage;
    private final double generationTargetQ;
    private final boolean voltageControlEnabled;
    private final Boolean shuntVoltageControlEnabled;
    private final Boolean reactiveControlEnabled;
    private final double shuntB;
    private final double shuntG;
    private final double controllerShuntB;
    private final double controllerShuntG;
    private final double svcShuntB;
    private final Map<String, LfGenerator.GeneratorControlType> generatorsControlType;
    private final LfBus.QLimitType qLimitType;

    public BusState(LfBus bus) {
        super(bus);
        this.angle = bus.getAngle();
        this.voltage = bus.getV();
        this.generationTargetQ = bus.getGenerationTargetQ();
        this.voltageControlEnabled = bus.isGeneratorVoltageControlEnabled();
        this.reactiveControlEnabled = bus.isGeneratorReactivePowerControlEnabled();
        LfShunt controllerShunt = bus.getControllerShunt().orElse(null);
        this.shuntVoltageControlEnabled = controllerShunt != null ? Boolean.valueOf(controllerShunt.isVoltageControlEnabled()) : null;
        this.controllerShuntB = controllerShunt != null ? controllerShunt.getB() : Double.NaN;
        this.controllerShuntG = controllerShunt != null ? controllerShunt.getG() : Double.NaN;
        LfShunt shunt = bus.getShunt().orElse(null);
        this.shuntB = shunt != null ? shunt.getB() : Double.NaN;
        this.shuntG = shunt != null ? shunt.getG() : Double.NaN;
        LfShunt svcShunt = bus.getSvcShunt().orElse(null);
        this.svcShuntB = svcShunt != null ? svcShunt.getB() : Double.NaN;
        this.generatorsControlType = bus.getGenerators().stream().collect(Collectors.toMap(LfGenerator::getId, LfGenerator::getGeneratorControlType));
        this.qLimitType = bus.getQLimitType().orElse(null);
    }

    @Override
    protected BusDcState.LoadDcState createLoadState() {
        return new LoadState();
    }

    @Override
    public void restore() {
        super.restore();
        ((LfBus)this.element).setAngle(this.angle);
        ((LfBus)this.element).setV(this.voltage);
        ((LfBus)this.element).setGenerationTargetQ(this.generationTargetQ);
        ((LfBus)this.element).setGeneratorVoltageControlEnabled(this.voltageControlEnabled);
        ((LfBus)this.element).setGeneratorReactivePowerControlEnabled(this.reactiveControlEnabled);
        if (this.shuntVoltageControlEnabled != null) {
            ((LfBus)this.element).getControllerShunt().orElseThrow().setVoltageControlEnabled(this.shuntVoltageControlEnabled);
        }
        if (!Double.isNaN(this.controllerShuntB)) {
            ((LfBus)this.element).getControllerShunt().orElseThrow().setB(this.controllerShuntB);
        }
        if (!Double.isNaN(this.controllerShuntG)) {
            ((LfBus)this.element).getControllerShunt().orElseThrow().setG(this.controllerShuntG);
        }
        if (!Double.isNaN(this.shuntB)) {
            ((LfBus)this.element).getShunt().orElseThrow().setB(this.shuntB);
        }
        if (!Double.isNaN(this.shuntG)) {
            ((LfBus)this.element).getShunt().orElseThrow().setG(this.shuntG);
        }
        if (!Double.isNaN(this.svcShuntB)) {
            ((LfBus)this.element).getSvcShunt().orElseThrow().setB(this.svcShuntB);
        }
        ((LfBus)this.element).getGenerators().forEach(g -> g.setGeneratorControlType(this.generatorsControlType.get(g.getId())));
        ((LfBus)this.element).setQLimitType(this.qLimitType);
    }

    public static BusState save(LfBus bus) {
        return new BusState(bus);
    }

    private static class LoadState
    extends BusDcState.LoadDcState {
        private double loadTargetQ;

        private LoadState() {
        }

        @Override
        protected BusDcState.LoadDcState save(LfLoad load) {
            super.save(load);
            this.loadTargetQ = load.getTargetQ();
            return this;
        }

        @Override
        protected void restore(LfLoad load) {
            super.restore(load);
            load.setTargetQ(this.loadTargetQ);
        }
    }
}

