/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.DisabledBranchStatus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfHvdc;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DisabledNetwork {
    private final Set<LfBus> buses;
    private final Map<LfBranch, DisabledBranchStatus> branchesStatus;
    private final Set<LfHvdc> hvdcs;

    public DisabledNetwork(Set<LfBus> buses, Map<LfBranch, DisabledBranchStatus> branchesStatus, Set<LfHvdc> hvdcs) {
        this.buses = Objects.requireNonNull(buses);
        this.branchesStatus = Objects.requireNonNull(branchesStatus);
        this.hvdcs = Objects.requireNonNull(hvdcs);
    }

    public DisabledNetwork(Set<LfBus> buses, Set<LfBranch> branches, Set<LfHvdc> hvdcs) {
        this(buses, Objects.requireNonNull(branches).stream().collect(Collectors.toMap(Function.identity(), branch -> DisabledBranchStatus.BOTH_SIDES)), hvdcs);
    }

    public DisabledNetwork() {
        this(Collections.emptySet(), Collections.emptySet());
    }

    public DisabledNetwork(Set<LfBus> buses, Set<LfBranch> branches) {
        this(buses, branches, Collections.emptySet());
    }

    public Set<LfBus> getBuses() {
        return this.buses;
    }

    public Set<LfBranch> getBranches() {
        return this.branchesStatus.keySet();
    }

    public Map<LfBranch, DisabledBranchStatus> getBranchesStatus() {
        return this.branchesStatus;
    }

    public Set<LfHvdc> getHvdcs() {
        return this.hvdcs;
    }
}

