/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfElement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ElementState<T extends LfElement> {
    protected final T element;
    protected final boolean disabled;

    public ElementState(T element) {
        this.element = (LfElement)Objects.requireNonNull(element);
        this.disabled = element.isDisabled();
    }

    public void restore() {
        this.element.setDisabled(this.disabled);
    }

    public static <T extends LfElement, U extends ElementState<T>> List<U> save(Collection<T> elements, Function<T, U> save) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(save);
        return elements.stream().map(save).collect(Collectors.toList());
    }

    public static <T extends LfElement, U extends ElementState<T>> void restore(Collection<U> states) {
        Objects.requireNonNull(states);
        states.forEach(ElementState::restore);
    }
}

