/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.ReactivePowerControl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class GeneratorReactivePowerControl
extends ReactivePowerControl {
    private final List<LfBus> controllerBuses = new ArrayList<LfBus>();

    public GeneratorReactivePowerControl(LfBranch controlledBranch, TwoSides controlledSide, double targetValue) {
        super(controlledBranch, controlledSide, targetValue);
    }

    public List<LfBus> getControllerBuses() {
        return this.controllerBuses;
    }

    public void addControllerBus(LfBus controllerBus) {
        this.controllerBuses.add(Objects.requireNonNull(controllerBus));
        controllerBus.setGeneratorReactivePowerControl(this);
        controllerBus.setGeneratorReactivePowerControlEnabled(true);
    }

    public void updateReactiveKeys() {
        double[] reactiveKeys = GeneratorReactivePowerControl.createReactiveKeys(this.controllerBuses, LfGenerator.GeneratorControlType.REMOTE_REACTIVE_POWER);
        for (int i = 0; i < this.controllerBuses.size(); ++i) {
            LfBus controllerBus = this.controllerBuses.get(i);
            if (!controllerBus.isDisabled() && controllerBus.isGeneratorReactivePowerControlEnabled()) continue;
            reactiveKeys[i] = 0.0;
        }
        double reactiveKeysSum = Arrays.stream(reactiveKeys).sum();
        for (int i = 0; i < this.controllerBuses.size(); ++i) {
            LfBus controllerBus = this.controllerBuses.get(i);
            controllerBus.setRemoteControlReactivePercent(reactiveKeysSum == 0.0 ? 0.0 : reactiveKeys[i] / reactiveKeysSum);
        }
    }
}

