/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.VoltageControl;
import java.util.Arrays;
import java.util.List;

public class GeneratorVoltageControl
extends VoltageControl<LfBus> {
    public GeneratorVoltageControl(LfBus controlledBus, int targetPriority, double targetValue) {
        super(targetValue, VoltageControl.Type.GENERATOR, targetPriority, controlledBus);
    }

    @Override
    public boolean isControllerEnabled(LfBus controllerElement) {
        return controllerElement.isGeneratorVoltageControlEnabled();
    }

    @Override
    public void setTargetValue(double targetValue) {
        if (targetValue != this.targetValue) {
            this.targetValue = targetValue;
            this.controlledBus.getNetwork().getListeners().forEach(l -> l.onGeneratorVoltageControlTargetChange(this, targetValue));
        }
    }

    @Override
    public void addControllerElement(LfBus controllerBus) {
        super.addControllerElement(controllerBus);
        controllerBus.setGeneratorVoltageControl(this);
    }

    public boolean isLocalControl() {
        return this.isLocalControl(this.getMergedControllerElements());
    }

    private boolean isLocalControl(List<LfBus> controllerElements) {
        return controllerElements.size() == 1 && controllerElements.contains(this.controlledBus);
    }

    public boolean isSharedControl() {
        return this.controllerElements.stream().flatMap(lfBus -> lfBus.getGenerators().stream()).filter(gen -> gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.VOLTAGE).count() > 1L;
    }

    public void updateReactiveKeys() {
        List<LfBus> controllerBuses = this.getMergedControllerElements();
        double[] reactiveKeys = GeneratorVoltageControl.createReactiveKeys(controllerBuses, LfGenerator.GeneratorControlType.VOLTAGE);
        for (int i = 0; i < controllerBuses.size(); ++i) {
            LfBus controllerBus = controllerBuses.get(i);
            if (!controllerBus.isDisabled() && controllerBus.isGeneratorVoltageControlEnabled()) continue;
            reactiveKeys[i] = 0.0;
        }
        double reactiveKeysSum = Arrays.stream(reactiveKeys).sum();
        for (int i = 0; i < controllerBuses.size(); ++i) {
            LfBus controllerBus = controllerBuses.get(i);
            controllerBus.setRemoteControlReactivePercent(reactiveKeysSum == 0.0 ? 0.0 : reactiveKeys[i] / reactiveKeysSum);
        }
    }
}

