/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.action.Action;
import com.powsybl.action.GeneratorAction;
import com.powsybl.action.HvdcAction;
import com.powsybl.action.LoadAction;
import com.powsybl.action.PhaseTapChangerTapPositionAction;
import com.powsybl.action.RatioTapChangerTapPositionAction;
import com.powsybl.action.ShuntCompensatorPositionAction;
import com.powsybl.action.SwitchAction;
import com.powsybl.action.TerminalsConnectionAction;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.PowerShift;
import com.powsybl.openloadflow.network.SimplePiModel;
import com.powsybl.openloadflow.network.impl.AbstractLfGenerator;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.LfShuntImpl;
import com.powsybl.openloadflow.network.impl.Networks;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LfAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfAction.class);
    private final String id;
    private final LfBranch disabledBranch;
    private final LfBranch enabledBranch;
    private final TapPositionChange tapPositionChange;
    private final LoadShift loadShift;
    private final GeneratorChange generatorChange;
    private final LfHvdc hvdc;
    private final SectionChange sectionChange;

    private LfAction(String id, LfBranch disabledBranch, LfBranch enabledBranch, TapPositionChange tapPositionChange, LoadShift loadShift, GeneratorChange generatorChange, LfHvdc hvdc, SectionChange sectionChange) {
        this.id = Objects.requireNonNull(id);
        this.disabledBranch = disabledBranch;
        this.enabledBranch = enabledBranch;
        this.tapPositionChange = tapPositionChange;
        this.loadShift = loadShift;
        this.generatorChange = generatorChange;
        this.hvdc = hvdc;
        this.sectionChange = sectionChange;
    }

    public static Optional<LfAction> create(Action action, LfNetwork lfNetwork, Network network, boolean breakers) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(network);
        switch (action.getType()) {
            case "SWITCH": {
                return LfAction.create((SwitchAction)action, lfNetwork);
            }
            case "TERMINALS_CONNECTION": {
                return LfAction.create((TerminalsConnectionAction)action, lfNetwork);
            }
            case "PHASE_TAP_CHANGER_TAP_POSITION": {
                return LfAction.create((PhaseTapChangerTapPositionAction)action, lfNetwork);
            }
            case "RATIO_TAP_CHANGER_TAP_POSITION": {
                return LfAction.create((RatioTapChangerTapPositionAction)action, lfNetwork);
            }
            case "LOAD": {
                return LfAction.create((LoadAction)action, lfNetwork, network, breakers);
            }
            case "GENERATOR": {
                return LfAction.create((GeneratorAction)action, lfNetwork);
            }
            case "HVDC": {
                return LfAction.create((HvdcAction)action, lfNetwork);
            }
            case "SHUNT_COMPENSATOR_POSITION": {
                return LfAction.create((ShuntCompensatorPositionAction)action, lfNetwork);
            }
        }
        throw new UnsupportedOperationException("Unsupported action type: " + action.getType());
    }

    private static Optional<LfAction> create(ShuntCompensatorPositionAction action, LfNetwork lfNetwork) {
        LfShunt shunt = lfNetwork.getShuntById(action.getShuntCompensatorId());
        if (shunt instanceof LfShuntImpl) {
            if (shunt.getVoltageControl().isPresent()) {
                LOGGER.warn("Shunt compensator position action: voltage control is present on the shunt, section could be overridden.");
            }
            SectionChange sectionChange = new SectionChange(shunt, action.getShuntCompensatorId(), action.getSectionCount());
            return Optional.of(new LfAction(action.getId(), null, null, null, null, null, null, sectionChange));
        }
        return Optional.empty();
    }

    private static Optional<LfAction> create(HvdcAction action, LfNetwork lfNetwork) {
        LfHvdc lfHvdc = lfNetwork.getHvdcById(action.getHvdcId());
        Optional acEmulationEnabled = action.isAcEmulationEnabled();
        if (lfHvdc != null && acEmulationEnabled.isPresent()) {
            if (((Boolean)acEmulationEnabled.get()).equals(Boolean.TRUE)) {
                throw new UnsupportedOperationException("Hvdc action: line is already in AC emulation, not supported yet.");
            }
            return Optional.of(new LfAction(action.getId(), null, null, null, null, null, lfHvdc, null));
        }
        LOGGER.warn("Hvdc action {}: not supported", (Object)action.getId());
        return Optional.empty();
    }

    private static Optional<LfAction> create(LoadAction action, LfNetwork lfNetwork, Network network, boolean breakers) {
        Load load = network.getLoad(action.getLoadId());
        Terminal terminal = load.getTerminal();
        Bus bus = Networks.getBus(terminal, breakers);
        if (bus != null) {
            double activePowerShift = 0.0;
            double reactivePowerShift = 0.0;
            OptionalDouble activePowerValue = action.getActivePowerValue();
            OptionalDouble reactivePowerValue = action.getReactivePowerValue();
            if (activePowerValue.isPresent()) {
                double d = activePowerShift = action.isRelativeValue() ? activePowerValue.getAsDouble() : activePowerValue.getAsDouble() - load.getP0();
            }
            if (reactivePowerValue.isPresent()) {
                reactivePowerShift = action.isRelativeValue() ? reactivePowerValue.getAsDouble() : reactivePowerValue.getAsDouble() - load.getQ0();
            }
            PowerShift powerShift = new PowerShift(activePowerShift / 100.0, activePowerShift / 100.0, reactivePowerShift / 100.0);
            LfLoad lfLoad = lfNetwork.getLoadById(load.getId());
            if (lfLoad != null) {
                return Optional.of(new LfAction(action.getId(), null, null, null, new LoadShift(load.getId(), lfLoad, powerShift), null, null, null));
            }
        }
        return Optional.empty();
    }

    private static Optional<LfAction> create(PhaseTapChangerTapPositionAction action, LfNetwork lfNetwork) {
        String branchId = action.getSide().map(side -> LfLegBranch.getId(side, action.getTransformerId())).orElseGet(() -> ((PhaseTapChangerTapPositionAction)action).getTransformerId());
        LfBranch branch = lfNetwork.getBranchById(branchId);
        if (branch != null && branch.getPhaseControl().isPresent()) {
            LOGGER.warn("Phase tap changer tap position action: phase control is present on the tap changer, tap position could be overriden.");
        }
        return LfAction.create(branch, action.getId(), action.isRelativeValue(), action.getTapPosition(), lfNetwork);
    }

    private static Optional<LfAction> create(RatioTapChangerTapPositionAction action, LfNetwork lfNetwork) {
        String branchId = action.getSide().map(side -> LfLegBranch.getId(side, action.getTransformerId())).orElseGet(() -> ((RatioTapChangerTapPositionAction)action).getTransformerId());
        LfBranch branch = lfNetwork.getBranchById(branchId);
        if (branch != null && branch.getVoltageControl().isPresent()) {
            LOGGER.warn("Ratio tap changer tap position action: voltage control is present on the tap changer, tap position could be overriden.");
        }
        return LfAction.create(branch, action.getId(), action.isRelativeValue(), action.getTapPosition(), lfNetwork);
    }

    private static Optional<LfAction> create(LfBranch branch, String actionId, boolean isRelative, int tapPosition, LfNetwork lfNetwork) {
        if (branch != null) {
            if (branch.getPiModel() instanceof SimplePiModel) {
                throw new UnsupportedOperationException("Tap position action: only one tap in branch " + branch.getId());
            }
            TapPositionChange tapPositionChange = new TapPositionChange(branch, tapPosition, isRelative);
            return Optional.of(new LfAction(actionId, null, null, tapPositionChange, null, null, null, null));
        }
        return Optional.empty();
    }

    private static Optional<LfAction> create(TerminalsConnectionAction action, LfNetwork lfNetwork) {
        LfBranch branch = lfNetwork.getBranchById(action.getElementId());
        if (branch != null) {
            if (action.getSide().isEmpty()) {
                if (action.isOpen()) {
                    return Optional.of(new LfAction(action.getId(), branch, null, null, null, null, null, null));
                }
                return Optional.of(new LfAction(action.getId(), null, branch, null, null, null, null, null));
            }
            throw new UnsupportedOperationException("Terminals connection action: only open or close branch at both sides is supported yet.");
        }
        return Optional.empty();
    }

    private static Optional<LfAction> create(SwitchAction action, LfNetwork lfNetwork) {
        LfBranch branch = lfNetwork.getBranchById(action.getSwitchId());
        if (branch != null) {
            LfBranch disabledBranch = null;
            LfBranch enabledBranch = null;
            if (action.isOpen()) {
                disabledBranch = branch;
            } else {
                enabledBranch = branch;
            }
            return Optional.of(new LfAction(action.getId(), disabledBranch, enabledBranch, null, null, null, null, null));
        }
        return Optional.empty();
    }

    private static Optional<LfAction> create(GeneratorAction action, LfNetwork lfNetwork) {
        LfGenerator generator = lfNetwork.getGeneratorById(action.getGeneratorId());
        if (generator != null) {
            OptionalDouble activePowerValue = action.getActivePowerValue();
            Optional relativeValue = action.isActivePowerRelativeValue();
            if (relativeValue.isPresent() && activePowerValue.isPresent()) {
                GeneratorChange generatorChange = new GeneratorChange(generator, activePowerValue.getAsDouble() / 100.0, (Boolean)relativeValue.get());
                return Optional.of(new LfAction(action.getId(), null, null, null, null, generatorChange, null, null));
            }
            throw new UnsupportedOperationException("Generator action on " + action.getGeneratorId() + " : configuration not supported yet.");
        }
        return Optional.empty();
    }

    public String getId() {
        return this.id;
    }

    public LfBranch getDisabledBranch() {
        return this.disabledBranch;
    }

    public LfBranch getEnabledBranch() {
        return this.enabledBranch;
    }

    public static void apply(List<LfAction> actions, LfNetwork network, LfContingency contingency, LfNetworkParameters networkParameters) {
        Objects.requireNonNull(actions);
        Objects.requireNonNull(network);
        LfAction.updateConnectivity(actions, network, contingency);
        for (LfAction action : actions) {
            action.apply(networkParameters);
        }
    }

    private static void updateConnectivity(List<LfAction> actions, LfNetwork network, LfContingency contingency) {
        GraphConnectivity<LfBus, LfBranch> connectivity = network.getConnectivity();
        connectivity.startTemporaryChanges();
        contingency.getDisabledNetwork().getBranches().forEach(connectivity::removeEdge);
        connectivity.startTemporaryChanges();
        for (LfAction action : actions) {
            action.updateConnectivity(connectivity);
        }
        LfAction.updateBusesAndBranchStatus(connectivity);
        connectivity.undoTemporaryChanges();
        connectivity.undoTemporaryChanges();
    }

    public static void updateBusesAndBranchStatus(GraphConnectivity<LfBus, LfBranch> connectivity) {
        Set<LfBus> removedBuses = connectivity.getVerticesRemovedFromMainComponent();
        removedBuses.forEach(bus -> bus.setDisabled(true));
        HashSet<LfBranch> removedBranches = new HashSet<LfBranch>(connectivity.getEdgesRemovedFromMainComponent());
        for (LfBus bus2 : removedBuses) {
            bus2.getBranches().stream().filter(b -> !b.isConnectedAtBothSides()).forEach(removedBranches::add);
        }
        removedBranches.forEach(branch -> branch.setDisabled(true));
        Set<LfBus> addedBuses = connectivity.getVerticesAddedToMainComponent();
        addedBuses.forEach(bus -> bus.setDisabled(false));
        HashSet<LfBranch> addedBranches = new HashSet<LfBranch>(connectivity.getEdgesAddedToMainComponent());
        for (LfBus bus3 : addedBuses) {
            bus3.getBranches().stream().filter(b -> !b.isConnectedAtBothSides()).forEach(addedBranches::add);
        }
        addedBranches.forEach(branch -> branch.setDisabled(false));
    }

    public void updateConnectivity(GraphConnectivity<LfBus, LfBranch> connectivity) {
        if (this.disabledBranch != null && this.disabledBranch.getBus1() != null && this.disabledBranch.getBus2() != null) {
            connectivity.removeEdge(this.disabledBranch);
        }
        if (this.enabledBranch != null) {
            connectivity.addEdge(this.enabledBranch.getBus1(), this.enabledBranch.getBus2(), this.enabledBranch);
        }
    }

    private void applyTapPositionChange() {
        LfBranch branch = this.tapPositionChange.branch();
        int tapPosition = branch.getPiModel().getTapPosition();
        int value = this.tapPositionChange.value();
        int newTapPosition = this.tapPositionChange.isRelative() ? tapPosition + value : value;
        branch.getPiModel().setTapPosition(newTapPosition);
    }

    private void applyLoadShift() {
        LfLoad load = this.loadShift.load();
        if (!load.isOriginalLoadDisabled(this.loadShift.loadId())) {
            PowerShift shift = this.loadShift.powerShift();
            load.setTargetP(load.getTargetP() + shift.getActive());
            load.setTargetQ(load.getTargetQ() + shift.getReactive());
            load.setAbsVariableTargetP(load.getAbsVariableTargetP() + Math.signum(shift.getActive()) * Math.abs(shift.getVariableActive()));
        }
    }

    private void applyGeneratorChange(LfNetworkParameters networkParameters) {
        LfGenerator generator = this.generatorChange.generator();
        if (!generator.isDisabled()) {
            double newTargetP = this.generatorChange.isRelative() ? generator.getTargetP() + this.generatorChange.activePowerValue() : this.generatorChange.activePowerValue();
            generator.setTargetP(newTargetP);
            generator.setInitialTargetP(newTargetP);
            if (!AbstractLfGenerator.checkActivePowerControl(generator.getId(), generator.getTargetP(), generator.getMaxP(), generator.getMinTargetP(), generator.getMaxTargetP(), networkParameters.getPlausibleActivePowerLimit(), networkParameters.isUseActiveLimits(), null)) {
                generator.setParticipating(false);
            }
        }
    }

    private void applyHvdcAction() {
        this.hvdc.setAcEmulation(false);
        this.hvdc.setDisabled(true);
        this.hvdc.getConverterStation1().setTargetP(-this.hvdc.getP1().eval());
        this.hvdc.getConverterStation2().setTargetP(-this.hvdc.getP2().eval());
    }

    private void applySectionChange() {
        LfShunt shunt = this.sectionChange.shunt();
        shunt.getControllers().stream().filter(controller -> controller.getId().equals(this.sectionChange.controllerId())).findAny().ifPresentOrElse(controller -> controller.updateSectionB(this.sectionChange.value()), () -> LOGGER.warn("No section change: shunt {} not present", (Object)this.sectionChange.controllerId));
    }

    public void apply(LfNetworkParameters networkParameters) {
        if (this.tapPositionChange != null) {
            this.applyTapPositionChange();
        }
        if (this.loadShift != null) {
            this.applyLoadShift();
        }
        if (this.generatorChange != null) {
            this.applyGeneratorChange(networkParameters);
        }
        if (this.hvdc != null) {
            this.applyHvdcAction();
        }
        if (this.sectionChange != null) {
            this.applySectionChange();
        }
    }

    private record TapPositionChange(LfBranch branch, int value, boolean isRelative) {
    }

    private record LoadShift(String loadId, LfLoad load, PowerShift powerShift) {
    }

    private record GeneratorChange(LfGenerator generator, double activePowerValue, boolean isRelative) {
    }

    private record SectionChange(LfShunt shunt, String controllerId, int value) {
    }
}

