/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.EvaluableConstants;
import java.util.Objects;

public class LfAsymBus {
    private LfBus bus;
    private final double totalDeltaPa;
    private final double totalDeltaQa;
    private final double totalDeltaPb;
    private final double totalDeltaQb;
    private final double totalDeltaPc;
    private final double totalDeltaQc;
    private double vz = 0.0;
    private double angleZ = 0.0;
    private double vn = 0.0;
    private double angleN = 0.0;
    private double bzEquiv = 0.0;
    private double gzEquiv = 0.0;
    private double bnEquiv = 0.0;
    private double gnEquiv = 0.0;
    private Evaluable ixZ = EvaluableConstants.NAN;
    private Evaluable iyZ = EvaluableConstants.NAN;
    private Evaluable ixN = EvaluableConstants.NAN;
    private Evaluable iyN = EvaluableConstants.NAN;

    public LfAsymBus(double totalDeltaPa, double totalDeltaQa, double totalDeltaPb, double totalDeltaQb, double totalDeltaPc, double totalDeltaQc) {
        this.totalDeltaPa = totalDeltaPa;
        this.totalDeltaQa = totalDeltaQa;
        this.totalDeltaPb = totalDeltaPb;
        this.totalDeltaQb = totalDeltaQb;
        this.totalDeltaPc = totalDeltaPc;
        this.totalDeltaQc = totalDeltaQc;
    }

    public void setBus(LfBus bus) {
        this.bus = Objects.requireNonNull(bus);
    }

    public double getPa() {
        return this.bus.getLoadTargetP() + this.totalDeltaPa;
    }

    public double getPb() {
        return this.bus.getLoadTargetP() + this.totalDeltaPb;
    }

    public double getPc() {
        return this.bus.getLoadTargetP() + this.totalDeltaPc;
    }

    public double getQa() {
        return this.bus.getLoadTargetQ() + this.totalDeltaQa;
    }

    public double getQb() {
        return this.bus.getLoadTargetQ() + this.totalDeltaQb;
    }

    public double getQc() {
        return this.bus.getLoadTargetQ() + this.totalDeltaQc;
    }

    public double getAngleZ() {
        return this.angleZ;
    }

    public void setAngleZ(double angleZ) {
        this.angleZ = angleZ;
    }

    public double getAngleN() {
        return this.angleN;
    }

    public void setAngleN(double angleN) {
        this.angleN = angleN;
    }

    public double getVz() {
        return this.vz;
    }

    public void setVz(double vz) {
        this.vz = vz;
    }

    public double getVn() {
        return this.vn;
    }

    public void setVn(double vn) {
        this.vn = vn;
    }

    public Evaluable getIxZ() {
        return this.ixZ;
    }

    public void setIxZ(Evaluable ixZ) {
        this.ixZ = ixZ;
    }

    public Evaluable getIxN() {
        return this.ixN;
    }

    public void setIxN(Evaluable ixN) {
        this.ixN = ixN;
    }

    public Evaluable getIyZ() {
        return this.iyZ;
    }

    public void setIyZ(Evaluable iyZ) {
        this.iyZ = iyZ;
    }

    public Evaluable getIyN() {
        return this.iyN;
    }

    public void setIyN(Evaluable iyN) {
        this.iyN = iyN;
    }

    public double getBnEquiv() {
        return this.bnEquiv;
    }

    public void setBnEquiv(double bnEquiv) {
        this.bnEquiv = bnEquiv;
    }

    public double getBzEquiv() {
        return this.bzEquiv;
    }

    public void setBzEquiv(double bzEquiv) {
        this.bzEquiv = bzEquiv;
    }

    public double getGzEquiv() {
        return this.gzEquiv;
    }

    public void setGzEquiv(double gzEquiv) {
        this.gzEquiv = gzEquiv;
    }

    public double getGnEquiv() {
        return this.gnEquiv;
    }

    public void setGnEquiv(double gnEquiv) {
        this.gnEquiv = gnEquiv;
    }
}

