/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.GeneratorReactivePowerControl;
import com.powsybl.openloadflow.network.LfAsymLine;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfNetworkUpdateReport;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import com.powsybl.openloadflow.network.TransformerReactivePowerControl;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.security.results.BranchResult;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface LfBranch
extends LfElement {
    public static int[] createIndex(LfNetwork network, List<LfBranch> branches) {
        int[] branchIndex = new int[network.getBranches().size()];
        int i = 0;
        while (i < branches.size()) {
            LfBranch branch = branches.get(i);
            branchIndex[branch.getNum()] = i++;
        }
        return branchIndex;
    }

    public BranchType getBranchType();

    public LfBus getBus1();

    public LfBus getBus2();

    public void setP1(Evaluable var1);

    public Evaluable getP1();

    public void setP2(Evaluable var1);

    public Evaluable getP2();

    public Evaluable getQ1();

    public void setQ1(Evaluable var1);

    public Evaluable getQ2();

    public void setQ2(Evaluable var1);

    public PiModel getPiModel();

    public void setI1(Evaluable var1);

    public void setI2(Evaluable var1);

    public Evaluable getI1();

    public Evaluable getI2();

    public Evaluable getOpenP1();

    public void setOpenP1(Evaluable var1);

    public Evaluable getOpenQ1();

    public void setOpenQ1(Evaluable var1);

    public Evaluable getOpenI1();

    public void setOpenI1(Evaluable var1);

    public Evaluable getOpenP2();

    public void setOpenP2(Evaluable var1);

    public Evaluable getOpenQ2();

    public void setOpenQ2(Evaluable var1);

    public Evaluable getOpenI2();

    public void setOpenI2(Evaluable var1);

    public Evaluable getClosedP1();

    public void setClosedP1(Evaluable var1);

    public Evaluable getClosedQ1();

    public void setClosedQ1(Evaluable var1);

    public Evaluable getClosedI1();

    public void setClosedI1(Evaluable var1);

    public Evaluable getClosedP2();

    public void setClosedP2(Evaluable var1);

    public Evaluable getClosedQ2();

    public void setClosedQ2(Evaluable var1);

    public Evaluable getClosedI2();

    public void setClosedI2(Evaluable var1);

    public void addAdditionalOpenP1(Evaluable var1);

    public List<Evaluable> getAdditionalOpenP1();

    public void addAdditionalClosedP1(Evaluable var1);

    public List<Evaluable> getAdditionalClosedP1();

    public void addAdditionalOpenQ1(Evaluable var1);

    public List<Evaluable> getAdditionalOpenQ1();

    public void addAdditionalClosedQ1(Evaluable var1);

    public List<Evaluable> getAdditionalClosedQ1();

    public void addAdditionalOpenP2(Evaluable var1);

    public List<Evaluable> getAdditionalOpenP2();

    public void addAdditionalClosedP2(Evaluable var1);

    public List<Evaluable> getAdditionalClosedP2();

    public void addAdditionalOpenQ2(Evaluable var1);

    public List<Evaluable> getAdditionalOpenQ2();

    public void addAdditionalClosedQ2(Evaluable var1);

    public List<Evaluable> getAdditionalClosedQ2();

    public List<LfLimit> getLimits1(LimitType var1, LimitReductionManager var2);

    default public List<LfLimit> getLimits2(LimitType type, LimitReductionManager limitReductionManager) {
        return Collections.emptyList();
    }

    public double[] getLimitReductions(TwoSides var1, LimitReductionManager var2, LoadingLimits var3);

    public void updateState(LfNetworkStateUpdateParameters var1, LfNetworkUpdateReport var2);

    public void updateFlows(double var1, double var3, double var5, double var7);

    public boolean hasPhaseControllerCapability();

    public Optional<TransformerPhaseControl> getPhaseControl();

    public void setPhaseControl(TransformerPhaseControl var1);

    public boolean isPhaseController();

    public boolean isPhaseControlled();

    public boolean isPhaseControlEnabled();

    public void setPhaseControlEnabled(boolean var1);

    public Optional<TransformerVoltageControl> getVoltageControl();

    public boolean isVoltageControlEnabled();

    public void setVoltageControlEnabled(boolean var1);

    public boolean isVoltageController();

    public void setVoltageControl(TransformerVoltageControl var1);

    public Optional<TransformerReactivePowerControl> getTransformerReactivePowerControl();

    public void setTransformerReactivePowerControl(TransformerReactivePowerControl var1);

    public boolean isTransformerReactivePowerController();

    public boolean isTransformerReactivePowerControlled();

    public List<BranchResult> createBranchResult(double var1, double var3, boolean var5);

    public double computeApparentPower1();

    public double computeApparentPower2();

    public boolean isZeroImpedance(LoadFlowModel var1);

    public void setSpanningTreeEdge(LoadFlowModel var1, boolean var2);

    public boolean isSpanningTreeEdge(LoadFlowModel var1);

    public Evaluable getA1();

    public void setA1(Evaluable var1);

    public static double getA(LfBranch branch) {
        Objects.requireNonNull(branch);
        PiModel piModel = branch.getPiModel();
        return 0.0 - piModel.getA1();
    }

    public static double getDiscretePhaseControlTarget(LfBranch branch, TransformerPhaseControl.Unit unit) {
        Objects.requireNonNull(branch);
        Objects.requireNonNull(unit);
        Optional<TransformerPhaseControl> phaseControl = branch.getPhaseControl().filter(dpc -> branch.isPhaseControlled());
        if (phaseControl.isEmpty()) {
            throw new PowsyblException("Branch '" + branch.getId() + "' is not phase-controlled");
        }
        if (phaseControl.get().getUnit() != unit) {
            throw new PowsyblException("Branch '" + branch.getId() + "' has not a target in " + unit);
        }
        return phaseControl.get().getTargetValue();
    }

    public Optional<GeneratorReactivePowerControl> getGeneratorReactivePowerControl();

    public void setGeneratorReactivePowerControl(GeneratorReactivePowerControl var1);

    public boolean isConnectedAtBothSides();

    public boolean isConnectedSide1();

    public void setConnectedSide1(boolean var1);

    public boolean isConnectedSide2();

    public void setConnectedSide2(boolean var1);

    public boolean isDisconnectionAllowedSide1();

    public void setDisconnectionAllowedSide1(boolean var1);

    public void setDisconnectionAllowedSide2(boolean var1);

    public boolean isDisconnectionAllowedSide2();

    public void setMinZ(double var1);

    public LfAsymLine getAsymLine();

    public void setAsymLine(LfAsymLine var1);

    public boolean isAsymmetric();

    public static class LfLimit {
        private final String name;
        private int acceptableDuration;
        private final double value;
        private final double reduction;

        public LfLimit(String name, int acceptableDuration, double value, double reduction) {
            this.name = name;
            this.acceptableDuration = acceptableDuration;
            this.value = value;
            this.reduction = reduction;
        }

        public static LfLimit createTemporaryLimit(String name, int acceptableDuration, double originalValuePerUnit, Double reduction) {
            return new LfLimit(name, acceptableDuration, originalValuePerUnit, reduction);
        }

        public static LfLimit createPermanentLimit(double originalValuePerUnit, Double reduction) {
            return new LfLimit("permanent", Integer.MAX_VALUE, originalValuePerUnit, reduction);
        }

        public String getName() {
            return this.name;
        }

        public int getAcceptableDuration() {
            return this.acceptableDuration;
        }

        public double getValue() {
            return this.value;
        }

        public double getReducedValue() {
            return this.value * this.reduction;
        }

        public void setAcceptableDuration(int acceptableDuration) {
            this.acceptableDuration = acceptableDuration;
        }

        public double getReduction() {
            return this.reduction;
        }
    }

    public static enum BranchType {
        LINE,
        TRANSFO_2,
        TRANSFO_3_LEG_1,
        TRANSFO_3_LEG_2,
        TRANSFO_3_LEG_3,
        DANGLING_LINE,
        SWITCH,
        TIE_LINE;

    }
}

