/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Country;
import com.powsybl.openloadflow.network.GeneratorReactivePowerControl;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfAsymBus;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfZeroImpedanceNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.security.results.BusResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;

public interface LfBus
extends LfElement {
    public String getVoltageLevelId();

    public boolean isFictitious();

    public boolean isSlack();

    public void setSlack(boolean var1);

    public boolean isReference();

    public void setReference(boolean var1);

    public List<VoltageControl<?>> getVoltageControls();

    public boolean isVoltageControlled();

    public boolean isVoltageControlled(VoltageControl.Type var1);

    public Optional<VoltageControl<?>> getVoltageControl(VoltageControl.Type var1);

    public OptionalDouble getHighestPriorityTargetV();

    public Optional<GeneratorVoltageControl> getGeneratorVoltageControl();

    public void setGeneratorVoltageControl(GeneratorVoltageControl var1);

    public boolean isGeneratorVoltageControlled();

    public boolean isGeneratorVoltageControlEnabled();

    public void setGeneratorVoltageControlEnabled(boolean var1);

    public List<LfGenerator> getGeneratorsControllingVoltageWithSlope();

    public boolean hasGeneratorsWithSlope();

    public void removeGeneratorSlopes();

    public Optional<GeneratorReactivePowerControl> getGeneratorReactivePowerControl();

    public void setGeneratorReactivePowerControl(GeneratorReactivePowerControl var1);

    public boolean hasGeneratorReactivePowerControl();

    public boolean isGeneratorReactivePowerControlEnabled();

    public void setGeneratorReactivePowerControlEnabled(boolean var1);

    public double getTargetP();

    public double getTargetQ();

    public double getLoadTargetP();

    public double getLoadTargetQ();

    public void invalidateGenerationTargetP();

    public double getGenerationTargetP();

    public double getMaxP();

    public double getGenerationTargetQ();

    public void setGenerationTargetQ(double var1);

    public double getMinQ();

    public double getMaxQ();

    public Optional<QLimitType> getQLimitType();

    public void setQLimitType(QLimitType var1);

    public double getV();

    public void setV(double var1);

    public Evaluable getCalculatedV();

    public void setCalculatedV(Evaluable var1);

    public double getAngle();

    public void setAngle(double var1);

    public double getNominalV();

    default public double getLowVoltageLimit() {
        return Double.NaN;
    }

    default public double getHighVoltageLimit() {
        return Double.NaN;
    }

    public List<LfGenerator> getGenerators();

    public Optional<LfShunt> getShunt();

    public Optional<LfShunt> getControllerShunt();

    public Optional<LfShunt> getSvcShunt();

    public List<LfLoad> getLoads();

    public List<LfBranch> getBranches();

    public void addBranch(LfBranch var1);

    public List<LfHvdc> getHvdcs();

    public void addHvdc(LfHvdc var1);

    public void updateState(LfNetworkStateUpdateParameters var1);

    public Optional<TransformerVoltageControl> getTransformerVoltageControl();

    public void setTransformerVoltageControl(TransformerVoltageControl var1);

    public boolean isTransformerVoltageControlled();

    public Optional<ShuntVoltageControl> getShuntVoltageControl();

    public void setShuntVoltageControl(ShuntVoltageControl var1);

    public boolean isShuntVoltageControlled();

    public void setP(Evaluable var1);

    public Evaluable getP();

    public void setQ(Evaluable var1);

    public Evaluable getQ();

    default public boolean isParticipating() {
        return false;
    }

    default public List<BusResult> createBusResults() {
        return Collections.emptyList();
    }

    public Map<LfBus, List<LfBranch>> findNeighbors();

    public double getRemoteControlReactivePercent();

    public void setRemoteControlReactivePercent(double var1);

    public double getMismatchP();

    default public Optional<Country> getCountry() {
        return Optional.empty();
    }

    public void setZeroImpedanceNetwork(LoadFlowModel var1, LfZeroImpedanceNetwork var2);

    public LfZeroImpedanceNetwork getZeroImpedanceNetwork(LoadFlowModel var1);

    public LfAsymBus getAsym();

    public void setAsym(LfAsymBus var1);

    public static enum QLimitType {
        MIN_Q,
        MAX_Q;

    }
}

