/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.network.AdmittanceShift;
import com.powsybl.openloadflow.network.DisabledBranchStatus;
import com.powsybl.openloadflow.network.DisabledNetwork;
import com.powsybl.openloadflow.network.GeneratorReactivePowerControl;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfLostLoad;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfStaticVarCompensator;
import com.powsybl.openloadflow.network.PowerShift;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LfContingency {
    private final String id;
    private final int index;
    private final int createdSynchronousComponentsCount;
    private final DisabledNetwork disabledNetwork;
    private final Map<LfShunt, AdmittanceShift> shuntsShift;
    private final Map<LfLoad, LfLostLoad> lostLoads;
    private final Set<LfGenerator> lostGenerators;
    private double disconnectedLoadActivePower;
    private double disconnectedGenerationActivePower;
    private final Set<String> disconnectedElementIds;
    private final Set<LfHvdc> hvdcsWithoutPower;

    public LfContingency(String id, int index, int createdSynchronousComponentsCount, DisabledNetwork disabledNetwork, Map<LfShunt, AdmittanceShift> shuntsShift, Map<LfLoad, LfLostLoad> lostLoads, Set<LfGenerator> lostGenerators, Set<LfHvdc> hvdcsWithoutPower) {
        this.id = Objects.requireNonNull(id);
        this.index = index;
        this.createdSynchronousComponentsCount = createdSynchronousComponentsCount;
        this.disabledNetwork = Objects.requireNonNull(disabledNetwork);
        this.shuntsShift = Objects.requireNonNull(shuntsShift);
        this.lostLoads = Objects.requireNonNull(lostLoads);
        this.lostGenerators = Objects.requireNonNull(lostGenerators);
        this.hvdcsWithoutPower = Objects.requireNonNull(hvdcsWithoutPower);
        this.disconnectedLoadActivePower = 0.0;
        this.disconnectedGenerationActivePower = 0.0;
        this.disconnectedElementIds = new HashSet<String>();
        for (LfBus lfBus : disabledNetwork.getBuses()) {
            this.disconnectedLoadActivePower += lfBus.getLoadTargetP();
            this.disconnectedGenerationActivePower += lfBus.getGenerationTargetP();
            this.disconnectedElementIds.addAll(lfBus.getGenerators().stream().map(LfGenerator::getId).toList());
            this.disconnectedElementIds.addAll(lfBus.getLoads().stream().flatMap(l -> l.getOriginalIds().stream()).toList());
            lfBus.getControllerShunt().ifPresent(shunt -> this.disconnectedElementIds.addAll(shunt.getOriginalIds()));
            lfBus.getShunt().ifPresent(shunt -> this.disconnectedElementIds.addAll(shunt.getOriginalIds()));
        }
        for (Map.Entry entry : lostLoads.entrySet()) {
            LfLostLoad lostLoad = (LfLostLoad)entry.getValue();
            this.disconnectedLoadActivePower += lostLoad.getPowerShift().getActive();
            this.disconnectedElementIds.addAll(lostLoad.getOriginalIds());
        }
        for (LfGenerator lfGenerator : lostGenerators) {
            this.disconnectedGenerationActivePower += lfGenerator.getTargetP();
            this.disconnectedElementIds.add(lfGenerator.getOriginalId());
        }
        this.disconnectedElementIds.addAll(disabledNetwork.getBranches().stream().map(LfElement::getId).toList());
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCreatedSynchronousComponentsCount() {
        return this.createdSynchronousComponentsCount;
    }

    public DisabledNetwork getDisabledNetwork() {
        return this.disabledNetwork;
    }

    public Map<LfShunt, AdmittanceShift> getShuntsShift() {
        return this.shuntsShift;
    }

    public Map<LfLoad, LfLostLoad> getLostLoads() {
        return this.lostLoads;
    }

    public Set<LfGenerator> getLostGenerators() {
        return this.lostGenerators;
    }

    public Set<String> getDisconnectedElementIds() {
        return this.disconnectedElementIds;
    }

    public double getActivePowerLoss() {
        return this.disconnectedGenerationActivePower - this.disconnectedLoadActivePower;
    }

    public double getDisconnectedLoadActivePower() {
        return this.disconnectedLoadActivePower;
    }

    public double getDisconnectedGenerationActivePower() {
        return this.disconnectedGenerationActivePower;
    }

    public void apply(LoadFlowParameters.BalanceType balanceType) {
        for (Map.Entry<LfBranch, DisabledBranchStatus> entry : this.disabledNetwork.getBranchesStatus().entrySet()) {
            LfBranch branch = entry.getKey();
            DisabledBranchStatus status = entry.getValue();
            switch (status) {
                case BOTH_SIDES: {
                    branch.setDisabled(true);
                    break;
                }
                case SIDE_1: {
                    branch.setConnectedSide1(false);
                    break;
                }
                case SIDE_2: {
                    branch.setConnectedSide2(false);
                }
            }
        }
        for (LfHvdc lfHvdc : this.disabledNetwork.getHvdcs()) {
            lfHvdc.setDisabled(true);
        }
        for (LfBus lfBus : this.disabledNetwork.getBuses()) {
            lfBus.setDisabled(true);
        }
        for (Map.Entry entry : this.shuntsShift.entrySet()) {
            LfShunt shunt = (LfShunt)entry.getKey();
            shunt.setG(shunt.getG() - ((AdmittanceShift)entry.getValue()).getG());
            shunt.setB(shunt.getB() - ((AdmittanceShift)entry.getValue()).getB());
        }
        for (Map.Entry entry : this.lostLoads.entrySet()) {
            LfLoad load = (LfLoad)entry.getKey();
            LfLostLoad lostLoad = (LfLostLoad)entry.getValue();
            PowerShift shift = lostLoad.getPowerShift();
            load.setTargetP(load.getTargetP() - LfContingency.getUpdatedLoadP0(load, balanceType, shift.getActive(), shift.getVariableActive()));
            load.setTargetQ(load.getTargetQ() - shift.getReactive());
            load.setAbsVariableTargetP(load.getAbsVariableTargetP() - Math.abs(shift.getVariableActive()));
            lostLoad.getOriginalIds().forEach(loadId -> load.setOriginalLoadDisabled((String)loadId, true));
        }
        HashSet<LfBus> generatorBuses = new HashSet<LfBus>();
        for (LfGenerator generator : this.lostGenerators) {
            generator.setTargetP(0.0);
            generator.setInitialTargetP(0.0);
            LfBus bus = generator.getBus();
            generatorBuses.add(bus);
            generator.setParticipating(false);
            generator.setDisabled(true);
            if (generator.getGeneratorControlType() != LfGenerator.GeneratorControlType.OFF) {
                generator.setGeneratorControlType(LfGenerator.GeneratorControlType.OFF);
                bus.getGeneratorVoltageControl().ifPresent(GeneratorVoltageControl::updateReactiveKeys);
                bus.getGeneratorReactivePowerControl().ifPresent(GeneratorReactivePowerControl::updateReactiveKeys);
            } else {
                bus.setGenerationTargetQ(bus.getGenerationTargetQ() - generator.getTargetQ());
            }
            if (!(generator instanceof LfStaticVarCompensator)) continue;
            LfStaticVarCompensator svc = (LfStaticVarCompensator)generator;
            svc.getStandByAutomatonShunt().ifPresent(svcShunt -> {
                this.shuntsShift.put((LfShunt)svcShunt, new AdmittanceShift(0.0, svcShunt.getB()));
                svcShunt.setB(0.0);
            });
        }
        for (LfBus bus : generatorBuses) {
            if (bus.getGenerators().stream().noneMatch(gen -> gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.VOLTAGE)) {
                bus.setGeneratorVoltageControlEnabled(false);
            }
            if (!bus.getGenerators().stream().noneMatch(gen -> gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.REMOTE_REACTIVE_POWER)) continue;
            bus.setGeneratorReactivePowerControlEnabled(false);
        }
        for (LfHvdc hvdc : this.hvdcsWithoutPower) {
            hvdc.getConverterStation1().setTargetP(0.0);
            hvdc.getConverterStation2().setTargetP(0.0);
        }
    }

    private static double getUpdatedLoadP0(LfLoad load, LoadFlowParameters.BalanceType balanceType, double initialP0, double initialVariableActivePower) {
        double factor = 0.0;
        if (load.getOriginalLoadCount() > 0.0) {
            if (balanceType == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_LOAD) {
                factor = Math.abs(initialP0) / load.getAbsVariableTargetP();
            } else if (balanceType == LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD) {
                factor = initialVariableActivePower / load.getAbsVariableTargetP();
            }
        }
        return initialP0 + (load.getTargetP() - load.getInitialTargetP()) * factor;
    }

    public Set<LfBus> getLoadAndGeneratorBuses() {
        HashSet<LfBus> buses = new HashSet<LfBus>();
        for (Map.Entry<LfLoad, LfLostLoad> e : this.lostLoads.entrySet()) {
            LfLoad load = e.getKey();
            LfBus bus = load.getBus();
            if (bus == null) continue;
            buses.add(bus);
        }
        for (LfGenerator generator : this.lostGenerators) {
            LfBus bus = generator.getBus();
            if (bus == null) continue;
            buses.add(bus);
        }
        return buses;
    }

    public void writeJson(Writer writer) {
        Objects.requireNonNull(writer);
        try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer).useDefaultPrettyPrinter();){
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("id", this.id);
            jsonGenerator.writeFieldName("buses");
            int[] sortedBuses = this.disabledNetwork.getBuses().stream().mapToInt(LfElement::getNum).sorted().toArray();
            jsonGenerator.writeArray(sortedBuses, 0, sortedBuses.length);
            jsonGenerator.writeFieldName("branches");
            int[] sortedBranches = this.disabledNetwork.getBranches().stream().mapToInt(LfElement::getNum).sorted().toArray();
            jsonGenerator.writeArray(sortedBranches, 0, sortedBranches.length);
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

