/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LfLoadModel {
    private final List<ExpTerm> expTermsP;
    private final List<ExpTerm> expTermsQ;

    public LfLoadModel(List<ExpTerm> expTermsP, List<ExpTerm> expTermsQ) {
        this.expTermsP = Objects.requireNonNull(expTermsP);
        this.expTermsQ = Objects.requireNonNull(expTermsQ);
    }

    public List<ExpTerm> getExpTermsP() {
        return this.expTermsP;
    }

    public Optional<ExpTerm> getExpTermP(double n) {
        return this.expTermsP.stream().filter(expTerm -> expTerm.n == n).findFirst();
    }

    public List<ExpTerm> getExpTermsQ() {
        return this.expTermsQ;
    }

    public Optional<ExpTerm> getExpTermQ(double n) {
        return this.expTermsQ.stream().filter(expTerm -> expTerm.n == n).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LfLoadModel that = (LfLoadModel)o;
        return Objects.equals(this.expTermsP, that.expTermsP) && Objects.equals(this.expTermsQ, that.expTermsQ);
    }

    public int hashCode() {
        return Objects.hash(this.expTermsP, this.expTermsQ);
    }

    public record ExpTerm(double c, double n) {
    }
}

