/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LfOverloadManagementSystem {
    private final LfBranch monitoredBranch;
    private final TwoSides monitoredSide;
    private final List<LfBranchTripping> branchTrippingList = new ArrayList<LfBranchTripping>();

    public LfOverloadManagementSystem(LfBranch monitoredBranch, TwoSides monitoredSide) {
        this.monitoredBranch = Objects.requireNonNull(monitoredBranch);
        this.monitoredSide = Objects.requireNonNull(monitoredSide);
    }

    public LfBranch getMonitoredBranch() {
        return this.monitoredBranch;
    }

    public TwoSides getMonitoredSide() {
        return this.monitoredSide;
    }

    public void addLfBranchTripping(LfBranch branchToOperate, boolean branchOpen, double threshold) {
        this.branchTrippingList.add(new LfBranchTripping(Objects.requireNonNull(branchToOperate), branchOpen, threshold));
    }

    public List<LfBranchTripping> getBranchTrippingList() {
        return this.branchTrippingList;
    }

    public record LfBranchTripping(LfBranch branchToOperate, boolean branchOpen, double threshold) {
    }
}

