/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.AllowedDirection;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.util.Evaluable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LfShunt
extends LfElement {
    public static final Logger LOGGER = LoggerFactory.getLogger(LfShunt.class);

    public double getB();

    default public double getBMagnitude() {
        return Math.abs(this.getB());
    }

    public void setB(double var1);

    public double dispatchB();

    public double getG();

    public void setG(double var1);

    public void updateState(LfNetworkStateUpdateParameters var1);

    public boolean hasVoltageControlCapability();

    public void setVoltageControlCapability(boolean var1);

    public boolean isVoltageControlEnabled();

    public void setVoltageControlEnabled(boolean var1);

    public Optional<ShuntVoltageControl> getVoltageControl();

    public void setVoltageControl(ShuntVoltageControl var1);

    public void reInit();

    public List<Controller> getControllers();

    public Evaluable getP();

    public void setP(Evaluable var1);

    public Evaluable getQ();

    public void setQ(Evaluable var1);

    public static class Controller {
        private final String id;
        private final List<Double> sectionsB;
        private final List<Double> sectionsG;
        private int position;
        private final double bMagnitude;

        public Controller(String id, List<Double> sectionsB, List<Double> sectionsG, int position) {
            this.id = Objects.requireNonNull(id);
            this.sectionsB = Objects.requireNonNull(sectionsB);
            this.sectionsG = Objects.requireNonNull(sectionsG);
            this.position = position;
            double bMin = Math.min(sectionsB.get(0), sectionsB.get(sectionsB.size() - 1));
            double bMax = Math.max(sectionsB.get(0), sectionsB.get(sectionsB.size() - 1));
            this.bMagnitude = Math.abs(bMax - bMin);
        }

        public String getId() {
            return this.id;
        }

        public List<Double> getSectionsB() {
            return this.sectionsB;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public double getB() {
            return this.sectionsB.get(this.position);
        }

        public double getG() {
            return this.sectionsG.get(this.position);
        }

        public double getBMagnitude() {
            return this.bMagnitude;
        }

        private Range<Integer> getAllowedPositionRange(AllowedDirection allowedDirection) {
            return switch (allowedDirection) {
                default -> throw new IncompatibleClassChangeError();
                case AllowedDirection.INCREASE -> Range.of((Comparable)Integer.valueOf(this.position), (Comparable)Integer.valueOf(this.sectionsB.size() - 1));
                case AllowedDirection.DECREASE -> Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.position));
                case AllowedDirection.BOTH -> Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.sectionsB.size() - 1));
            };
        }

        public Optional<Direction> updateSectionB(double deltaB, int maxSectionShift, AllowedDirection allowedDirection) {
            boolean hasChanged;
            double newB = this.getB() + deltaB;
            Range<Integer> positionRange = this.getAllowedPositionRange(allowedDirection);
            int oldSection = this.position;
            double smallestDistance = Math.abs(deltaB);
            for (int p = ((Integer)positionRange.getMinimum()).intValue(); p <= (Integer)positionRange.getMaximum(); ++p) {
                double distance;
                if (Math.abs(p - oldSection) > maxSectionShift || !((distance = Math.abs(newB - this.sectionsB.get(p))) < smallestDistance)) continue;
                this.position = p;
                smallestDistance = distance;
            }
            boolean bl = hasChanged = this.position != oldSection;
            if (hasChanged) {
                LOGGER.debug("Controller '{}' change section from {} to {}", new Object[]{this.id, oldSection, this.position});
                return Optional.of(this.position - oldSection > 0 ? Direction.INCREASE : Direction.DECREASE);
            }
            return Optional.empty();
        }

        public void updateSectionB(int newPosition) {
            this.position = newPosition;
        }
    }
}

