/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.AbstractLfShunt;
import com.powsybl.openloadflow.network.ElementType;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfStaticVarCompensator;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.util.PerUnit;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class LfStandbyAutomatonShunt
extends AbstractLfShunt {
    private final LfStaticVarCompensator svc;
    private double b;

    private LfStandbyAutomatonShunt(LfStaticVarCompensator svc) {
        super(svc.getBus().getNetwork());
        this.svc = svc;
        double zb = PerUnit.zb(svc.getBus().getNominalV());
        this.b = svc.getB0() * zb;
    }

    public static LfStandbyAutomatonShunt create(LfStaticVarCompensator svc) {
        return new LfStandbyAutomatonShunt(Objects.requireNonNull(svc));
    }

    @Override
    public ElementType getType() {
        return ElementType.SHUNT_COMPENSATOR;
    }

    @Override
    public String getId() {
        return this.svc.getId() + "_standby_automaton_b0";
    }

    @Override
    public List<String> getOriginalIds() {
        return List.of(this.svc.getOriginalId());
    }

    @Override
    public double getB() {
        return this.b;
    }

    @Override
    public void setB(double b) {
        if (b != this.b) {
            this.b = b;
            for (LfNetworkListener listener : this.getNetwork().getListeners()) {
                listener.onShuntSusceptanceChange(this, b);
            }
        }
    }

    private static UnsupportedOperationException createUnsupportedForStandbyAutomatonShuntException() {
        throw new UnsupportedOperationException("Unsupported for a SVC standby automaton shunt");
    }

    @Override
    public double getG() {
        return 0.0;
    }

    @Override
    public void setG(double g) {
        throw LfStandbyAutomatonShunt.createUnsupportedForStandbyAutomatonShuntException();
    }

    @Override
    public boolean hasVoltageControlCapability() {
        return false;
    }

    @Override
    public void setVoltageControlCapability(boolean voltageControlCapability) {
        throw LfStandbyAutomatonShunt.createUnsupportedForStandbyAutomatonShuntException();
    }

    @Override
    public boolean isVoltageControlEnabled() {
        return false;
    }

    @Override
    public void setVoltageControlEnabled(boolean voltageControlEnabled) {
        throw LfStandbyAutomatonShunt.createUnsupportedForStandbyAutomatonShuntException();
    }

    @Override
    public Optional<ShuntVoltageControl> getVoltageControl() {
        return Optional.empty();
    }

    @Override
    public void setVoltageControl(ShuntVoltageControl voltageControl) {
        throw LfStandbyAutomatonShunt.createUnsupportedForStandbyAutomatonShuntException();
    }

    @Override
    public double dispatchB() {
        throw LfStandbyAutomatonShunt.createUnsupportedForStandbyAutomatonShuntException();
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
    }

    @Override
    public void reInit() {
    }

    @Override
    public List<LfShunt.Controller> getControllers() {
        return Collections.emptyList();
    }
}

