/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Switch;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class LfTopoConfig {
    private final Set<Switch> switchesToOpen;
    private final Set<Switch> switchesToClose;
    private final Set<String> busIdsToLose;
    private final Set<String> branchIdsWithPtcToRetain = new HashSet<String>();
    private final Set<String> branchIdsWithRtcToRetain = new HashSet<String>();
    private final Set<String> shuntIdsToOperate = new HashSet<String>();
    private final Set<String> branchIdsOpenableSide1 = new HashSet<String>();
    private final Set<String> branchIdsOpenableSide2 = new HashSet<String>();
    private final Set<String> branchIdsToClose = new HashSet<String>();

    public LfTopoConfig() {
        this.switchesToOpen = new HashSet<Switch>();
        this.switchesToClose = new HashSet<Switch>();
        this.busIdsToLose = new HashSet<String>();
    }

    public LfTopoConfig(LfTopoConfig other) {
        Objects.requireNonNull(other);
        this.switchesToOpen = new HashSet<Switch>(other.switchesToOpen);
        this.switchesToClose = new HashSet<Switch>(other.switchesToClose);
        this.busIdsToLose = new HashSet<String>(other.busIdsToLose);
    }

    public Set<Switch> getSwitchesToOpen() {
        return this.switchesToOpen;
    }

    public Set<Switch> getSwitchesToClose() {
        return this.switchesToClose;
    }

    public Set<String> getBusIdsToLose() {
        return this.busIdsToLose;
    }

    public void addBranchIdWithPtcToRetain(String branchId) {
        this.branchIdsWithPtcToRetain.add(branchId);
    }

    public void addBranchIdWithRtcToRetain(String branchId) {
        this.branchIdsWithRtcToRetain.add(branchId);
    }

    public void addShuntIdToOperate(String shuntId) {
        this.shuntIdsToOperate.add(shuntId);
    }

    public boolean isBreaker() {
        return !this.switchesToOpen.isEmpty() || !this.switchesToClose.isEmpty() || !this.busIdsToLose.isEmpty();
    }

    public boolean isRetainedPtc(String branchId) {
        return this.branchIdsWithPtcToRetain.contains(branchId);
    }

    public boolean isRetainedRtc(String branchId) {
        return this.branchIdsWithRtcToRetain.contains(branchId);
    }

    public boolean isOperatedShunt(String shuntId) {
        return this.shuntIdsToOperate.contains(shuntId);
    }

    public Set<String> getBranchIdsOpenableSide1() {
        return this.branchIdsOpenableSide1;
    }

    public Set<String> getBranchIdsOpenableSide2() {
        return this.branchIdsOpenableSide2;
    }

    public Set<String> getBranchIdsToClose() {
        return this.branchIdsToClose;
    }
}

