/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Country;
import com.powsybl.openloadflow.network.AbstractSlackBusSelector;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.SelectedSlackBus;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class MostMeshedSlackBusSelector
extends AbstractSlackBusSelector {
    public static final double MAX_NOMINAL_VOLTAGE_PERCENTILE_DEFAULT_VALUE = 95.0;
    private final double maxNominalVoltagePercentile;

    public MostMeshedSlackBusSelector() {
        this(95.0, Collections.emptySet());
    }

    public MostMeshedSlackBusSelector(double maxNominalVoltagePercentile, Set<Country> countries) {
        super(countries);
        this.maxNominalVoltagePercentile = maxNominalVoltagePercentile;
    }

    private static int getBranchCountConnectedAtBothSides(LfBus bus) {
        return (int)bus.getBranches().stream().filter(LfBranch::isConnectedAtBothSides).count();
    }

    @Override
    public SelectedSlackBus select(List<LfBus> buses, int limit) {
        double[] nominalVoltages = buses.stream().filter(bus -> !bus.isFictitious()).filter(this::filterByCountry).map(LfBus::getNominalV).mapToDouble(Double::valueOf).toArray();
        double maxNominalV = new Percentile().withEstimationType(Percentile.EstimationType.R_3).evaluate(nominalVoltages, this.maxNominalVoltagePercentile);
        List<LfBus> slackBuses = buses.stream().filter(bus -> !bus.isFictitious() && bus.getNominalV() == maxNominalV).filter(this::filterByCountry).sorted(Comparator.comparingInt(MostMeshedSlackBusSelector::getBranchCountConnectedAtBothSides).thenComparing(Comparator.comparing(LfElement::getId).reversed()).reversed()).limit(limit).collect(Collectors.toList());
        return new SelectedSlackBus(slackBuses, "Most meshed bus");
    }
}

