/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.extensions.SlackTerminal;
import com.powsybl.openloadflow.network.AbstractSlackBusSelector;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.SelectedSlackBus;
import com.powsybl.openloadflow.network.SlackBusSelector;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class NetworkSlackBusSelector
extends AbstractSlackBusSelector {
    private static final String SELECTION_METHOD = "Network extension bus";
    private final SlackBusSelector fallbackSelector;
    private final Set<String> slackBusIds = new HashSet<String>();

    public NetworkSlackBusSelector(Network network, Set<Country> countries, SlackBusSelector fallbackSelector) {
        super(countries);
        Objects.requireNonNull(network);
        this.fallbackSelector = Objects.requireNonNull(fallbackSelector);
        for (VoltageLevel vl : network.getVoltageLevels()) {
            SlackTerminal slackTerminal = (SlackTerminal)vl.getExtension(SlackTerminal.class);
            if (slackTerminal == null || slackTerminal.getTerminal() == null) continue;
            Bus bus = slackTerminal.getTerminal().getBusView().getBus();
            if (bus != null) {
                this.slackBusIds.add(bus.getId());
            }
            if ((bus = slackTerminal.getTerminal().getBusBreakerView().getBus()) == null) continue;
            this.slackBusIds.add(bus.getId());
        }
    }

    @Override
    public SelectedSlackBus select(List<LfBus> buses, int limit) {
        List<LfBus> slackBuses = buses.stream().filter(bus -> !bus.isFictitious()).filter(this::filterByCountry).filter(bus -> this.slackBusIds.contains(bus.getId())).collect(Collectors.toList());
        if (slackBuses.isEmpty()) {
            return this.fallbackSelector.select(buses, limit);
        }
        if (slackBuses.size() <= limit) {
            return new SelectedSlackBus(slackBuses, SELECTION_METHOD);
        }
        SelectedSlackBus slackBusSelector = this.fallbackSelector.select(slackBuses, limit);
        return new SelectedSlackBus(slackBusSelector.getBuses(), "Network extension bus + " + slackBusSelector.getSelectionMethod());
    }
}

