/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.BranchState;
import com.powsybl.openloadflow.network.BusState;
import com.powsybl.openloadflow.network.ElementState;
import com.powsybl.openloadflow.network.HvdcState;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkState {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkState.class);
    private final LfNetwork network;
    private final List<BusState> busStates;
    private final List<BranchState> branchStates;
    private final List<HvdcState> hvdcStates;
    private final Set<LfBus> excludedSlackBuses;

    protected NetworkState(LfNetwork network, List<BusState> busStates, List<BranchState> branchStates, List<HvdcState> hvdcStates, Set<LfBus> excludedSlackBuses) {
        this.network = Objects.requireNonNull(network);
        this.busStates = Objects.requireNonNull(busStates);
        this.branchStates = Objects.requireNonNull(branchStates);
        this.hvdcStates = Objects.requireNonNull(hvdcStates);
        this.excludedSlackBuses = Objects.requireNonNull(excludedSlackBuses);
    }

    public static NetworkState save(LfNetwork network) {
        Objects.requireNonNull(network);
        LOGGER.trace("Saving network state");
        network.getBuses().stream().flatMap(b -> b.getGenerators().stream()).forEach(LfGenerator::setInitialTargetPToTargetP);
        List<BusState> busStates = ElementState.save(network.getBuses(), BusState::save);
        List<BranchState> branchStates = ElementState.save(network.getBranches(), BranchState::save);
        List<HvdcState> hvdcStates = ElementState.save(network.getHvdcs(), HvdcState::save);
        return new NetworkState(network, busStates, branchStates, hvdcStates, network.getExcludedSlackBuses());
    }

    public void restore() {
        LOGGER.trace("Restoring network state");
        ElementState.restore(this.busStates);
        ElementState.restore(this.branchStates);
        ElementState.restore(this.hvdcStates);
        this.network.setExcludedSlackBuses(this.excludedSlackBuses);
    }
}

