/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.AllowedDirection;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.PiModel;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import org.apache.commons.lang3.Range;

public class PiModelArray
implements PiModel {
    private final List<PiModel> models;
    private final int lowTapPosition;
    private int tapPositionIndex;
    private double a1 = Double.NaN;
    private double r1 = Double.NaN;
    private double continuousR1 = Double.NaN;
    private LfBranch branch;
    private final double minR1;
    private final double maxR1;

    public PiModelArray(List<PiModel> models, int lowTapPosition, int tapPosition) {
        this.models = Objects.requireNonNull(models);
        this.lowTapPosition = lowTapPosition;
        this.tapPositionIndex = tapPosition - lowTapPosition;
        this.minR1 = this.models.stream().mapToDouble(PiModel::getMinR1).min().orElseThrow();
        this.maxR1 = this.models.stream().mapToDouble(PiModel::getMaxR1).max().orElseThrow();
    }

    List<PiModel> getModels() {
        return this.models;
    }

    private PiModel getModel() {
        return this.models.get(this.tapPositionIndex);
    }

    @Override
    public double getR() {
        return this.getModel().getR();
    }

    @Override
    public PiModel setR(double r) {
        return this.getModel().setR(r);
    }

    @Override
    public double getX() {
        return this.getModel().getX();
    }

    @Override
    public PiModel setX(double x) {
        return this.getModel().setX(x);
    }

    @Override
    public double getZ() {
        return this.getModel().getZ();
    }

    @Override
    public double getY() {
        return this.getModel().getY();
    }

    @Override
    public double getKsi() {
        return this.getModel().getKsi();
    }

    @Override
    public double getG1() {
        return this.getModel().getG1();
    }

    @Override
    public double getB1() {
        return this.getModel().getB1();
    }

    @Override
    public double getG2() {
        return this.getModel().getG2();
    }

    @Override
    public double getB2() {
        return this.getModel().getB2();
    }

    public double getModifiedR1() {
        return this.r1;
    }

    public double getModifiedA1() {
        return this.a1;
    }

    @Override
    public double getR1() {
        return Double.isNaN(this.r1) ? this.getModel().getR1() : this.r1;
    }

    @Override
    public double getContinuousR1() {
        return this.continuousR1;
    }

    @Override
    public double getA1() {
        return Double.isNaN(this.a1) ? this.getModel().getA1() : this.a1;
    }

    @Override
    public PiModelArray setA1(double a1) {
        this.a1 = a1;
        return this;
    }

    @Override
    public PiModelArray setR1(double r1) {
        this.r1 = r1;
        return this;
    }

    private Optional<Direction> updateTapPosition(ToDoubleFunction<PiModel> valueGetter, Range<Integer> positionIndexRange, int maxTapShift, TapPositionFinder finder) {
        int oldPositionIndex = this.tapPositionIndex;
        this.tapPositionIndex = finder.find(this.models, this.tapPositionIndex, valueGetter, positionIndexRange, maxTapShift);
        if (this.tapPositionIndex != oldPositionIndex) {
            for (LfNetworkListener listener : this.branch.getNetwork().getListeners()) {
                listener.onTapPositionChange(this.branch, this.lowTapPosition + oldPositionIndex, this.lowTapPosition + this.tapPositionIndex);
            }
            return Optional.of(this.tapPositionIndex - oldPositionIndex > 0 ? Direction.INCREASE : Direction.DECREASE);
        }
        return Optional.empty();
    }

    private Range<Integer> getAllowedPositionIndexRange(AllowedDirection allowedDirection) {
        switch (allowedDirection) {
            case INCREASE: {
                return Range.of((Comparable)Integer.valueOf(this.tapPositionIndex), (Comparable)Integer.valueOf(this.models.size() - 1));
            }
            case DECREASE: {
                return Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.tapPositionIndex));
            }
            case BOTH: {
                return Range.of((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.models.size() - 1));
            }
        }
        throw new IllegalStateException("Unknown direction: " + allowedDirection);
    }

    @Override
    public void roundA1ToClosestTap() {
        if (Double.isNaN(this.a1)) {
            return;
        }
        this.updateTapPosition(PiModel::getA1, this.getAllowedPositionIndexRange(AllowedDirection.BOTH), Integer.MAX_VALUE, new ClosestTapPositionFinder(this.a1));
        this.a1 = Double.NaN;
    }

    @Override
    public void roundR1ToClosestTap() {
        if (Double.isNaN(this.r1)) {
            return;
        }
        this.updateTapPosition(PiModel::getR1, this.getAllowedPositionIndexRange(AllowedDirection.BOTH), Integer.MAX_VALUE, new ClosestTapPositionFinder(this.r1));
        this.continuousR1 = this.r1;
        this.r1 = Double.NaN;
    }

    @Override
    public boolean shiftOneTapPositionToChangeA1(Direction direction) {
        double currentA1 = this.getA1();
        int oldTapPositionIndex = this.tapPositionIndex;
        if (this.tapPositionIndex < this.models.size() - 1) {
            double nextA1 = this.models.get(this.tapPositionIndex + 1).getA1();
            if (direction == Direction.INCREASE && nextA1 > currentA1 || direction == Direction.DECREASE && nextA1 < currentA1) {
                ++this.tapPositionIndex;
            }
        }
        if (this.tapPositionIndex > 0) {
            double previousA1 = this.models.get(this.tapPositionIndex - 1).getA1();
            if (direction == Direction.INCREASE && previousA1 > currentA1 || direction == Direction.DECREASE && previousA1 < currentA1) {
                --this.tapPositionIndex;
            }
        }
        if (this.tapPositionIndex != oldTapPositionIndex) {
            this.a1 = Double.NaN;
            for (LfNetworkListener listener : this.branch.getNetwork().getListeners()) {
                listener.onTapPositionChange(this.branch, this.lowTapPosition + oldTapPositionIndex, this.lowTapPosition + this.tapPositionIndex);
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<Direction> updateTapPositionToReachNewR1(double deltaR1, int maxTapShift, AllowedDirection allowedDirection) {
        double newR1 = this.getR1() + deltaR1;
        Range<Integer> positionIndexRange = this.getAllowedPositionIndexRange(allowedDirection);
        Optional<Direction> direction = this.updateTapPosition(PiModel::getR1, positionIndexRange, maxTapShift, new ClosestTapPositionFinder(newR1));
        if (direction.isPresent()) {
            this.r1 = Double.NaN;
        }
        return direction;
    }

    @Override
    public Optional<Direction> updateTapPositionToExceedNewA1(double deltaA1, int maxTapShift, AllowedDirection allowedDirection) {
        Range<Integer> positionIndexRange = this.getAllowedPositionIndexRange(allowedDirection);
        Optional<Direction> direction = this.updateTapPosition(PiModel::getA1, positionIndexRange, maxTapShift, new FirstTapPositionAboveFinder(deltaA1));
        if (direction.isPresent()) {
            this.a1 = Double.NaN;
        }
        return direction;
    }

    @Override
    public Optional<Direction> updateTapPositionToReachNewA1(double deltaA1, int maxTapShift, AllowedDirection allowedDirection) {
        double newA1 = this.getA1() + deltaA1;
        Range<Integer> positionIndexRange = this.getAllowedPositionIndexRange(allowedDirection);
        Optional<Direction> direction = this.updateTapPosition(PiModel::getA1, positionIndexRange, maxTapShift, new ClosestTapPositionFinder(newA1));
        if (direction.isPresent()) {
            this.a1 = Double.NaN;
        }
        return direction;
    }

    @Override
    public boolean setMinZ(double minZ, LoadFlowModel loadFlowModel) {
        boolean done = false;
        for (PiModel model : this.models) {
            done |= model.setMinZ(minZ, loadFlowModel);
        }
        return done;
    }

    @Override
    public void setBranch(LfBranch branch) {
        this.branch = Objects.requireNonNull(branch);
    }

    @Override
    public int getTapPosition() {
        return this.lowTapPosition + this.tapPositionIndex;
    }

    @Override
    public PiModel setTapPosition(int tapPosition) {
        Range<Integer> tapPositionRange = this.getTapPositionRange();
        if (!tapPositionRange.contains((Object)tapPosition)) {
            throw new IllegalArgumentException("Tap position " + tapPosition + " out of range " + tapPositionRange);
        }
        if (tapPosition - this.lowTapPosition != this.tapPositionIndex) {
            int oldTapPositionIndex = this.tapPositionIndex;
            this.tapPositionIndex = tapPosition - this.lowTapPosition;
            this.r1 = Double.NaN;
            this.continuousR1 = Double.NaN;
            this.a1 = Double.NaN;
            for (LfNetworkListener listener : this.branch.getNetwork().getListeners()) {
                listener.onTapPositionChange(this.branch, this.lowTapPosition + oldTapPositionIndex, tapPosition);
            }
        }
        return this;
    }

    @Override
    public double getMinR1() {
        return this.minR1;
    }

    @Override
    public double getMaxR1() {
        return this.maxR1;
    }

    @Override
    public Range<Integer> getTapPositionRange() {
        return Range.of((Comparable)Integer.valueOf(this.lowTapPosition), (Comparable)Integer.valueOf(this.lowTapPosition + this.models.size() - 1));
    }

    static interface TapPositionFinder {
        public int find(List<PiModel> var1, int var2, ToDoubleFunction<PiModel> var3, Range<Integer> var4, int var5);
    }

    static class ClosestTapPositionFinder
    implements TapPositionFinder {
        private final double targetValue;

        ClosestTapPositionFinder(double targetValue) {
            this.targetValue = targetValue;
        }

        @Override
        public int find(List<PiModel> models, int tapPositionIndex, ToDoubleFunction<PiModel> valueGetter, Range<Integer> positionIndexRange, int maxTapShift) {
            int closestTapPositionIndex = tapPositionIndex;
            double smallestDistance = Math.abs(this.targetValue - valueGetter.applyAsDouble(models.get(tapPositionIndex)));
            for (int i = ((Integer)positionIndexRange.getMinimum()).intValue(); i <= (Integer)positionIndexRange.getMaximum(); ++i) {
                double distance;
                if (Math.abs(i - tapPositionIndex) > maxTapShift || !((distance = Math.abs(this.targetValue - valueGetter.applyAsDouble(models.get(i)))) < smallestDistance)) continue;
                closestTapPositionIndex = i;
                smallestDistance = distance;
            }
            return closestTapPositionIndex;
        }
    }

    static class FirstTapPositionAboveFinder
    implements TapPositionFinder {
        private final double valueShift;

        FirstTapPositionAboveFinder(double valueShift) {
            this.valueShift = valueShift;
        }

        private static boolean isDescending(int n1, int n2, double valueShift, List<PiModel> models, ToDoubleFunction<PiModel> valueGetter) {
            return valueShift > 0.0 ? valueGetter.applyAsDouble(models.get(n1)) < valueGetter.applyAsDouble(models.get(n2)) : valueGetter.applyAsDouble(models.get(n1)) > valueGetter.applyAsDouble(models.get(n2));
        }

        static int nextTapPositionIndex(int i, double valueShift, List<PiModel> models, ToDoubleFunction<PiModel> valueGetter) {
            if (valueShift == 0.0) {
                return -1;
            }
            if (i == 0 && FirstTapPositionAboveFinder.isDescending(i + 1, i, valueShift, models, valueGetter)) {
                return -1;
            }
            if (i > 0 && FirstTapPositionAboveFinder.isDescending(i, i - 1, valueShift, models, valueGetter)) {
                return i - 1;
            }
            if (i < models.size() - 1 && FirstTapPositionAboveFinder.isDescending(i, i + 1, valueShift, models, valueGetter)) {
                return i + 1;
            }
            if (i == models.size() - 1 && FirstTapPositionAboveFinder.isDescending(i, i - 1, valueShift, models, valueGetter)) {
                return -1;
            }
            return -1;
        }

        @Override
        public int find(List<PiModel> models, int tapPositionIndex, ToDoubleFunction<PiModel> valueGetter, Range<Integer> positionIndexRange, int maxTapShift) {
            int nextTapPositionIndex;
            int currentTapPositionIndex = tapPositionIndex;
            double remainingValueShift = this.valueShift;
            while ((nextTapPositionIndex = FirstTapPositionAboveFinder.nextTapPositionIndex(currentTapPositionIndex, remainingValueShift, models, valueGetter)) != -1 && positionIndexRange.contains((Object)nextTapPositionIndex) && Math.abs(nextTapPositionIndex - tapPositionIndex) <= maxTapShift) {
                double value = valueGetter.applyAsDouble(models.get(currentTapPositionIndex));
                double nextValue = valueGetter.applyAsDouble(models.get(nextTapPositionIndex));
                currentTapPositionIndex = nextTapPositionIndex;
                if (remainingValueShift < 0.0 && value + remainingValueShift > nextValue || remainingValueShift > 0.0 && value + remainingValueShift < nextValue) break;
                remainingValueShift -= nextValue - value;
            }
            return currentTapPositionIndex;
        }
    }
}

