/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.ReferenceBusSelector;
import com.powsybl.openloadflow.network.SelectedReferenceBus;
import java.util.List;
import java.util.Objects;

public class ReferenceBusFirstSlackSelector
implements ReferenceBusSelector {
    private static final String METHOD_NAME = "First slack";

    @Override
    public SelectedReferenceBus select(LfNetwork lfNetwork) {
        Objects.requireNonNull(lfNetwork);
        List<LfBus> slackBuses = lfNetwork.getSlackBuses();
        Objects.requireNonNull(slackBuses);
        if (slackBuses.isEmpty()) {
            throw new IllegalStateException("No slack bus for network " + lfNetwork);
        }
        return new SelectedReferenceBus(slackBuses.get(0), METHOD_NAME);
    }
}

