/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.AllowedDirection;
import com.powsybl.openloadflow.network.Direction;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.PiModel;
import java.util.Optional;
import net.jafama.FastMath;
import org.apache.commons.lang3.Range;

public class SimplePiModel
implements PiModel {
    private double r = 0.0;
    private double x = 0.0;
    private double g1 = 0.0;
    private double b1 = 0.0;
    private double g2 = 0.0;
    private double b2 = 0.0;
    private double r1 = 1.0;
    private double a1 = 0.0;
    private static final String NO_TAP_POSITION_ERROR = "No tap position change in simple Pi model implementation";

    @Override
    public double getR() {
        return this.r;
    }

    @Override
    public SimplePiModel setR(double r) {
        this.r = r;
        return this;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public SimplePiModel setX(double x) {
        this.x = x;
        return this;
    }

    @Override
    public double getZ() {
        return FastMath.hypot((double)this.r, (double)this.x);
    }

    @Override
    public double getY() {
        return 1.0 / this.getZ();
    }

    @Override
    public double getKsi() {
        return FastMath.atan2((double)this.r, (double)this.x);
    }

    @Override
    public double getG1() {
        return this.g1;
    }

    public SimplePiModel setG1(double g1) {
        this.g1 = g1;
        return this;
    }

    @Override
    public double getB1() {
        return this.b1;
    }

    public SimplePiModel setB1(double b1) {
        this.b1 = b1;
        return this;
    }

    @Override
    public double getG2() {
        return this.g2;
    }

    public SimplePiModel setG2(double g2) {
        this.g2 = g2;
        return this;
    }

    @Override
    public double getB2() {
        return this.b2;
    }

    public SimplePiModel setB2(double b2) {
        this.b2 = b2;
        return this;
    }

    @Override
    public double getR1() {
        return this.r1;
    }

    @Override
    public double getMinR1() {
        return this.getR1();
    }

    @Override
    public double getMaxR1() {
        return this.getR1();
    }

    @Override
    public double getContinuousR1() {
        return this.getR1();
    }

    @Override
    public SimplePiModel setR1(double r1) {
        this.r1 = r1;
        return this;
    }

    @Override
    public double getA1() {
        return this.a1;
    }

    @Override
    public SimplePiModel setA1(double a1) {
        this.a1 = a1;
        return this;
    }

    @Override
    public void roundA1ToClosestTap() {
        throw new IllegalStateException("A1 rounding is not supported in simple Pi model implementation");
    }

    @Override
    public void roundR1ToClosestTap() {
        throw new IllegalStateException("R1 rounding is not supported in simple Pi model implementation");
    }

    @Override
    public boolean shiftOneTapPositionToChangeA1(Direction direction) {
        throw new IllegalStateException(NO_TAP_POSITION_ERROR);
    }

    @Override
    public Optional<Direction> updateTapPositionToReachNewR1(double deltaR1, int maxTapShift, AllowedDirection allowedDirection) {
        throw new IllegalStateException(NO_TAP_POSITION_ERROR);
    }

    @Override
    public Optional<Direction> updateTapPositionToExceedNewA1(double deltaA1, int maxTapShift, AllowedDirection allowedDirection) {
        throw new IllegalStateException(NO_TAP_POSITION_ERROR);
    }

    @Override
    public Optional<Direction> updateTapPositionToReachNewA1(double deltaA1, int maxTapShift, AllowedDirection allowedDirection) {
        throw new IllegalStateException(NO_TAP_POSITION_ERROR);
    }

    private void rescaleZ(double z) {
        double ksi = this.getKsi();
        this.r = z * FastMath.sin((double)ksi);
        this.x = z * FastMath.cos((double)ksi);
    }

    @Override
    public boolean setMinZ(double minZ, LoadFlowModel loadFlowModel) {
        if (loadFlowModel == LoadFlowModel.DC) {
            if (FastMath.abs((double)this.x) < minZ) {
                this.x = minZ;
                return true;
            }
        } else {
            double z = this.getZ();
            if (z < minZ) {
                this.rescaleZ(minZ);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setBranch(LfBranch branch) {
    }

    @Override
    public int getTapPosition() {
        throw new IllegalStateException(NO_TAP_POSITION_ERROR);
    }

    @Override
    public PiModel setTapPosition(int tapPosition) {
        throw new IllegalStateException(NO_TAP_POSITION_ERROR);
    }

    @Override
    public Range<Integer> getTapPositionRange() {
        throw new IllegalStateException(NO_TAP_POSITION_ERROR);
    }
}

