/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.iidm.network.Country;
import com.powsybl.openloadflow.network.FirstSlackBusSelector;
import com.powsybl.openloadflow.network.LargestGeneratorSlackBusSelector;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.MostMeshedSlackBusSelector;
import com.powsybl.openloadflow.network.NameSlackBusSelector;
import com.powsybl.openloadflow.network.SelectedSlackBus;
import com.powsybl.openloadflow.network.SlackBusSelectionMode;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public interface SlackBusSelector {
    public SelectedSlackBus select(List<LfBus> var1, int var2);

    public static SlackBusSelector fromMode(SlackBusSelectionMode mode, List<String> slackBusesIds, double plausibleActivePowerLimit, double mostMeshedMaxNominalVoltagePercentile, Set<Country> countries) {
        Objects.requireNonNull(mode);
        Objects.requireNonNull(slackBusesIds);
        switch (mode) {
            case FIRST: {
                return new FirstSlackBusSelector(countries);
            }
            case MOST_MESHED: {
                return new MostMeshedSlackBusSelector(mostMeshedMaxNominalVoltagePercentile, countries);
            }
            case NAME: {
                return new NameSlackBusSelector(slackBusesIds, countries, new MostMeshedSlackBusSelector(mostMeshedMaxNominalVoltagePercentile, countries));
            }
            case LARGEST_GENERATOR: {
                return new LargestGeneratorSlackBusSelector(plausibleActivePowerLimit, countries);
            }
        }
        throw new IllegalStateException("Unknown slack bus selection mode: " + mode);
    }
}

