/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.DiscreteVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.VoltageControl;

public class TransformerVoltageControl
extends DiscreteVoltageControl<LfBranch> {
    public TransformerVoltageControl(LfBus controlledBus, int targetPriority, double targetValue, Double targetDeadband) {
        super(controlledBus, VoltageControl.Type.TRANSFORMER, targetPriority, targetValue, targetDeadband);
    }

    @Override
    public void setTargetValue(double targetValue) {
        if (targetValue != this.targetValue) {
            this.targetValue = targetValue;
            this.controlledBus.getNetwork().getListeners().forEach(l -> l.onTransformerVoltageControlTargetChange(this, targetValue));
        }
    }

    @Override
    public boolean isControllerEnabled(LfBranch controllerElement) {
        return controllerElement.isVoltageControlEnabled();
    }
}

