/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network;

import com.powsybl.openloadflow.network.Control;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfZeroImpedanceNetwork;
import com.powsybl.openloadflow.network.LoadFlowModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class VoltageControl<T extends LfElement>
extends Control {
    public static final List<String> VOLTAGE_CONTROL_PRIORITIES = List.of(Type.GENERATOR.name(), Type.TRANSFORMER.name(), Type.SHUNT.name());
    protected final Type type;
    protected int priority;
    protected int targetPriority;
    protected final LfBus controlledBus;
    protected final List<T> controllerElements = new ArrayList<T>();
    protected MergeStatus mergeStatus = MergeStatus.MAIN;
    protected final List<VoltageControl<T>> mergedDependentVoltageControls = new ArrayList<VoltageControl<T>>();
    protected VoltageControl<T> mainMergedVoltageControl;
    protected boolean disabled = false;

    protected VoltageControl(double targetValue, Type type, int targetPriority, LfBus controlledBus) {
        super(targetValue);
        this.type = Objects.requireNonNull(type);
        this.priority = VOLTAGE_CONTROL_PRIORITIES.indexOf(type.name());
        this.targetPriority = targetPriority;
        this.controlledBus = Objects.requireNonNull(controlledBus);
    }

    public LfBus getControlledBus() {
        return this.controlledBus;
    }

    public List<T> getControllerElements() {
        return this.controllerElements;
    }

    public void addControllerElement(T controllerElement) {
        this.controllerElements.add((LfElement)Objects.requireNonNull(controllerElement));
    }

    public boolean isControllerEnabled(T controllerElement) {
        throw new IllegalStateException();
    }

    public List<VoltageControl<T>> getMergedDependentVoltageControls() {
        return this.mergedDependentVoltageControls;
    }

    protected int getPriority() {
        return this.priority;
    }

    public int getTargetPriority() {
        return this.targetPriority;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDisabled() {
        if (this.disabled) {
            return true;
        }
        if (this.getMergedControlledBuses().stream().allMatch(LfElement::isDisabled)) {
            return true;
        }
        return this.getMergedControllerElements().stream().allMatch(LfElement::isDisabled);
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public MergeStatus getMergeStatus() {
        return this.mergeStatus;
    }

    public <E extends VoltageControl<T>> E getMainVoltageControl() {
        return (E)(switch (this.mergeStatus) {
            default -> throw new IncompatibleClassChangeError();
            case MergeStatus.MAIN -> this;
            case MergeStatus.DEPENDENT -> this.mainMergedVoltageControl;
        });
    }

    public List<LfBus> getMergedControlledBuses() {
        if (this.mergedDependentVoltageControls.isEmpty()) {
            return List.of(this.controlledBus);
        }
        ArrayList<LfBus> mergedControlledBuses = new ArrayList<LfBus>(1);
        mergedControlledBuses.add(this.controlledBus);
        for (VoltageControl<T> mvc : this.mergedDependentVoltageControls) {
            mergedControlledBuses.add(mvc.getControlledBus());
        }
        return mergedControlledBuses;
    }

    public List<T> getMergedControllerElements() {
        if (this.mergedDependentVoltageControls.isEmpty()) {
            return this.controllerElements;
        }
        ArrayList<T> mergedControllerElements = new ArrayList<T>(this.controllerElements);
        for (VoltageControl<T> mvc : this.mergedDependentVoltageControls) {
            mergedControllerElements.addAll(mvc.getControllerElements());
        }
        return mergedControllerElements;
    }

    private static void addMainVoltageControls(List<VoltageControl<?>> voltageControls, LfBus bus) {
        if (bus.isVoltageControlled()) {
            for (VoltageControl<?> vc : bus.getVoltageControls()) {
                if (vc.isDisabled() || vc.getMergeStatus() == MergeStatus.DEPENDENT) continue;
                voltageControls.add(vc);
            }
        }
    }

    public static OptionalDouble getHighestPriorityTargetV(LfBus bus) {
        List<VoltageControl<?>> voltageControls = VoltageControl.findMainVoltageControls(bus);
        if (voltageControls.isEmpty()) {
            return OptionalDouble.empty();
        }
        voltageControls.sort(Comparator.comparingInt(VoltageControl::getTargetPriority));
        return OptionalDouble.of(voltageControls.get(0).getTargetValue());
    }

    private static List<VoltageControl<?>> findMainVoltageControls(LfBus bus) {
        ArrayList voltageControls = new ArrayList();
        LfZeroImpedanceNetwork zn = bus.getZeroImpedanceNetwork(LoadFlowModel.AC);
        if (zn != null) {
            for (LfBus zb : zn.getGraph().vertexSet()) {
                VoltageControl.addMainVoltageControls(voltageControls, zb);
            }
        } else {
            VoltageControl.addMainVoltageControls(voltageControls, bus);
        }
        return voltageControls;
    }

    private static List<VoltageControl<?>> findMainVoltageControlsSortedByPriority(LfBus bus) {
        List<VoltageControl<?>> voltageControls = VoltageControl.findMainVoltageControls(bus);
        voltageControls.sort(Comparator.comparingInt(VoltageControl::getPriority));
        return voltageControls;
    }

    public boolean isHidden() {
        List<VoltageControl<?>> mainVoltageControls = VoltageControl.findMainVoltageControlsSortedByPriority(this.controlledBus);
        if (mainVoltageControls.isEmpty()) {
            return true;
        }
        return mainVoltageControls.get(0) != this.getMainVoltageControl();
    }

    public boolean isVisible() {
        return !this.isHidden();
    }

    public Optional<LfBus> findMainVisibleControlledBus() {
        List<VoltageControl<?>> mainVoltageControls = VoltageControl.findMainVoltageControlsSortedByPriority(this.controlledBus);
        if (mainVoltageControls.isEmpty()) {
            return Optional.empty();
        }
        List<VoltageControl> visibleMainVoltageControls = mainVoltageControls.stream().filter(VoltageControl::isVisible).toList();
        if (visibleMainVoltageControls.size() == 1) {
            return Optional.of(visibleMainVoltageControls.get(0).getControlledBus());
        }
        throw new IllegalStateException("Several visible controlled buses, it should not happen");
    }

    public static boolean checkTargetV(double targetV, double nominalV, LfNetworkParameters parameters) {
        return nominalV <= parameters.getMinNominalVoltageTargetVoltageCheck() || VoltageControl.isTargetVoltagePlausible(targetV, parameters.getMinPlausibleTargetVoltage(), parameters.getMaxPlausibleTargetVoltage());
    }

    public static boolean isTargetVoltagePlausible(double targetV, double minPlausibleTargetVoltage, double maxPlausibleTargetVoltage) {
        return targetV >= minPlausibleTargetVoltage && targetV <= maxPlausibleTargetVoltage;
    }

    public String toString() {
        return "VoltageControl(type=" + this.type + ", controlledBus='" + this.controlledBus + "', controllerElements=" + this.controllerElements + ", mergeStatus=" + this.mergeStatus + ", mergedDependentVoltageControlsSize=" + this.mergedDependentVoltageControls.size() + ")";
    }

    public static enum MergeStatus {
        MAIN,
        DEPENDENT;

    }

    public static enum Type {
        GENERATOR,
        TRANSFORMER,
        SHUNT;

    }
}

