/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.impl.AbstractLfBranch;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.EvaluableConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractImpedantLfBranch
extends AbstractLfBranch {
    protected boolean connectedSide1;
    protected boolean connectedSide2;
    protected boolean disconnectionAllowedSide1 = false;
    protected boolean disconnectionAllowedSide2 = false;
    protected Evaluable p1 = EvaluableConstants.NAN;
    protected Evaluable q1 = EvaluableConstants.NAN;
    protected Evaluable i1 = EvaluableConstants.NAN;
    protected Evaluable p2 = EvaluableConstants.NAN;
    protected Evaluable q2 = EvaluableConstants.NAN;
    protected Evaluable i2 = EvaluableConstants.NAN;
    protected Evaluable openP1 = EvaluableConstants.NAN;
    protected Evaluable openQ1 = EvaluableConstants.NAN;
    protected Evaluable openI1 = EvaluableConstants.NAN;
    protected Evaluable openP2 = EvaluableConstants.NAN;
    protected Evaluable openQ2 = EvaluableConstants.NAN;
    protected Evaluable openI2 = EvaluableConstants.NAN;
    protected Evaluable closedP1 = EvaluableConstants.NAN;
    protected Evaluable closedQ1 = EvaluableConstants.NAN;
    protected Evaluable closedI1 = EvaluableConstants.NAN;
    protected Evaluable closedP2 = EvaluableConstants.NAN;
    protected Evaluable closedQ2 = EvaluableConstants.NAN;
    protected Evaluable closedI2 = EvaluableConstants.NAN;
    protected final List<Evaluable> additionalOpenP1 = new ArrayList<Evaluable>();
    protected final List<Evaluable> additionalClosedP1 = new ArrayList<Evaluable>();
    protected final List<Evaluable> additionalOpenQ1 = new ArrayList<Evaluable>();
    protected final List<Evaluable> additionalClosedQ1 = new ArrayList<Evaluable>();
    protected final List<Evaluable> additionalOpenP2 = new ArrayList<Evaluable>();
    protected final List<Evaluable> additionalClosedP2 = new ArrayList<Evaluable>();
    protected final List<Evaluable> additionalOpenQ2 = new ArrayList<Evaluable>();
    protected final List<Evaluable> additionalClosedQ2 = new ArrayList<Evaluable>();

    protected AbstractImpedantLfBranch(LfNetwork network, LfBus bus1, LfBus bus2, PiModel piModel, LfNetworkParameters parameters) {
        super(network, bus1, bus2, piModel, parameters);
        this.connectedSide1 = bus1 != null;
        this.connectedSide2 = bus2 != null;
    }

    @Override
    public boolean isDisconnectionAllowedSide1() {
        return this.disconnectionAllowedSide1;
    }

    @Override
    public void setDisconnectionAllowedSide1(boolean disconnectionAllowedSide1) {
        if (this.bus1 == null) {
            throw new PowsyblException("Side 1 of branch '" + this.getId() + "' is already disconnected at loading");
        }
        this.disconnectionAllowedSide1 = disconnectionAllowedSide1;
    }

    @Override
    public boolean isDisconnectionAllowedSide2() {
        return this.disconnectionAllowedSide2;
    }

    @Override
    public void setDisconnectionAllowedSide2(boolean disconnectionAllowedSide2) {
        if (this.bus2 == null) {
            throw new PowsyblException("Side 2 of branch '" + this.getId() + "' is already disconnected at loading");
        }
        this.disconnectionAllowedSide2 = disconnectionAllowedSide2;
    }

    @Override
    public boolean isConnectedSide1() {
        return this.bus1 != null && this.connectedSide1;
    }

    @Override
    public void setConnectedSide1(boolean connectedSide1) {
        if (!this.disconnectionAllowedSide1) {
            throw new PowsyblException("Disconnection side 1 of branch '" + this.getId() + "' is not allowed");
        }
        if (connectedSide1 != this.connectedSide1) {
            this.connectedSide1 = connectedSide1;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onBranchConnectionStatusChange(this, TwoSides.ONE, connectedSide1);
            }
            if (!this.isConnectedSide1() && !this.isConnectedSide2()) {
                this.setDisabled(false);
            }
        }
    }

    @Override
    public boolean isConnectedSide2() {
        return this.bus2 != null && this.connectedSide2;
    }

    @Override
    public void setConnectedSide2(boolean connectedSide2) {
        if (!this.disconnectionAllowedSide2) {
            throw new PowsyblException("Disconnection side 2 of branch '" + this.getId() + "' is not allowed");
        }
        if (connectedSide2 != this.connectedSide2) {
            this.connectedSide2 = connectedSide2;
            for (LfNetworkListener listener : this.network.getListeners()) {
                listener.onBranchConnectionStatusChange(this, TwoSides.TWO, connectedSide2);
            }
            if (!this.isConnectedSide1() && !this.isConnectedSide2()) {
                this.setDisabled(false);
            }
        }
    }

    @Override
    public void setP1(Evaluable p1) {
        this.p1 = Objects.requireNonNull(p1);
    }

    @Override
    public Evaluable getP1() {
        return this.p1;
    }

    @Override
    public void setP2(Evaluable p2) {
        this.p2 = Objects.requireNonNull(p2);
    }

    @Override
    public Evaluable getP2() {
        return this.p2;
    }

    @Override
    public void setQ1(Evaluable q1) {
        this.q1 = Objects.requireNonNull(q1);
    }

    @Override
    public Evaluable getQ1() {
        return this.q1;
    }

    @Override
    public void setQ2(Evaluable q2) {
        this.q2 = Objects.requireNonNull(q2);
    }

    @Override
    public Evaluable getQ2() {
        return this.q2;
    }

    @Override
    public void setI1(Evaluable i1) {
        this.i1 = Objects.requireNonNull(i1);
    }

    @Override
    public Evaluable getI1() {
        return this.i1;
    }

    @Override
    public void setI2(Evaluable i2) {
        this.i2 = Objects.requireNonNull(i2);
    }

    @Override
    public Evaluable getI2() {
        return this.i2;
    }

    @Override
    public Evaluable getOpenP1() {
        return this.openP1;
    }

    @Override
    public void setOpenP1(Evaluable openP1) {
        this.openP1 = Objects.requireNonNull(openP1);
    }

    @Override
    public Evaluable getOpenQ1() {
        return this.openQ1;
    }

    @Override
    public void setOpenQ1(Evaluable openQ1) {
        this.openQ1 = Objects.requireNonNull(openQ1);
    }

    @Override
    public Evaluable getOpenI1() {
        return this.openI1;
    }

    @Override
    public void setOpenI1(Evaluable openI1) {
        this.openI1 = Objects.requireNonNull(openI1);
    }

    @Override
    public Evaluable getOpenP2() {
        return this.openP2;
    }

    @Override
    public void setOpenP2(Evaluable openP2) {
        this.openP2 = Objects.requireNonNull(openP2);
    }

    @Override
    public Evaluable getOpenQ2() {
        return this.openQ2;
    }

    @Override
    public void setOpenQ2(Evaluable openQ2) {
        this.openQ2 = Objects.requireNonNull(openQ2);
    }

    @Override
    public Evaluable getOpenI2() {
        return this.openI2;
    }

    @Override
    public void setOpenI2(Evaluable openI2) {
        this.openI2 = Objects.requireNonNull(openI2);
    }

    @Override
    public Evaluable getClosedP1() {
        return this.closedP1;
    }

    @Override
    public void setClosedP1(Evaluable closedP1) {
        this.closedP1 = Objects.requireNonNull(closedP1);
    }

    @Override
    public Evaluable getClosedQ1() {
        return this.closedQ1;
    }

    @Override
    public void setClosedQ1(Evaluable closedQ1) {
        this.closedQ1 = Objects.requireNonNull(closedQ1);
    }

    @Override
    public Evaluable getClosedI1() {
        return this.closedI1;
    }

    @Override
    public void setClosedI1(Evaluable closedI1) {
        this.closedI1 = Objects.requireNonNull(closedI1);
    }

    @Override
    public Evaluable getClosedP2() {
        return this.closedP2;
    }

    @Override
    public void setClosedP2(Evaluable closedP2) {
        this.closedP2 = Objects.requireNonNull(closedP2);
    }

    @Override
    public Evaluable getClosedQ2() {
        return this.closedQ2;
    }

    @Override
    public void setClosedQ2(Evaluable closedQ2) {
        this.closedQ2 = Objects.requireNonNull(closedQ2);
    }

    @Override
    public Evaluable getClosedI2() {
        return this.closedI2;
    }

    @Override
    public void setClosedI2(Evaluable closedI2) {
        this.closedI2 = Objects.requireNonNull(closedI2);
    }

    @Override
    public void addAdditionalOpenP1(Evaluable openP1) {
        this.additionalOpenP1.add(openP1);
    }

    @Override
    public List<Evaluable> getAdditionalOpenP1() {
        return this.additionalOpenP1;
    }

    @Override
    public void addAdditionalClosedP1(Evaluable closedP1) {
        this.additionalClosedP1.add(closedP1);
    }

    @Override
    public List<Evaluable> getAdditionalClosedP1() {
        return this.additionalClosedP1;
    }

    @Override
    public void addAdditionalOpenQ1(Evaluable openQ1) {
        this.additionalOpenQ1.add(openQ1);
    }

    @Override
    public List<Evaluable> getAdditionalOpenQ1() {
        return this.additionalOpenQ1;
    }

    @Override
    public void addAdditionalClosedQ1(Evaluable closedQ1) {
        this.additionalClosedQ1.add(closedQ1);
    }

    @Override
    public List<Evaluable> getAdditionalClosedQ1() {
        return this.additionalClosedQ1;
    }

    @Override
    public void addAdditionalOpenP2(Evaluable openP2) {
        this.additionalOpenP2.add(openP2);
    }

    @Override
    public List<Evaluable> getAdditionalOpenP2() {
        return this.additionalOpenP2;
    }

    @Override
    public void addAdditionalClosedP2(Evaluable closedP2) {
        this.additionalClosedP2.add(closedP2);
    }

    @Override
    public List<Evaluable> getAdditionalClosedP2() {
        return this.additionalClosedP2;
    }

    @Override
    public void addAdditionalOpenQ2(Evaluable openQ2) {
        this.additionalOpenQ2.add(openQ2);
    }

    @Override
    public List<Evaluable> getAdditionalOpenQ2() {
        return this.additionalOpenQ2;
    }

    @Override
    public void addAdditionalClosedQ2(Evaluable closedQ2) {
        this.additionalClosedQ2.add(closedQ2);
    }

    @Override
    public List<Evaluable> getAdditionalClosedQ2() {
        return this.additionalClosedQ2;
    }

    @Override
    public void removeEvaluable(Evaluable evaluable) {
        if (this.p1 == evaluable) {
            this.p1 = EvaluableConstants.NAN;
        }
        if (this.closedP1 == evaluable) {
            this.closedP1 = EvaluableConstants.NAN;
        }
        if (this.openP1 == evaluable) {
            this.openP1 = EvaluableConstants.NAN;
        }
        if (this.q1 == evaluable) {
            this.q1 = EvaluableConstants.NAN;
        }
        if (this.closedQ1 == evaluable) {
            this.closedQ1 = EvaluableConstants.NAN;
        }
        if (this.openQ1 == evaluable) {
            this.openQ1 = EvaluableConstants.NAN;
        }
        if (this.i1 == evaluable) {
            this.i1 = EvaluableConstants.NAN;
        }
        if (this.closedI1 == evaluable) {
            this.closedI1 = EvaluableConstants.NAN;
        }
        if (this.openI1 == evaluable) {
            this.openI1 = EvaluableConstants.NAN;
        }
        if (this.p2 == evaluable) {
            this.p2 = EvaluableConstants.NAN;
        }
        if (this.closedP2 == evaluable) {
            this.closedP2 = EvaluableConstants.NAN;
        }
        if (this.openP2 == evaluable) {
            this.openP2 = EvaluableConstants.NAN;
        }
        if (this.q2 == evaluable) {
            this.q2 = EvaluableConstants.NAN;
        }
        if (this.closedQ2 == evaluable) {
            this.closedQ2 = EvaluableConstants.NAN;
        }
        if (this.openQ2 == evaluable) {
            this.openQ2 = EvaluableConstants.NAN;
        }
        if (this.i2 == evaluable) {
            this.i2 = EvaluableConstants.NAN;
        }
        if (this.closedI2 == evaluable) {
            this.closedI2 = EvaluableConstants.NAN;
        }
        if (this.openI2 == evaluable) {
            this.openI2 = EvaluableConstants.NAN;
        }
        this.additionalClosedP1.remove(evaluable);
        this.additionalOpenP1.remove(evaluable);
        this.additionalClosedQ1.remove(evaluable);
        this.additionalOpenQ1.remove(evaluable);
        this.additionalClosedP2.remove(evaluable);
        this.additionalOpenP2.remove(evaluable);
        this.additionalClosedQ2.remove(evaluable);
        this.additionalOpenQ2.remove(evaluable);
    }

    protected double getV1() {
        return this.getBus1() != null ? this.getBus1().getV() : Double.NaN;
    }

    protected double getV2() {
        return this.getBus2() != null ? this.getBus2().getV() : Double.NaN;
    }

    protected double getAngle1() {
        return this.getBus1() != null ? this.getBus1().getAngle() : Double.NaN;
    }

    protected double getAngle2() {
        return this.getBus2() != null ? this.getBus2().getAngle() : Double.NaN;
    }
}

