/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.MinMaxReactiveLimits;
import com.powsybl.iidm.network.ReactiveCapabilityCurve;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.openloadflow.network.LfAsymGenerator;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfReferencePriorityInjection;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.network.impl.AbstractLfInjection;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLfGenerator
extends AbstractLfInjection
implements LfGenerator,
LfReferencePriorityInjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLfGenerator.class);
    private static final double POWER_EPSILON_SI = 1.0E-4;
    protected static final double DEFAULT_DROOP = 4.0;
    protected final LfNetwork network;
    protected LfBus bus;
    protected double calculatedQ = Double.NaN;
    protected double targetV = Double.NaN;
    protected LfGenerator.GeneratorControlType generatorControlType = LfGenerator.GeneratorControlType.OFF;
    protected String controlledBusId;
    protected String controlledBranchId;
    protected TwoSides controlledBranchSide;
    protected double remoteTargetQ = Double.NaN;
    private boolean disabled;
    protected LfAsymGenerator asym;
    protected int referencePriority;
    protected boolean reference;

    protected AbstractLfGenerator(LfNetwork network, double targetP) {
        super(targetP, targetP);
        this.network = Objects.requireNonNull(network);
    }

    @Override
    public String getOriginalId() {
        return this.getId();
    }

    @Override
    public LfBus getBus() {
        return this.bus;
    }

    @Override
    public void setBus(LfBus bus) {
        this.bus = bus;
    }

    @Override
    public boolean isFictitious() {
        return false;
    }

    @Override
    public void setTargetP(double targetP) {
        if (targetP != this.targetP) {
            double oldTargetP = this.targetP;
            this.targetP = targetP;
            this.bus.invalidateGenerationTargetP();
            for (LfNetworkListener listener : this.bus.getNetwork().getListeners()) {
                listener.onGenerationActivePowerTargetChange(this, oldTargetP, targetP);
            }
        }
    }

    @Override
    public double getTargetV() {
        return this.targetV;
    }

    @Override
    public LfGenerator.GeneratorControlType getGeneratorControlType() {
        return this.generatorControlType;
    }

    @Override
    public void setGeneratorControlType(LfGenerator.GeneratorControlType generatorControlType) {
        this.generatorControlType = Objects.requireNonNull(generatorControlType);
    }

    @Override
    public boolean hasRemoteReactivePowerControl() {
        return this.generatorControlType == LfGenerator.GeneratorControlType.REMOTE_REACTIVE_POWER;
    }

    @Override
    public OptionalDouble getRemoteControlReactiveKey() {
        return OptionalDouble.empty();
    }

    protected abstract Optional<ReactiveLimits> getReactiveLimits();

    @Override
    public double getMinQ() {
        return this.getReactiveLimits().map(limits -> limits.getMinQ(this.targetP * 100.0) / 100.0).orElse(-1.7976931348623157E308);
    }

    @Override
    public double getMaxQ() {
        return this.getReactiveLimits().map(limits -> limits.getMaxQ(this.targetP * 100.0) / 100.0).orElse((Double)Double.MAX_VALUE);
    }

    @Override
    public double getRangeQ(LfGenerator.ReactiveRangeMode rangeMode) {
        double rangeQ = Double.NaN;
        ReactiveLimits reactiveLimits = this.getReactiveLimits().orElse(null);
        if (reactiveLimits != null) {
            switch (reactiveLimits.getKind()) {
                case CURVE: {
                    ReactiveCapabilityCurve reactiveCapabilityCurve = (ReactiveCapabilityCurve)reactiveLimits;
                    if (rangeMode == LfGenerator.ReactiveRangeMode.MIN || rangeMode == LfGenerator.ReactiveRangeMode.MAX) {
                        for (ReactiveCapabilityCurve.Point point : reactiveCapabilityCurve.getPoints()) {
                            if (Double.isNaN(rangeQ)) {
                                rangeQ = point.getMaxQ() - point.getMinQ();
                                continue;
                            }
                            rangeQ = rangeMode == LfGenerator.ReactiveRangeMode.MAX ? Math.max(rangeQ, point.getMaxQ() - point.getMinQ()) : Math.min(rangeQ, point.getMaxQ() - point.getMinQ());
                        }
                        break;
                    }
                    if (rangeMode == LfGenerator.ReactiveRangeMode.TARGET_P) {
                        rangeQ = reactiveLimits.getMaxQ(this.targetP * 100.0) - reactiveLimits.getMinQ(this.targetP * 100.0);
                        break;
                    }
                    throw new PowsyblException("Unsupported reactive range mode: " + rangeMode);
                }
                case MIN_MAX: {
                    MinMaxReactiveLimits minMaxReactiveLimits = (MinMaxReactiveLimits)reactiveLimits;
                    rangeQ = minMaxReactiveLimits.getMaxQ() - minMaxReactiveLimits.getMinQ();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown reactive limits kind: " + reactiveLimits.getKind());
                }
            }
            return rangeQ / 100.0;
        }
        return Double.MAX_VALUE;
    }

    @Override
    public double getCalculatedQ() {
        return this.calculatedQ;
    }

    @Override
    public void setCalculatedQ(double calculatedQ) {
        this.calculatedQ = calculatedQ;
    }

    @Override
    public LfBus getControlledBus() {
        return this.network.getBusById(this.controlledBusId);
    }

    protected void setVoltageControl(double targetV, Terminal terminal, Terminal regulatingTerminal, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        boolean inSameSynchronousComponent;
        Bus controlledBus;
        if (!this.checkVoltageControlConsistency(parameters, report)) {
            return;
        }
        Bus bus = controlledBus = parameters.isBreakers() ? regulatingTerminal.getBusBreakerView().getBus() : regulatingTerminal.getBusView().getBus();
        if (controlledBus == null) {
            LOGGER.warn("Regulating terminal of LfGenerator {} is out of voltage: voltage control discarded", (Object)this.getId());
            return;
        }
        boolean bl = parameters.isBreakers() ? regulatingTerminal.getBusBreakerView().getBus().getSynchronousComponent().getNum() == terminal.getBusBreakerView().getBus().getSynchronousComponent().getNum() : (inSameSynchronousComponent = regulatingTerminal.getBusView().getBus().getSynchronousComponent().getNum() == terminal.getBusView().getBus().getSynchronousComponent().getNum());
        if (!inSameSynchronousComponent) {
            LOGGER.warn("Regulating terminal of LfGenerator {} is not in the same synchronous component: voltage control discarded", (Object)this.getId());
            return;
        }
        if (!AbstractLfGenerator.checkTargetV(this.getId(), targetV / regulatingTerminal.getVoltageLevel().getNominalV(), regulatingTerminal.getVoltageLevel().getNominalV(), parameters, report)) {
            return;
        }
        this.controlledBusId = controlledBus.getId();
        this.targetV = targetV / regulatingTerminal.getVoltageLevel().getNominalV();
        this.generatorControlType = LfGenerator.GeneratorControlType.VOLTAGE;
    }

    protected boolean checkVoltageControlConsistency(LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        return this.checkIfReactiveRangesAreLargeEnoughForVoltageControl(parameters, report) && this.checkIfGeneratorStartedForVoltageControl(report) && this.checkIfGeneratorIsInsideActivePowerLimitsForVoltageControl(parameters, report);
    }

    protected boolean checkIfReactiveRangesAreLargeEnoughForVoltageControl(LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        if (!parameters.isReactiveLimits()) {
            return true;
        }
        boolean consistency = true;
        switch (parameters.getReactiveRangeCheckMode()) {
            case MIN_MAX: {
                double minRangeQ = this.getRangeQ(LfGenerator.ReactiveRangeMode.MIN);
                double maxRangeQ = this.getRangeQ(LfGenerator.ReactiveRangeMode.MAX);
                if (!(maxRangeQ < 0.01) && minRangeQ != 0.0) break;
                LOGGER.trace("Discard generator '{}' from voltage control because min or max reactive ranges (min: {} and max: {}) are too small", new Object[]{this.getId(), minRangeQ, maxRangeQ});
                ++report.generatorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall;
                consistency = false;
                break;
            }
            case MAX: {
                double rangeQ = this.getRangeQ(LfGenerator.ReactiveRangeMode.MAX);
                if (!(rangeQ < 0.01)) break;
                LOGGER.trace("Discard generator '{}' from voltage control because max reactive range ({}) is too small", (Object)this.getId(), (Object)rangeQ);
                ++report.generatorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall;
                consistency = false;
                break;
            }
            case TARGET_P: {
                double rangeQ = this.getRangeQ(LfGenerator.ReactiveRangeMode.TARGET_P);
                if (!(rangeQ < 0.01)) break;
                LOGGER.trace("Discard generator '{}' from voltage control because reactive range at targetP ({}) is too small", (Object)this.getId(), (Object)rangeQ);
                ++report.generatorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall;
                consistency = false;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown reactive range check mode: " + parameters.getReactiveRangeCheckMode());
            }
        }
        return consistency;
    }

    protected boolean checkIfGeneratorStartedForVoltageControl(LfNetworkLoadingReport report) {
        if (Math.abs(this.getTargetP()) < 1.0E-4 && this.getMinP() > 1.0E-4) {
            LOGGER.trace("Discard generator '{}' from voltage control because not started (targetP={} MW, minP={} MW)", new Object[]{this.getId(), this.getTargetP(), this.getMinP()});
            ++report.generatorsDiscardedFromVoltageControlBecauseNotStarted;
            return false;
        }
        return true;
    }

    protected boolean checkIfGeneratorIsInsideActivePowerLimitsForVoltageControl(LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        if (parameters.isUseActiveLimits() && parameters.isDisableVoltageControlOfGeneratorsOutsideActivePowerLimits() && (this.getTargetP() < this.getMinP() || this.getTargetP() > this.getMaxP())) {
            LOGGER.trace("Discard generator '{}' from voltage control because targetP is outside active power limits (targetP={} MW, minP={} MW, maxP={} MW)", new Object[]{this.getId(), this.getTargetP(), this.getMinP(), this.getMaxP()});
            ++report.generatorsDiscardedFromVoltageControlBecauseTargetPIsOutsideActiveLimits;
            return false;
        }
        return true;
    }

    public static boolean checkTargetV(String generatorId, double targetV, double nominalV, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        if (!VoltageControl.checkTargetV(targetV, nominalV, parameters)) {
            LOGGER.trace("Generator '{}' has an inconsistent target voltage: {} pu: generator voltage control discarded", (Object)generatorId, (Object)targetV);
            if (report != null) {
                ++report.generatorsWithInconsistentTargetVoltage;
            }
            return false;
        }
        return true;
    }

    protected void setRemoteReactivePowerControl(Terminal regulatingTerminal, double targetQ) {
        Connectable connectable = regulatingTerminal.getConnectable();
        if (connectable instanceof Branch) {
            Branch branch = (Branch)connectable;
            this.controlledBranchSide = branch.getSide(regulatingTerminal);
            this.controlledBranchId = branch.getId();
        } else if (connectable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer t3w = (ThreeWindingsTransformer)connectable;
            this.controlledBranchSide = TwoSides.ONE;
            this.controlledBranchId = LfLegBranch.getId(t3w.getSide(regulatingTerminal), t3w.getId());
        } else {
            LOGGER.error("Generator '{}' is remotely controlling reactive power of an instance of {}: not supported", (Object)this.getId(), connectable.getClass());
            return;
        }
        this.generatorControlType = LfGenerator.GeneratorControlType.REMOTE_REACTIVE_POWER;
        this.remoteTargetQ = targetQ / 100.0;
    }

    @Override
    public LfBranch getControlledBranch() {
        return this.network.getBranchById(this.controlledBranchId);
    }

    @Override
    public TwoSides getControlledBranchSide() {
        return this.controlledBranchSide;
    }

    @Override
    public double getRemoteTargetQ() {
        return this.remoteTargetQ;
    }

    @Override
    public void setParticipating(boolean participating) {
    }

    public static boolean checkActivePowerControl(String generatorId, double targetP, double maxP, double minTargetP, double maxTargetP, double plausibleActivePowerLimit, boolean useActiveLimits, LfNetworkLoadingReport report) {
        boolean participating = true;
        if (Math.abs(targetP) < 1.0E-4) {
            LOGGER.trace("Discard generator '{}' from active power control because targetP ({} MW) equals 0", (Object)generatorId, (Object)targetP);
            if (report != null) {
                ++report.generatorsDiscardedFromActivePowerControlBecauseTargetEqualsToZero;
            }
            participating = false;
        }
        if (maxP > plausibleActivePowerLimit) {
            LOGGER.trace("Discard generator '{}' from active power control because maxP ({} MW) > plausibleLimit ({} MW)", new Object[]{generatorId, maxP, plausibleActivePowerLimit});
            if (report != null) {
                ++report.generatorsDiscardedFromActivePowerControlBecauseMaxPNotPlausible;
            }
            participating = false;
        }
        if (!useActiveLimits) {
            return participating;
        }
        if (targetP > maxTargetP) {
            LOGGER.trace("Discard generator '{}' from active power control because targetP ({} MW) > maxTargetP ({} MW)", new Object[]{generatorId, targetP, maxTargetP});
            if (report != null) {
                ++report.generatorsDiscardedFromActivePowerControlBecauseTargetPGreaterThanMaxP;
            }
            participating = false;
        }
        if (targetP < minTargetP) {
            LOGGER.trace("Discard generator '{}' from active power control because targetP ({} MW) < minTargetP ({} MW)", new Object[]{generatorId, targetP, minTargetP});
            if (report != null) {
                ++report.generatorsDiscardedFromActivePowerControlBecauseTargetPLowerThanMinP;
            }
            participating = false;
        }
        if (maxTargetP - minTargetP < 1.0E-4) {
            LOGGER.trace("Discard generator '{}' from active power control because maxP ({} MW) equals minP ({} MW)", new Object[]{generatorId, minTargetP, minTargetP});
            if (report != null) {
                ++report.generatorsDiscardedFromActivePowerControlBecauseMaxPEqualsMinP;
            }
            participating = false;
        }
        return participating;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public LfAsymGenerator getAsym() {
        return this.asym;
    }

    @Override
    public void setAsym(LfAsymGenerator asym) {
        this.asym = asym;
    }

    @Override
    public int getReferencePriority() {
        return this.referencePriority;
    }

    @Override
    public void setReferencePriority(int referencePriority) {
        this.referencePriority = referencePriority;
    }

    @Override
    public boolean isReference() {
        return this.reference;
    }

    @Override
    public void setReference(boolean reference) {
        this.reference = reference;
    }

    protected record ActivePowerControlHelper(boolean participating, double participationFactor, double droop, double minTargetP, double maxTargetP) {
        static ActivePowerControlHelper create(Injection<?> injection, double minP, double maxP) {
            boolean participating = true;
            double participationFactor = 0.0;
            double droop = 4.0;
            double minTargetP = minP;
            double maxTargetP = maxP;
            ActivePowerControl activePowerControl = (ActivePowerControl)injection.getExtension(ActivePowerControl.class);
            if (activePowerControl != null) {
                participating = activePowerControl.isParticipate();
                if (!Double.isNaN(activePowerControl.getDroop())) {
                    droop = activePowerControl.getDroop();
                }
                if (activePowerControl.getParticipationFactor() > 0.0) {
                    participationFactor = activePowerControl.getParticipationFactor();
                }
                if (activePowerControl.getMinTargetP().isPresent()) {
                    minTargetP = activePowerControl.getMinTargetP().getAsDouble();
                }
                if (activePowerControl.getMaxTargetP().isPresent()) {
                    maxTargetP = activePowerControl.getMaxTargetP().getAsDouble();
                }
            }
            return new ActivePowerControlHelper(participating, participationFactor, droop, minTargetP, maxTargetP);
        }
    }
}

