/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.extensions.VoltageRegulation;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.impl.AbstractLfGenerator;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.Ref;
import java.util.Objects;
import java.util.Optional;

public final class LfBatteryImpl
extends AbstractLfGenerator {
    private final Ref<Battery> batteryRef;
    private boolean participating;
    private final double droop;
    private final double participationFactor;
    private final double maxTargetP;
    private final double minTargetP;

    private LfBatteryImpl(Battery battery, LfNetwork network, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        super(network, battery.getTargetP() / 100.0);
        VoltageRegulation voltageRegulation;
        this.batteryRef = Ref.create(battery, parameters.isCacheEnabled());
        AbstractLfGenerator.ActivePowerControlHelper apcHelper = AbstractLfGenerator.ActivePowerControlHelper.create(battery, battery.getMinP(), battery.getMaxP());
        this.participating = apcHelper.participating();
        this.participationFactor = apcHelper.participationFactor();
        this.droop = apcHelper.droop();
        this.minTargetP = apcHelper.minTargetP();
        this.maxTargetP = apcHelper.maxTargetP();
        if (!LfBatteryImpl.checkActivePowerControl(this.getId(), battery.getTargetP(), battery.getMaxP(), this.minTargetP, this.maxTargetP, parameters.getPlausibleActivePowerLimit(), parameters.isUseActiveLimits(), report)) {
            this.participating = false;
        }
        if ((voltageRegulation = (VoltageRegulation)battery.getExtension(VoltageRegulation.class)) != null && voltageRegulation.isVoltageRegulatorOn()) {
            this.setVoltageControl(voltageRegulation.getTargetV(), battery.getTerminal(), voltageRegulation.getRegulatingTerminal(), parameters, report);
        }
    }

    public static LfBatteryImpl create(Battery battery, LfNetwork network, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        Objects.requireNonNull(battery);
        Objects.requireNonNull(network);
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(report);
        return new LfBatteryImpl(battery, network, parameters, report);
    }

    private Battery getBattery() {
        return this.batteryRef.get();
    }

    @Override
    public String getId() {
        return this.getBattery().getId();
    }

    @Override
    public double getTargetQ() {
        return this.getBattery().getTargetQ() / 100.0;
    }

    @Override
    public double getMinP() {
        return this.getBattery().getMinP() / 100.0;
    }

    @Override
    public double getMaxP() {
        return this.getBattery().getMaxP() / 100.0;
    }

    @Override
    public double getMinTargetP() {
        return this.minTargetP / 100.0;
    }

    @Override
    public double getMaxTargetP() {
        return this.maxTargetP / 100.0;
    }

    @Override
    protected Optional<ReactiveLimits> getReactiveLimits() {
        return Optional.of(this.getBattery().getReactiveLimits());
    }

    @Override
    public boolean isParticipating() {
        return this.participating;
    }

    @Override
    public void setParticipating(boolean participating) {
        this.participating = participating;
    }

    @Override
    public double getDroop() {
        return this.droop;
    }

    @Override
    public double getParticipationFactor() {
        return this.participationFactor;
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        Battery battery = this.getBattery();
        battery.getTerminal().setP(-this.targetP * 100.0).setQ(Double.isNaN(this.calculatedQ) ? -this.getTargetQ() * 100.0 : -this.calculatedQ * 100.0);
    }
}

