/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.impl.AbstractLfBus;
import com.powsybl.openloadflow.network.impl.LfDanglingLineGenerator;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.Ref;
import java.util.List;

public class LfDanglingLineBus
extends AbstractLfBus {
    private final Ref<DanglingLine> danglingLineRef;
    private final double nominalV;

    public LfDanglingLineBus(LfNetwork network, DanglingLine danglingLine, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        super(network, Networks.getPropertyV(danglingLine), Math.toRadians(Networks.getPropertyAngle(danglingLine)), false);
        this.danglingLineRef = Ref.create(danglingLine, parameters.isCacheEnabled());
        this.nominalV = danglingLine.getTerminal().getVoltageLevel().getNominalV();
        this.getOrCreateLfLoad(null, parameters).add(danglingLine);
        DanglingLine.Generation generation = danglingLine.getGeneration();
        if (generation != null) {
            this.add(LfDanglingLineGenerator.create(danglingLine, network, this.getId(), parameters, report));
        }
    }

    private DanglingLine getDanglingLine() {
        return this.danglingLineRef.get();
    }

    public static String getId(DanglingLine danglingLine) {
        return danglingLine.getId() + "_BUS";
    }

    @Override
    public List<String> getOriginalIds() {
        return List.of(this.getDanglingLine().getId());
    }

    @Override
    public String getId() {
        return LfDanglingLineBus.getId(this.getDanglingLine());
    }

    @Override
    public String getVoltageLevelId() {
        return this.getDanglingLine().getTerminal().getVoltageLevel().getId();
    }

    @Override
    public boolean isFictitious() {
        return true;
    }

    @Override
    public double getNominalV() {
        return this.nominalV;
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        DanglingLine danglingLine = this.getDanglingLine();
        Networks.setPropertyV(danglingLine, this.v);
        Networks.setPropertyAngle(danglingLine, Math.toDegrees(this.angle));
        super.updateState(parameters);
    }
}

