/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.impl.AbstractLfGenerator;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.Ref;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public final class LfDanglingLineGenerator
extends AbstractLfGenerator {
    private final Ref<DanglingLine> danglingLineRef;

    private LfDanglingLineGenerator(DanglingLine danglingLine, LfNetwork network, String controlledLfBusId, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        super(network, danglingLine.getGeneration().getTargetP() / 100.0);
        this.danglingLineRef = Ref.create(danglingLine, parameters.isCacheEnabled());
        if (danglingLine.getGeneration().isVoltageRegulationOn() && this.checkVoltageControlConsistency(parameters, report) && LfDanglingLineGenerator.checkTargetV(this.getId(), danglingLine.getGeneration().getTargetV() / danglingLine.getTerminal().getVoltageLevel().getNominalV(), danglingLine.getTerminal().getVoltageLevel().getNominalV(), parameters, report)) {
            this.controlledBusId = Objects.requireNonNull(controlledLfBusId);
            this.targetV = danglingLine.getGeneration().getTargetV() / danglingLine.getTerminal().getVoltageLevel().getNominalV();
            this.generatorControlType = LfGenerator.GeneratorControlType.VOLTAGE;
        }
    }

    public static LfDanglingLineGenerator create(DanglingLine danglingLine, LfNetwork network, String controlledLfBusId, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        Objects.requireNonNull(danglingLine);
        Objects.requireNonNull(network);
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(report);
        return new LfDanglingLineGenerator(danglingLine, network, controlledLfBusId, parameters, report);
    }

    private DanglingLine getDanglingLine() {
        return this.danglingLineRef.get();
    }

    @Override
    public String getId() {
        return this.getDanglingLine().getId() + "_GEN";
    }

    @Override
    public String getOriginalId() {
        return this.getDanglingLine().getId();
    }

    @Override
    public OptionalDouble getRemoteControlReactiveKey() {
        return OptionalDouble.empty();
    }

    @Override
    public double getTargetQ() {
        return Networks.zeroIfNan(this.getDanglingLine().getGeneration().getTargetQ()) / 100.0;
    }

    @Override
    public double getMinP() {
        return this.getDanglingLine().getGeneration().getMinP() / 100.0;
    }

    @Override
    public double getMaxP() {
        return this.getDanglingLine().getGeneration().getMaxP() / 100.0;
    }

    @Override
    protected Optional<ReactiveLimits> getReactiveLimits() {
        return Optional.ofNullable(this.getDanglingLine().getGeneration().getReactiveLimits());
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
    }
}

