/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.CoordinatedReactiveControl;
import com.powsybl.iidm.network.extensions.GeneratorFortescue;
import com.powsybl.iidm.network.extensions.ReferencePriority;
import com.powsybl.iidm.network.extensions.ReferenceTerminals;
import com.powsybl.iidm.network.extensions.RemoteReactivePowerControl;
import com.powsybl.openloadflow.OpenLoadFlowParameters;
import com.powsybl.openloadflow.network.LfAsymGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.impl.AbstractLfGenerator;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.Ref;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LfGeneratorImpl
extends AbstractLfGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfGeneratorImpl.class);
    private final Ref<Generator> generatorRef;
    private boolean participating;
    private final double droop;
    private final double participationFactor;
    private Double qPercent;
    private final boolean forceVoltageControl;
    private final double maxTargetP;
    private final double minTargetP;

    private LfGeneratorImpl(Generator generator, LfNetwork network, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        super(network, generator.getTargetP() / 100.0);
        CoordinatedReactiveControl coordinatedReactiveControl;
        RemoteReactivePowerControl reactivePowerControl;
        this.generatorRef = Ref.create(generator, parameters.isCacheEnabled());
        this.forceVoltageControl = generator.isCondenser() || generator.isFictitious() && parameters.getFictitiousGeneratorVoltageControlCheckMode() == OpenLoadFlowParameters.FictitiousGeneratorVoltageControlCheckMode.FORCED;
        AbstractLfGenerator.ActivePowerControlHelper apcHelper = AbstractLfGenerator.ActivePowerControlHelper.create(generator, generator.getMinP(), generator.getMaxP());
        this.participating = apcHelper.participating();
        this.participationFactor = apcHelper.participationFactor();
        this.droop = apcHelper.droop();
        this.minTargetP = apcHelper.minTargetP();
        this.maxTargetP = apcHelper.maxTargetP();
        this.setReferencePriority(ReferencePriority.get((Injection)generator));
        if (!LfGeneratorImpl.checkActivePowerControl(generator.getId(), generator.getTargetP(), generator.getMaxP(), this.minTargetP, this.maxTargetP, parameters.getPlausibleActivePowerLimit(), parameters.isUseActiveLimits(), report)) {
            this.participating = false;
        }
        if (generator.isVoltageRegulatorOn()) {
            this.setVoltageControl(generator.getTargetV(), generator.getTerminal(), generator.getRegulatingTerminal(), parameters, report);
        }
        if ((reactivePowerControl = (RemoteReactivePowerControl)generator.getExtension(RemoteReactivePowerControl.class)) != null && reactivePowerControl.isEnabled() && !generator.isVoltageRegulatorOn() && parameters.isGeneratorReactivePowerRemoteControl()) {
            this.setRemoteReactivePowerControl(reactivePowerControl.getRegulatingTerminal(), reactivePowerControl.getTargetQ());
        }
        if ((coordinatedReactiveControl = (CoordinatedReactiveControl)this.getGenerator().getExtension(CoordinatedReactiveControl.class)) != null) {
            if (coordinatedReactiveControl.getQPercent() == 0.0) {
                LOGGER.trace("Generator '{}' remote voltage control reactive power key value is zero", (Object)generator.getId());
                ++report.generatorsWithZeroRemoteVoltageControlReactivePowerKey;
            } else {
                this.qPercent = coordinatedReactiveControl.getQPercent();
            }
        }
    }

    private static void createAsym(Generator generator, LfGeneratorImpl lfGenerator) {
        GeneratorFortescue extension = (GeneratorFortescue)generator.getExtension(GeneratorFortescue.class);
        if (extension != null) {
            double vNom = generator.getTerminal().getVoltageLevel().getNominalV();
            double zb = vNom * vNom / 100.0;
            double r0 = extension.getRz() / zb;
            double x0 = extension.getXz() / zb;
            double r2 = extension.getRn() / zb;
            double x2 = extension.getXn() / zb;
            double z0Square = r0 * r0 + x0 * x0;
            double z2Square = r2 * r2 + x2 * x2;
            double epsilon = 1.0E-10;
            if (!(z0Square > epsilon)) {
                throw new PowsyblException("Generator '" + generator.getId() + "' has fortescue zero sequence values that will bring singularity in the equation system");
            }
            double bZero = -x0 / z0Square;
            double gZero = r0 / z0Square;
            if (!(z2Square > epsilon)) {
                throw new PowsyblException("Generator '" + generator.getId() + "' has fortescue negative sequence values that will bring singularity in the equation system");
            }
            double bNegative = -x2 / z2Square;
            double gNegative = r2 / z2Square;
            lfGenerator.setAsym(new LfAsymGenerator(gZero, bZero, gNegative, bNegative));
        }
    }

    public static LfGeneratorImpl create(Generator generator, LfNetwork network, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        Objects.requireNonNull(generator);
        Objects.requireNonNull(network);
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(report);
        LfGeneratorImpl lfGenerator = new LfGeneratorImpl(generator, network, parameters, report);
        if (parameters.isAsymmetrical()) {
            LfGeneratorImpl.createAsym(generator, lfGenerator);
        }
        return lfGenerator;
    }

    private Generator getGenerator() {
        return this.generatorRef.get();
    }

    @Override
    public String getId() {
        return this.getGenerator().getId();
    }

    @Override
    public boolean isFictitious() {
        return this.getGenerator().isFictitious();
    }

    @Override
    public OptionalDouble getRemoteControlReactiveKey() {
        return this.qPercent != null ? OptionalDouble.of(this.qPercent) : OptionalDouble.empty();
    }

    @Override
    public double getTargetQ() {
        return Networks.zeroIfNan(this.getGenerator().getTargetQ()) / 100.0;
    }

    @Override
    public double getMinP() {
        return this.getGenerator().getMinP() / 100.0;
    }

    @Override
    public double getMaxP() {
        return this.getGenerator().getMaxP() / 100.0;
    }

    @Override
    public double getMinTargetP() {
        return this.minTargetP / 100.0;
    }

    @Override
    public double getMaxTargetP() {
        return this.maxTargetP / 100.0;
    }

    @Override
    protected Optional<ReactiveLimits> getReactiveLimits() {
        return Optional.of(this.getGenerator().getReactiveLimits());
    }

    @Override
    public boolean isParticipating() {
        return this.participating;
    }

    @Override
    public void setParticipating(boolean participating) {
        this.participating = participating;
    }

    @Override
    public double getDroop() {
        return this.droop;
    }

    @Override
    public double getParticipationFactor() {
        return this.participationFactor;
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        Generator generator = this.getGenerator();
        generator.getTerminal().setP(-this.targetP * 100.0).setQ(Double.isNaN(this.calculatedQ) ? -this.getTargetQ() * 100.0 : -this.calculatedQ * 100.0);
        if (parameters.isWriteReferenceTerminals() && this.isReference()) {
            ReferenceTerminals.addTerminal((Terminal)generator.getTerminal());
        }
    }

    @Override
    protected boolean checkIfGeneratorStartedForVoltageControl(LfNetworkLoadingReport report) {
        return this.forceVoltageControl || super.checkIfGeneratorStartedForVoltageControl(report);
    }

    @Override
    protected boolean checkIfGeneratorIsInsideActivePowerLimitsForVoltageControl(LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        return this.forceVoltageControl || super.checkIfGeneratorIsInsideActivePowerLimitsForVoltageControl(parameters, report);
    }
}

