/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfNetworkUpdateReport;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.PiModelArray;
import com.powsybl.openloadflow.network.impl.AbstractImpedantLfBranch;
import com.powsybl.openloadflow.network.impl.OlfThreeWindingsTransformerResult;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.openloadflow.network.impl.Transformers;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.security.results.BranchResult;
import com.powsybl.security.results.ThreeWindingsTransformerResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class LfLegBranch
extends AbstractImpedantLfBranch {
    private final Ref<ThreeWindingsTransformer> twtRef;
    private final Ref<ThreeWindingsTransformer.Leg> legRef;

    private LfLegBranch(LfNetwork network, LfBus bus1, LfBus bus0, PiModel piModel, ThreeWindingsTransformer twt, ThreeWindingsTransformer.Leg leg, LfNetworkParameters parameters) {
        super(network, bus1, bus0, piModel, parameters);
        this.twtRef = Ref.create(twt, parameters.isCacheEnabled());
        this.legRef = Ref.create(leg, parameters.isCacheEnabled());
    }

    private ThreeWindingsTransformer getTwt() {
        return this.twtRef.get();
    }

    private ThreeWindingsTransformer.Leg getLeg() {
        return this.legRef.get();
    }

    public static LfLegBranch create(LfNetwork network, LfBus bus1, LfBus bus0, ThreeWindingsTransformer twt, ThreeWindingsTransformer.Leg leg, LfTopoConfig topoConfig, LfNetworkParameters parameters) {
        RatioTapChanger rtc;
        Objects.requireNonNull(bus0);
        Objects.requireNonNull(twt);
        Objects.requireNonNull(leg);
        Objects.requireNonNull(parameters);
        String id = LfLegBranch.getId(leg.getSide(), twt.getId());
        boolean retainPtc = topoConfig.isRetainedPtc(id);
        boolean retainRtc = topoConfig.isRetainedRtc(id);
        PiModel piModel = null;
        double zb = PerUnit.zb(twt.getRatedU0());
        double baseRatio = Transformers.getRatioPerUnitBase(leg, twt);
        PhaseTapChanger ptc = leg.getPhaseTapChanger();
        if (ptc != null && (ptc.isRegulating() && ptc.getRegulationMode() != PhaseTapChanger.RegulationMode.FIXED_TAP || retainPtc)) {
            Integer rtcPosition = Transformers.getCurrentPosition(leg.getRatioTapChanger());
            ArrayList<PiModel> models = new ArrayList<PiModel>();
            for (int ptcPosition = ptc.getLowTapPosition(); ptcPosition <= ptc.getHighTapPosition(); ++ptcPosition) {
                Transformers.TapCharacteristics tapCharacteristics = Transformers.getTapCharacteristics(twt, leg, rtcPosition, ptcPosition);
                models.add(Transformers.createPiModel(tapCharacteristics, zb, baseRatio, parameters.isTwtSplitShuntAdmittance()));
            }
            piModel = new PiModelArray(models, ptc.getLowTapPosition(), ptc.getTapPosition());
        }
        if ((rtc = leg.getRatioTapChanger()) != null && (rtc.isRegulating() && rtc.hasLoadTapChangingCapabilities() || retainRtc)) {
            if (piModel == null) {
                Integer ptcPosition = Transformers.getCurrentPosition(leg.getPhaseTapChanger());
                ArrayList<PiModel> models = new ArrayList<PiModel>();
                for (int rtcPosition = rtc.getLowTapPosition(); rtcPosition <= rtc.getHighTapPosition(); ++rtcPosition) {
                    Transformers.TapCharacteristics tapCharacteristics = Transformers.getTapCharacteristics(twt, leg, rtcPosition, ptcPosition);
                    models.add(Transformers.createPiModel(tapCharacteristics, zb, baseRatio, parameters.isTwtSplitShuntAdmittance()));
                }
                piModel = new PiModelArray(models, rtc.getLowTapPosition(), rtc.getTapPosition());
            } else {
                throw new PowsyblException("Unsupported type of branch for voltage and phase controls of branch: " + twt.getId());
            }
        }
        if (piModel == null) {
            Transformers.TapCharacteristics tapCharacteristics = Transformers.getTapCharacteristics(twt, leg);
            piModel = Transformers.createPiModel(tapCharacteristics, zb, baseRatio, parameters.isTwtSplitShuntAdmittance());
        }
        LfLegBranch lfBranch = new LfLegBranch(network, bus1, bus0, piModel, twt, leg, parameters);
        if (bus1 != null && topoConfig.getBranchIdsOpenableSide1().contains(lfBranch.getId())) {
            lfBranch.setDisconnectionAllowedSide1(true);
        }
        return lfBranch;
    }

    public static String getId(String twtId, int legNum) {
        return twtId + "_leg_" + legNum;
    }

    public static String getId(ThreeSides side, String transformerId) {
        return LfLegBranch.getId(transformerId, side.getNum());
    }

    @Override
    public String getId() {
        return LfLegBranch.getId(this.getTwt().getId(), this.getLeg().getSide().getNum());
    }

    @Override
    public LfBranch.BranchType getBranchType() {
        ThreeWindingsTransformer.Leg leg = this.getLeg();
        return switch (leg.getSide()) {
            default -> throw new IncompatibleClassChangeError();
            case ThreeSides.ONE -> LfBranch.BranchType.TRANSFO_3_LEG_1;
            case ThreeSides.TWO -> LfBranch.BranchType.TRANSFO_3_LEG_2;
            case ThreeSides.THREE -> LfBranch.BranchType.TRANSFO_3_LEG_3;
        };
    }

    @Override
    public List<String> getOriginalIds() {
        return List.of(this.getTwt().getId());
    }

    @Override
    public boolean hasPhaseControllerCapability() {
        return this.getLeg().getPhaseTapChanger() != null;
    }

    @Override
    public List<BranchResult> createBranchResult(double preContingencyBranchP1, double preContingencyBranchOfContingencyP1, boolean createExtension) {
        throw new PowsyblException("Unsupported type of branch for branch result: " + this.getId());
    }

    @Override
    public List<LfBranch.LfLimit> getLimits1(LimitType type, LimitReductionManager limitReductionManager) {
        ThreeWindingsTransformer.Leg leg = this.getLeg();
        switch (type) {
            case ACTIVE_POWER: {
                return this.getLimits1(type, leg.getActivePowerLimits().orElse(null), limitReductionManager);
            }
            case APPARENT_POWER: {
                return this.getLimits1(type, leg.getApparentPowerLimits().orElse(null), limitReductionManager);
            }
            case CURRENT: {
                return this.getLimits1(type, leg.getCurrentLimits().orElse(null), limitReductionManager);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    @Override
    public double[] getLimitReductions(TwoSides side, LimitReductionManager limitReductionManager, LoadingLimits limits) {
        return new double[0];
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters, LfNetworkUpdateReport updateReport) {
        ThreeWindingsTransformer twt = this.getTwt();
        ThreeWindingsTransformer.Leg leg = this.getLeg();
        this.updateFlows(this.p1.eval(), this.q1.eval(), Double.NaN, Double.NaN);
        if (parameters.isPhaseShifterRegulationOn() && this.isPhaseController()) {
            this.updateTapPosition(leg.getPhaseTapChanger());
        }
        if (parameters.isTransformerVoltageControlOn() && this.isVoltageController() || parameters.isTransformerReactivePowerControlOn() && this.isTransformerReactivePowerController()) {
            RatioTapChanger rtc = leg.getRatioTapChanger();
            double baseRatio = Transformers.getRatioPerUnitBase(leg, twt);
            double rho = this.getPiModel().getR1() * leg.getRatedU() / twt.getRatedU0() * baseRatio;
            double ptcRho = leg.getPhaseTapChanger() != null ? ((PhaseTapChangerStep)leg.getPhaseTapChanger().getCurrentStep()).getRho() : 1.0;
            this.updateTapPosition(rtc, ptcRho, rho);
        }
    }

    @Override
    public void updateFlows(double p1, double q1, double p2, double q2) {
        this.getLeg().getTerminal().setP(p1 * 100.0).setQ(q1 * 100.0);
    }

    public static ThreeWindingsTransformerResult createThreeWindingsTransformerResult(LfNetwork network, String threeWindingsTransformerId, boolean createResultExtension) {
        LfLegBranch leg1 = (LfLegBranch)network.getBranchById(LfLegBranch.getId(threeWindingsTransformerId, 1));
        LfLegBranch leg2 = (LfLegBranch)network.getBranchById(LfLegBranch.getId(threeWindingsTransformerId, 2));
        LfLegBranch leg3 = (LfLegBranch)network.getBranchById(LfLegBranch.getId(threeWindingsTransformerId, 3));
        double i1Base = PerUnit.ib(leg1.legRef.get().getTerminal().getVoltageLevel().getNominalV());
        double i2Base = PerUnit.ib(leg2.legRef.get().getTerminal().getVoltageLevel().getNominalV());
        double i3Base = PerUnit.ib(leg3.legRef.get().getTerminal().getVoltageLevel().getNominalV());
        ThreeWindingsTransformerResult result = new ThreeWindingsTransformerResult(threeWindingsTransformerId, leg1.getP1().eval() * 100.0, leg1.getQ1().eval() * 100.0, leg1.getI1().eval() * i1Base, leg2.getP1().eval() * 100.0, leg2.getQ1().eval() * 100.0, leg2.getI1().eval() * i2Base, leg3.getP1().eval() * 100.0, leg3.getQ1().eval() * 100.0, leg3.getI1().eval() * i3Base);
        if (createResultExtension) {
            result.addExtension(OlfThreeWindingsTransformerResult.class, (Extension)new OlfThreeWindingsTransformerResult(leg1.getV1() * leg1.legRef.get().getTerminal().getVoltageLevel().getNominalV(), leg2.getV1() * leg2.legRef.get().getTerminal().getVoltageLevel().getNominalV(), leg3.getV1() * leg3.legRef.get().getTerminal().getVoltageLevel().getNominalV(), Math.toDegrees(leg1.getAngle1()), Math.toDegrees(leg2.getAngle1()), Math.toDegrees(leg3.getAngle1())));
        }
        return result;
    }
}

