/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.extensions.LoadDetail;
import com.powsybl.iidm.network.util.HvdcUtils;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfLoadModel;
import com.powsybl.openloadflow.network.LfNetworkListener;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.impl.AbstractLfInjection;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.openloadflow.util.Evaluable;
import com.powsybl.openloadflow.util.EvaluableConstants;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class LfLoadImpl
extends AbstractLfInjection
implements LfLoad {
    private final LfBus bus;
    private final LfLoadModel loadModel;
    private final List<Ref<Load>> loadsRefs = new ArrayList<Ref<Load>>();
    private final List<Ref<LccConverterStation>> lccCsRefs = new ArrayList<Ref<LccConverterStation>>();
    private double targetQ = 0.0;
    private boolean ensurePowerFactorConstantByLoad = false;
    private final List<Double> loadsAbsVariableTargetP = new ArrayList<Double>();
    private double absVariableTargetP = 0.0;
    private final boolean distributedOnConformLoad;
    private Map<String, Boolean> loadsDisablingStatus = new LinkedHashMap<String, Boolean>();
    private Evaluable p = EvaluableConstants.NAN;
    private Evaluable q = EvaluableConstants.NAN;

    LfLoadImpl(LfBus bus, boolean distributedOnConformLoad, LfLoadModel loadModel) {
        super(0.0, 0.0);
        this.bus = Objects.requireNonNull(bus);
        this.distributedOnConformLoad = distributedOnConformLoad;
        this.loadModel = loadModel;
    }

    @Override
    public String getId() {
        return this.bus.getId() + "_load";
    }

    @Override
    public List<String> getOriginalIds() {
        return Stream.concat(this.loadsRefs.stream().map(r -> ((Load)r.get()).getId()), this.lccCsRefs.stream().map(r -> ((LccConverterStation)r.get()).getId())).toList();
    }

    @Override
    public LfBus getBus() {
        return this.bus;
    }

    @Override
    public Optional<LfLoadModel> getLoadModel() {
        return Optional.ofNullable(this.loadModel);
    }

    void add(Load load, LfNetworkParameters parameters) {
        boolean reactiveOnlyLoad;
        LoadDetail loadDetail;
        this.loadsRefs.add(Ref.create(load, parameters.isCacheEnabled()));
        this.loadsDisablingStatus.put(load.getId(), false);
        double p0 = load.getP0();
        double q0 = load.getQ0();
        this.targetP += p0 / 100.0;
        this.initialTargetP += p0 / 100.0;
        this.targetQ += q0 / 100.0;
        boolean hasVariableActivePower = false;
        if (parameters.isDistributedOnConformLoad() && (loadDetail = (LoadDetail)load.getExtension(LoadDetail.class)) != null) {
            hasVariableActivePower = loadDetail.getFixedActivePower() != load.getP0();
        }
        boolean bl = reactiveOnlyLoad = p0 == 0.0 && q0 != 0.0;
        if (p0 < 0.0 || hasVariableActivePower || reactiveOnlyLoad) {
            this.ensurePowerFactorConstantByLoad = true;
        }
        double absTargetP = this.getAbsVariableTargetP(load);
        this.loadsAbsVariableTargetP.add(absTargetP);
        this.absVariableTargetP += absTargetP;
    }

    void add(LccConverterStation lccCs, LfNetworkParameters parameters) {
        this.lccCsRefs.add(Ref.create(lccCs, parameters.isCacheEnabled()));
        double lccTargetP = HvdcUtils.getConverterStationTargetP((HvdcConverterStation)lccCs);
        this.targetP += lccTargetP / 100.0;
        this.initialTargetP += lccTargetP / 100.0;
        this.targetQ += HvdcUtils.getLccConverterStationLoadTargetQ((LccConverterStation)lccCs) / 100.0;
    }

    public void add(DanglingLine danglingLine) {
        this.targetP += danglingLine.getP0() / 100.0;
        this.targetQ += danglingLine.getQ0() / 100.0;
    }

    @Override
    public void setTargetP(double targetP) {
        if (targetP != this.targetP) {
            double oldTargetP = this.targetP;
            this.targetP = targetP;
            for (LfNetworkListener listener : this.bus.getNetwork().getListeners()) {
                listener.onLoadActivePowerTargetChange(this, oldTargetP, targetP);
            }
        }
    }

    @Override
    public double getTargetQ() {
        return this.targetQ;
    }

    @Override
    public void setTargetQ(double targetQ) {
        if (targetQ != this.targetQ) {
            double oldTargetQ = this.targetQ;
            this.targetQ = targetQ;
            for (LfNetworkListener listener : this.bus.getNetwork().getListeners()) {
                listener.onLoadReactivePowerTargetChange(this, oldTargetQ, targetQ);
            }
        }
    }

    @Override
    public boolean ensurePowerFactorConstantByLoad() {
        return this.ensurePowerFactorConstantByLoad;
    }

    @Override
    public double getAbsVariableTargetP() {
        return this.absVariableTargetP;
    }

    @Override
    public void setAbsVariableTargetP(double absVariableTargetP) {
        this.absVariableTargetP = absVariableTargetP;
    }

    private double getAbsVariableTargetP(Load load) {
        double varP = this.distributedOnConformLoad ? (load.getExtension(LoadDetail.class) == null ? 0.0 : ((LoadDetail)load.getExtension(LoadDetail.class)).getVariableActivePower()) : load.getP0();
        return Math.abs(varP) / 100.0;
    }

    @Override
    public double getOriginalLoadCount() {
        return this.loadsRefs.size();
    }

    private double getParticipationFactor(int i) {
        return this.absVariableTargetP != 0.0 ? this.loadsAbsVariableTargetP.get(i) / this.absVariableTargetP : 0.0;
    }

    private double calculateP() {
        return this.p.eval() + this.getLoadModel().flatMap(lm -> lm.getExpTermP(0.0).map(term -> this.targetP * term.c())).orElse(0.0);
    }

    private double calculateQ() {
        return this.q.eval() + this.getLoadModel().flatMap(lm -> lm.getExpTermQ(0.0).map(term -> this.targetQ * term.c())).orElse(0.0);
    }

    @Override
    public void updateState(boolean loadPowerFactorConstant, boolean breakers) {
        double pv = this.p == EvaluableConstants.NAN ? 1.0 : this.calculateP() / this.targetP;
        double qv = this.q == EvaluableConstants.NAN ? 1.0 : this.calculateQ() / this.targetQ;
        double diffLoadTargetP = this.targetP - this.initialTargetP;
        for (int i = 0; i < this.loadsRefs.size(); ++i) {
            Load load = this.loadsRefs.get(i).get();
            double diffP0 = diffLoadTargetP * this.getParticipationFactor(i) * 100.0;
            double updatedP0 = load.getP0() + diffP0;
            double updatedQ0 = load.getQ0() + (loadPowerFactorConstant ? LfLoadImpl.getPowerFactor(load) * diffP0 : 0.0);
            load.getTerminal().setP(updatedP0 * pv).setQ(updatedQ0 * qv);
        }
        for (Ref<LccConverterStation> lccCsRef : this.lccCsRefs) {
            LccConverterStation lccCs = lccCsRef.get();
            double pCs = HvdcUtils.getConverterStationTargetP((HvdcConverterStation)lccCs);
            double qCs = HvdcUtils.getLccConverterStationLoadTargetQ((LccConverterStation)lccCs);
            lccCs.getTerminal().setP(pCs).setQ(qCs);
        }
    }

    @Override
    public double calculateNewTargetQ(double diffTargetP) {
        double newLoadTargetQ = 0.0;
        for (int i = 0; i < this.loadsRefs.size(); ++i) {
            Load load = this.loadsRefs.get(i).get();
            double updatedQ0 = load.getQ0() / 100.0 + LfLoadImpl.getPowerFactor(load) * diffTargetP * this.getParticipationFactor(i);
            newLoadTargetQ += updatedQ0;
        }
        return newLoadTargetQ;
    }

    @Override
    public boolean isOriginalLoadDisabled(String originalId) {
        return this.loadsDisablingStatus.get(originalId);
    }

    @Override
    public void setOriginalLoadDisabled(String originalId, boolean disabled) {
        this.loadsDisablingStatus.put(originalId, disabled);
    }

    @Override
    public Map<String, Boolean> getOriginalLoadsDisablingStatus() {
        return this.loadsDisablingStatus;
    }

    @Override
    public void setOriginalLoadsDisablingStatus(Map<String, Boolean> originalLoadsDisablingStatus) {
        this.loadsDisablingStatus = Objects.requireNonNull(originalLoadsDisablingStatus);
    }

    private static double getPowerFactor(Load load) {
        return load.getP0() != 0.0 ? load.getQ0() / load.getP0() : 1.0;
    }

    @Override
    public Evaluable getP() {
        return this.p;
    }

    @Override
    public void setP(Evaluable p) {
        this.p = p;
    }

    @Override
    public Evaluable getQ() {
        return this.q;
    }

    @Override
    public void setQ(Evaluable q) {
        this.q = q;
    }

    public String toString() {
        return this.getId();
    }
}

