/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.Network;
import com.powsybl.openloadflow.network.LfNetwork;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class LfNetworkList
implements AutoCloseable {
    private final List<LfNetwork> list;
    private final VariantCleaner variantCleaner;

    public LfNetworkList(List<LfNetwork> list, VariantCleaner variantCleaner) {
        this.list = Objects.requireNonNull(list);
        this.variantCleaner = variantCleaner;
    }

    public LfNetworkList(List<LfNetwork> list) {
        this(list, null);
    }

    public List<LfNetwork> getList() {
        return this.list;
    }

    public Optional<LfNetwork> getLargest() {
        return this.list.isEmpty() ? Optional.empty() : Optional.of(this.list.get(0));
    }

    @Override
    public void close() {
        if (this.variantCleaner != null) {
            this.variantCleaner.clean();
        }
    }

    public VariantCleaner getVariantCleaner() {
        return this.variantCleaner;
    }

    public static interface VariantCleaner {
        public String getTmpVariantId();

        public void clean();
    }

    @FunctionalInterface
    public static interface VariantCleanerFactory {
        public VariantCleaner create(Network var1, String var2, String var3);
    }

    public static class WorkingVariantReverter
    extends AbstractVariantCleaner {
        public WorkingVariantReverter(Network network, String workingVariantId, String tmpVariantId) {
            super(network, workingVariantId, tmpVariantId);
        }

        @Override
        public void clean() {
            this.network.getVariantManager().setWorkingVariant(this.workingVariantId);
        }
    }

    public static class DefaultVariantCleaner
    extends AbstractVariantCleaner {
        public DefaultVariantCleaner(Network network, String workingVariantId, String tmpVariantId) {
            super(network, workingVariantId, tmpVariantId);
        }

        @Override
        public void clean() {
            this.network.getVariantManager().removeVariant(this.tmpVariantId);
            this.network.getVariantManager().setWorkingVariant(this.workingVariantId);
        }
    }

    public static abstract class AbstractVariantCleaner
    implements VariantCleaner {
        protected final Network network;
        protected final String workingVariantId;
        protected final String tmpVariantId;

        protected AbstractVariantCleaner(Network network, String workingVariantId, String tmpVariantId) {
            this.network = Objects.requireNonNull(network);
            this.workingVariantId = Objects.requireNonNull(workingVariantId);
            this.tmpVariantId = Objects.requireNonNull(tmpVariantId);
        }

        @Override
        public String getTmpVariantId() {
            return this.tmpVariantId;
        }
    }
}

