/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.google.common.base.Stopwatch;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DefaultTopologyVisitor;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.extensions.ControlUnit;
import com.powsybl.iidm.network.extensions.ControlZone;
import com.powsybl.iidm.network.extensions.PilotPoint;
import com.powsybl.iidm.network.extensions.SecondaryVoltageControl;
import com.powsybl.openloadflow.network.GeneratorReactivePowerControl;
import com.powsybl.openloadflow.network.GeneratorVoltageControl;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfElement;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkLoader;
import com.powsybl.openloadflow.network.LfNetworkLoaderPostProcessor;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfOverloadManagementSystem;
import com.powsybl.openloadflow.network.LfSecondaryVoltageControl;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.LoadFlowModel;
import com.powsybl.openloadflow.network.ShuntVoltageControl;
import com.powsybl.openloadflow.network.TransformerPhaseControl;
import com.powsybl.openloadflow.network.TransformerReactivePowerControl;
import com.powsybl.openloadflow.network.TransformerVoltageControl;
import com.powsybl.openloadflow.network.VoltageControl;
import com.powsybl.openloadflow.network.impl.HvdcConverterStations;
import com.powsybl.openloadflow.network.impl.LfBranchImpl;
import com.powsybl.openloadflow.network.impl.LfBusImpl;
import com.powsybl.openloadflow.network.impl.LfDanglingLineBranch;
import com.powsybl.openloadflow.network.impl.LfDanglingLineBus;
import com.powsybl.openloadflow.network.impl.LfHvdcImpl;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.LfStarBus;
import com.powsybl.openloadflow.network.impl.LfSwitch;
import com.powsybl.openloadflow.network.impl.LfTieLineBranch;
import com.powsybl.openloadflow.network.impl.LfVscConverterStationImpl;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.util.DebugUtil;
import com.powsybl.openloadflow.util.Markers;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.openloadflow.util.Reports;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jafama.FastMath;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LfNetworkLoaderImpl
implements LfNetworkLoader<Network> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfNetworkLoaderImpl.class);
    private static final double TARGET_V_EPSILON = 0.01;
    private static final double TARGET_Q_EPSILON = 0.01;
    private final Supplier<List<LfNetworkLoaderPostProcessor>> postProcessorsSupplier;

    public LfNetworkLoaderImpl() {
        this(LfNetworkLoaderPostProcessor::findAll);
    }

    public LfNetworkLoaderImpl(Supplier<List<LfNetworkLoaderPostProcessor>> postProcessorsSupplier) {
        this.postProcessorsSupplier = Objects.requireNonNull(postProcessorsSupplier);
    }

    private static void createBuses(List<Bus> buses, LfNetworkParameters parameters, LfNetwork lfNetwork, List<LfBus> lfBuses, LfTopoConfig topoConfig, LoadingContext loadingContext, LfNetworkLoadingReport report, List<LfNetworkLoaderPostProcessor> postProcessors) {
        for (Bus bus : buses) {
            LfBusImpl lfBus = LfNetworkLoaderImpl.createBus(bus, parameters, lfNetwork, topoConfig, loadingContext, report, postProcessors);
            postProcessors.forEach(pp -> pp.onBusAdded(bus, lfBus));
            lfNetwork.addBus(lfBus);
            lfBuses.add(lfBus);
        }
    }

    private static void createVoltageControls(List<LfBus> lfBuses, LfNetworkParameters parameters) {
        ArrayList voltageControls = new ArrayList();
        for (LfBus controllerBus : lfBuses) {
            String generatorIds;
            ArrayList<LfGenerator> voltageControlGenerators = new ArrayList<LfGenerator>(1);
            ArrayList<LfGenerator> voltageMonitoringGenerators = new ArrayList<LfGenerator>(1);
            for (LfGenerator generator : controllerBus.getGenerators()) {
                if (generator.getGeneratorControlType() == LfGenerator.GeneratorControlType.VOLTAGE) {
                    voltageControlGenerators.add(generator);
                    continue;
                }
                if (generator.getGeneratorControlType() != LfGenerator.GeneratorControlType.MONITORING_VOLTAGE) continue;
                voltageMonitoringGenerators.add(generator);
            }
            if (voltageMonitoringGenerators.size() > 1) {
                generatorIds = voltageMonitoringGenerators.stream().map(LfGenerator::getId).collect(Collectors.joining(", "));
                LOGGER.warn("We have several voltage monitors ({}) connected to the same bus: not supported. All switched to voltage control", (Object)generatorIds);
                voltageMonitoringGenerators.forEach(gen -> gen.setGeneratorControlType(LfGenerator.GeneratorControlType.VOLTAGE));
            }
            if (!voltageControlGenerators.isEmpty() && !voltageMonitoringGenerators.isEmpty()) {
                generatorIds = voltageMonitoringGenerators.stream().map(LfGenerator::getId).collect(Collectors.joining(", "));
                LOGGER.warn("We have both voltage controllers and voltage monitors ({}) connected to the same bus: voltage monitoring discarded", (Object)generatorIds);
                voltageMonitoringGenerators.forEach(gen -> gen.setGeneratorControlType(LfGenerator.GeneratorControlType.OFF));
                voltageMonitoringGenerators.clear();
            }
            voltageControlGenerators.addAll(voltageMonitoringGenerators);
            if (voltageControlGenerators.isEmpty()) continue;
            LfGenerator lfGenerator0 = (LfGenerator)voltageControlGenerators.get(0);
            LfBus controlledBus = lfGenerator0.getControlledBus();
            double controllerTargetV = lfGenerator0.getTargetV();
            voltageControlGenerators.stream().skip(1L).forEach(lfGenerator -> {
                LfBus generatorControlledBus = lfGenerator.getControlledBus();
                if (LfNetworkLoaderImpl.checkUniqueControlledBus(controlledBus, generatorControlledBus, controllerBus)) {
                    LfNetworkLoaderImpl.checkUniqueTargetVControllerBus(lfGenerator, controllerTargetV, controllerBus, generatorControlledBus);
                }
            });
            if (parameters.isGeneratorVoltageRemoteControl() || controlledBus == controllerBus) {
                controlledBus.getGeneratorVoltageControl().ifPresentOrElse(vc -> LfNetworkLoaderImpl.updateGeneratorVoltageControl(vc, controllerBus, controllerTargetV), () -> LfNetworkLoaderImpl.createGeneratorVoltageControl(controlledBus, controllerBus, controllerTargetV, voltageControls, parameters));
                continue;
            }
            LOGGER.warn("Remote voltage control is not activated. The voltage target of {} with remote control is rescaled from {} to {}", new Object[]{controllerBus.getId(), controllerTargetV, controllerTargetV * controllerBus.getNominalV() / controlledBus.getNominalV()});
            controlledBus.getGeneratorVoltageControl().ifPresentOrElse(vc -> LfNetworkLoaderImpl.updateGeneratorVoltageControl(vc, controllerBus, controllerTargetV), () -> LfNetworkLoaderImpl.createGeneratorVoltageControl(controllerBus, controllerBus, controllerTargetV, voltageControls, parameters));
        }
        if (parameters.isVoltagePerReactivePowerControl()) {
            voltageControls.forEach(LfNetworkLoaderImpl::checkGeneratorsWithSlope);
        }
    }

    private static void createGeneratorVoltageControl(LfBus controlledBus, LfBus controllerBus, double controllerTargetV, List<GeneratorVoltageControl> voltageControls, LfNetworkParameters parameters) {
        GeneratorVoltageControl voltageControl = new GeneratorVoltageControl(controlledBus, parameters.getVoltageTargetPriority(VoltageControl.Type.GENERATOR), controllerTargetV);
        voltageControl.addControllerElement(controllerBus);
        controlledBus.setGeneratorVoltageControl(voltageControl);
        if (parameters.isVoltagePerReactivePowerControl()) {
            voltageControls.add(voltageControl);
        }
        if (controllerBus.getGenerators().stream().anyMatch(gen -> gen.getGeneratorControlType() == LfGenerator.GeneratorControlType.MONITORING_VOLTAGE)) {
            controllerBus.setGeneratorVoltageControlEnabled(false);
        }
    }

    private static void updateGeneratorVoltageControl(GeneratorVoltageControl voltageControl, LfBus controllerBus, double controllerTargetV) {
        voltageControl.addControllerElement(controllerBus);
        LfNetworkLoaderImpl.checkUniqueTargetVControlledBus(controllerTargetV, controllerBus, voltageControl);
    }

    private static void checkGeneratorsWithSlope(GeneratorVoltageControl voltageControl) {
        List<LfGenerator> generatorsWithSlope = voltageControl.getControllerElements().stream().filter(LfBus::hasGeneratorsWithSlope).flatMap(lfBus -> lfBus.getGeneratorsControllingVoltageWithSlope().stream()).collect(Collectors.toList());
        if (!generatorsWithSlope.isEmpty()) {
            if (voltageControl.isSharedControl()) {
                generatorsWithSlope.forEach(generator -> generator.getBus().removeGeneratorSlopes());
                LOGGER.warn("Non supported: shared control on bus {} with {} generator(s) controlling voltage with slope. Slope set to 0 on all those generators", (Object)voltageControl.getControlledBus(), (Object)generatorsWithSlope.size());
            } else if (!voltageControl.isLocalControl()) {
                generatorsWithSlope.forEach(generator -> generator.getBus().removeGeneratorSlopes());
                LOGGER.warn("Non supported: remote control on bus {} with {} generator(s) controlling voltage with slope", (Object)voltageControl.getControlledBus(), (Object)generatorsWithSlope.size());
            }
        }
    }

    private static void checkUniqueTargetVControlledBus(double controllerTargetV, LfBus controllerBus, GeneratorVoltageControl vc) {
        LfBus controlledBus;
        double voltageControlTargetV = vc.getTargetValue();
        double deltaTargetV = FastMath.abs((double)(voltageControlTargetV - controllerTargetV));
        if (deltaTargetV * (controlledBus = vc.getControlledBus()).getNominalV() > 0.01) {
            String busesId = vc.getControllerElements().stream().map(LfElement::getId).collect(Collectors.joining(", "));
            LOGGER.error("Bus '{}' control voltage of bus '{}' which is already controlled by buses '{}' with a different target voltage: {} (kept) and {} (ignored)", new Object[]{controllerBus.getId(), controlledBus.getId(), busesId, controllerTargetV * controlledBus.getNominalV(), voltageControlTargetV * controlledBus.getNominalV()});
            Reports.reportBusAlreadyControlledWithDifferentTargetV(controllerBus.getNetwork().getReportNode(), controllerBus.getId(), controlledBus.getId(), busesId, controllerTargetV * controlledBus.getNominalV(), voltageControlTargetV * controlledBus.getNominalV());
        }
    }

    private static boolean checkUniqueControlledBus(LfBus controlledBus, LfBus controlledBusGen, LfBus controller) {
        Objects.requireNonNull(controlledBus);
        Objects.requireNonNull(controlledBusGen);
        if (controlledBus.getNum() != controlledBusGen.getNum()) {
            String generatorIds = controller.getGenerators().stream().map(LfGenerator::getId).collect(Collectors.joining(", "));
            LOGGER.warn("Generators [{}] are connected to the same bus '{}' but control the voltage of different buses: {} (kept) and {} (rejected)", new Object[]{generatorIds, controller.getId(), controlledBus.getId(), controlledBusGen.getId()});
            Reports.reportNotUniqueControlledBus(controlledBus.getNetwork().getReportNode(), generatorIds, controller.getId(), controlledBus.getId(), controlledBusGen.getId());
            return false;
        }
        return true;
    }

    private static void checkUniqueTargetVControllerBus(LfGenerator lfGenerator, double previousTargetV, LfBus controllerBus, LfBus controlledBus) {
        double targetV = lfGenerator.getTargetV();
        if (FastMath.abs((double)(previousTargetV - targetV)) > 0.01) {
            String generatorIds = controllerBus.getGenerators().stream().map(LfGenerator::getId).collect(Collectors.joining(", "));
            LOGGER.error("Generators [{}] are connected to the same bus '{}' with different target voltages: {} (kept) and {} (rejected)", new Object[]{generatorIds, controllerBus.getId(), previousTargetV * controlledBus.getNominalV(), targetV * controlledBus.getNominalV()});
            Reports.reportNotUniqueTargetVControllerBus(controllerBus.getNetwork().getReportNode(), generatorIds, controllerBus.getId(), previousTargetV * controlledBus.getNominalV(), targetV * controlledBus.getNominalV());
        }
    }

    private static void createGeneratorReactivePowerControls(List<LfBus> lfBuses) {
        for (LfBus controllerBus : lfBuses) {
            List<LfGenerator> generators = controllerBus.getGenerators().stream().filter(LfGenerator::hasRemoteReactivePowerControl).collect(Collectors.toList());
            if (generators.isEmpty()) continue;
            Optional<GeneratorVoltageControl> voltageControl = controllerBus.getGeneratorVoltageControl();
            if (voltageControl.isPresent()) {
                LOGGER.warn("Bus {} has both voltage and remote reactive power controls: only voltage control is kept", (Object)controllerBus.getId());
                continue;
            }
            LfGenerator generator = (LfGenerator)generators.get(0);
            if (!LfNetworkLoaderImpl.checkControllerBusGenerators(generators, controllerBus.getId())) continue;
            LfNetworkLoaderImpl.createGeneratorReactivePowerControl(generator.getControlledBranch(), generator.getControlledBranchSide(), generator.getRemoteTargetQ(), controllerBus);
        }
    }

    private static void createGeneratorReactivePowerControl(LfBranch controlledBranch, TwoSides side, double targetQ, LfBus controllerBus) {
        if (!controlledBranch.isConnectedAtBothSides()) {
            LOGGER.warn("Controlled branch '{}' must be connected at both sides: generator remote reactive power control discarded", (Object)controlledBranch.getId());
            return;
        }
        controlledBranch.getGeneratorReactivePowerControl().ifPresentOrElse(rpc -> {
            if (LfNetworkLoaderImpl.checkUniqueControlledSide(rpc, side)) {
                LfNetworkLoaderImpl.updateGeneratorReactivePowerControl(rpc, controllerBus, targetQ);
            }
        }, () -> LfNetworkLoaderImpl.createGeneratorReactivePowerControl(controlledBranch, controllerBus, side, targetQ));
    }

    private static void createGeneratorReactivePowerControl(LfBranch controlledBranch, LfBus controllerBus, TwoSides controlledSide, double controllerTargetQ) {
        GeneratorReactivePowerControl generatorReactivePowerControl = new GeneratorReactivePowerControl(controlledBranch, controlledSide, controllerTargetQ);
        generatorReactivePowerControl.addControllerBus(controllerBus);
        controlledBranch.setGeneratorReactivePowerControl(generatorReactivePowerControl);
    }

    private static void updateGeneratorReactivePowerControl(GeneratorReactivePowerControl generatorReactivePowerControl, LfBus controllerBus, double controllerTargetQ) {
        LfNetworkLoaderImpl.checkUniqueTargetQControlledBranch(controllerTargetQ, controllerBus, generatorReactivePowerControl);
        generatorReactivePowerControl.addControllerBus(controllerBus);
    }

    private static boolean checkControllerBusGenerators(List<LfGenerator> lfGenerators, String controllerBusId) {
        LfGenerator lfGenerator = lfGenerators.get(0);
        LfBranch controlledBranch = lfGenerator.getControlledBranch();
        if (controlledBranch == null) {
            LOGGER.warn("Controlled branch is out of voltage or in a different synchronous component: remote reactive power control of generator {} discarded", (Object)lfGenerator.getId());
            return false;
        }
        TwoSides side = lfGenerator.getControlledBranchSide();
        double targetQ = lfGenerator.getRemoteTargetQ();
        for (int i = 1; i < lfGenerators.size(); ++i) {
            LfGenerator otherGenerator = lfGenerators.get(i);
            if (otherGenerator.getControlledBranch() == null) {
                LOGGER.warn("Controlled branch is out of voltage or in a different synchronous component: remote reactive power control of generator {} discarded", (Object)otherGenerator.getId());
                return false;
            }
            if (controlledBranch.getId().equals(otherGenerator.getControlledBranch().getId()) && side.equals((Object)otherGenerator.getControlledBranchSide()) && Math.abs(targetQ - otherGenerator.getRemoteTargetQ()) < 0.01) continue;
            LOGGER.error("Controller Bus '{}' has multiple generators with remote reactive power control.But controls are not coherent between them: controls discarded", (Object)controllerBusId);
            return false;
        }
        return true;
    }

    private static boolean checkUniqueControlledSide(GeneratorReactivePowerControl generatorReactivePowerControl, TwoSides side) {
        if (!side.equals((Object)generatorReactivePowerControl.getControlledSide())) {
            LOGGER.error("Controlled branch '{}' is controlled at both sides. Controlled side {} (kept) {} (rejected).", new Object[]{generatorReactivePowerControl.getControlledBranch().getId(), generatorReactivePowerControl.getControlledSide(), side});
            Reports.reportBranchControlledAtBothSides(generatorReactivePowerControl.getControlledBranch().getNetwork().getReportNode(), generatorReactivePowerControl.getControlledBranch().getId(), generatorReactivePowerControl.getControlledSide().name(), side.name());
            return false;
        }
        return true;
    }

    private static void checkUniqueTargetQControlledBranch(double controllerTargetQ, LfBus controllerBus, GeneratorReactivePowerControl generatorReactivePowerControl) {
        double reactivePowerControlTargetQ = generatorReactivePowerControl.getTargetValue();
        double deltaTargetQ = FastMath.abs((double)(reactivePowerControlTargetQ - controllerTargetQ));
        if (deltaTargetQ > 0.01) {
            String busesId = generatorReactivePowerControl.getControllerBuses().stream().map(LfElement::getId).collect(Collectors.joining(", "));
            LOGGER.error("Bus '{}' controls reactive power of a branch which is already controlled by buses '{}' with a different targetQ: {} (kept) and {} (ignored)", new Object[]{controllerBus.getId(), busesId, reactivePowerControlTargetQ, controllerTargetQ});
        }
    }

    private static LfBusImpl createBus(Bus bus, final LfNetworkParameters parameters, LfNetwork lfNetwork, LfTopoConfig topoConfig, final LoadingContext loadingContext, final LfNetworkLoadingReport report, final List<LfNetworkLoaderPostProcessor> postProcessors) {
        final LfBusImpl lfBus = LfBusImpl.create(bus, lfNetwork, parameters, LfNetworkLoaderImpl.participateToSlackDistribution(parameters, bus));
        final ArrayList<ShuntCompensator> shuntCompensators = new ArrayList<ShuntCompensator>();
        bus.visitConnectedEquipments((TopologyVisitor)new DefaultTopologyVisitor(){

            private void visitBranch(Branch<?> branch) {
                loadingContext.branchSet.add(branch);
            }

            public void visitLine(Line line, TwoSides side) {
                this.visitBranch((Branch<?>)line);
            }

            public void visitTwoWindingsTransformer(TwoWindingsTransformer transformer, TwoSides side) {
                this.visitBranch((Branch<?>)transformer);
            }

            public void visitThreeWindingsTransformer(ThreeWindingsTransformer transformer, ThreeSides side) {
                loadingContext.t3wtSet.add(transformer);
            }

            public void visitGenerator(Generator generator) {
                lfBus.addGenerator(generator, parameters, report);
                postProcessors.forEach(pp -> pp.onInjectionAdded(generator, lfBus));
            }

            public void visitLoad(Load load) {
                lfBus.addLoad(load, parameters);
                postProcessors.forEach(pp -> pp.onInjectionAdded(load, lfBus));
            }

            public void visitShuntCompensator(ShuntCompensator sc) {
                shuntCompensators.add(sc);
                postProcessors.forEach(pp -> pp.onInjectionAdded(sc, lfBus));
                if (parameters.isShuntVoltageControl()) {
                    loadingContext.shuntSet.add(sc);
                }
            }

            public void visitDanglingLine(DanglingLine danglingLine) {
                loadingContext.danglingLines.add(danglingLine);
                postProcessors.forEach(pp -> pp.onInjectionAdded(danglingLine, lfBus));
            }

            public void visitStaticVarCompensator(StaticVarCompensator staticVarCompensator) {
                lfBus.addStaticVarCompensator(staticVarCompensator, parameters, report);
                postProcessors.forEach(pp -> pp.onInjectionAdded(staticVarCompensator, lfBus));
            }

            public void visitBattery(Battery battery) {
                lfBus.addBattery(battery, parameters, report);
                postProcessors.forEach(pp -> pp.onInjectionAdded(battery, lfBus));
            }

            public void visitHvdcConverterStation(HvdcConverterStation<?> converterStation) {
                switch (converterStation.getHvdcType()) {
                    case VSC: {
                        VscConverterStation vscConverterStation = (VscConverterStation)converterStation;
                        lfBus.addVscConverterStation(vscConverterStation, parameters, report);
                        if (converterStation.getHvdcLine() == null) break;
                        loadingContext.hvdcLineSet.add(converterStation.getHvdcLine());
                        break;
                    }
                    case LCC: {
                        lfBus.addLccConverterStation((LccConverterStation)converterStation, parameters);
                        if (converterStation.getHvdcLine() == null) break;
                        loadingContext.hvdcLineSet.add(converterStation.getHvdcLine());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown HVDC converter station type: " + converterStation.getHvdcType());
                    }
                }
                postProcessors.forEach(pp -> pp.onInjectionAdded(converterStation, lfBus));
            }
        });
        if (!shuntCompensators.isEmpty()) {
            lfBus.setShuntCompensators(shuntCompensators, parameters, topoConfig, report);
        }
        return lfBus;
    }

    private static void addBranch(LfNetwork lfNetwork, LfBranch lfBranch, LfNetworkLoadingReport report) {
        boolean connectedToSameBus;
        boolean bl = connectedToSameBus = lfBranch.getBus1() == lfBranch.getBus2();
        if (connectedToSameBus) {
            LOGGER.trace("Discard branch '{}' because connected to same bus at both ends", (Object)lfBranch.getId());
            ++report.branchesDiscardedBecauseConnectedToSameBusAtBothEnds;
        } else {
            if (Arrays.stream(LoadFlowModel.values()).anyMatch(lfBranch::isZeroImpedance)) {
                LOGGER.trace("Branch {} is non impedant", (Object)lfBranch.getId());
                ++report.nonImpedantBranches;
            }
            lfNetwork.addBranch(lfBranch);
        }
    }

    private static void createBranches(List<LfBus> lfBuses, LfNetwork lfNetwork, LfTopoConfig topoConfig, LoadingContext loadingContext, LfNetworkLoadingReport report, LfNetworkParameters parameters, List<LfNetworkLoaderPostProcessor> postProcessors) {
        ThreeSides[] lfBranch;
        for (Branch<?> branch : loadingContext.branchSet) {
            LfBus lfBus = LfNetworkLoaderImpl.getLfBus(branch.getTerminal1(), lfNetwork, parameters.isBreakers());
            LfBus lfBus2 = LfNetworkLoaderImpl.getLfBus(branch.getTerminal2(), lfNetwork, parameters.isBreakers());
            lfBranch = LfBranchImpl.create(branch, lfNetwork, lfBus, lfBus2, topoConfig, parameters);
            LfNetworkLoaderImpl.addBranch(lfNetwork, (LfBranch)lfBranch, report);
            postProcessors.forEach(arg_0 -> LfNetworkLoaderImpl.lambda$createBranches$14(branch, (LfBranchImpl)lfBranch, arg_0));
        }
        HashSet visitedDanglingLinesIds = new HashSet();
        for (DanglingLine danglingLine : loadingContext.danglingLines) {
            danglingLine.getTieLine().ifPresentOrElse(tieLine -> {
                if (!visitedDanglingLinesIds.contains(danglingLine.getId())) {
                    LfBus lfBus1 = LfNetworkLoaderImpl.getLfBus(tieLine.getDanglingLine1().getTerminal(), lfNetwork, parameters.isBreakers());
                    LfBus lfBus2 = LfNetworkLoaderImpl.getLfBus(tieLine.getDanglingLine2().getTerminal(), lfNetwork, parameters.isBreakers());
                    LfTieLineBranch lfBranch = LfTieLineBranch.create(tieLine, lfNetwork, lfBus1, lfBus2, parameters);
                    LfNetworkLoaderImpl.addBranch(lfNetwork, lfBranch, report);
                    postProcessors.forEach(pp -> pp.onBranchAdded(tieLine, lfBranch));
                    visitedDanglingLinesIds.add(tieLine.getDanglingLine1().getId());
                    visitedDanglingLinesIds.add(tieLine.getDanglingLine2().getId());
                }
            }, () -> {
                LfDanglingLineBus lfBus2 = new LfDanglingLineBus(lfNetwork, danglingLine, parameters, report);
                lfNetwork.addBus(lfBus2);
                lfBuses.add(lfBus2);
                LfBus lfBus1 = LfNetworkLoaderImpl.getLfBus(danglingLine.getTerminal(), lfNetwork, parameters.isBreakers());
                LfDanglingLineBranch lfBranch = LfDanglingLineBranch.create(danglingLine, lfNetwork, lfBus1, lfBus2, parameters);
                LfNetworkLoaderImpl.addBranch(lfNetwork, lfBranch, report);
                postProcessors.forEach(pp -> {
                    pp.onBusAdded(danglingLine, lfBus2);
                    pp.onBranchAdded(danglingLine, lfBranch);
                });
            });
        }
        for (ThreeWindingsTransformer threeWindingsTransformer : loadingContext.t3wtSet) {
            LfStarBus lfBus0 = new LfStarBus(lfNetwork, threeWindingsTransformer, parameters);
            lfNetwork.addBus(lfBus0);
            postProcessors.forEach(pp -> pp.onBusAdded(t3wt, lfBus0));
            lfBranch = ThreeSides.values();
            int n = lfBranch.length;
            for (int i = 0; i < n; ++i) {
                ThreeSides side = lfBranch[i];
                ThreeWindingsTransformer.Leg leg = threeWindingsTransformer.getLeg(side);
                LfBus lfBus = LfNetworkLoaderImpl.getLfBus(leg.getTerminal(), lfNetwork, parameters.isBreakers());
                LfLegBranch lfBranch2 = LfLegBranch.create(lfNetwork, lfBus, lfBus0, threeWindingsTransformer, leg, topoConfig, parameters);
                LfNetworkLoaderImpl.addBranch(lfNetwork, lfBranch2, report);
                postProcessors.forEach(pp -> pp.onBranchAdded(t3wt, lfBranch2));
            }
        }
        if (parameters.isPhaseControl()) {
            for (Branch branch : loadingContext.branchSet) {
                if (!(branch instanceof TwoWindingsTransformer)) continue;
                ThreeSides[] t2wt = (ThreeSides[])branch;
                PhaseTapChanger ptc = t2wt.getPhaseTapChanger();
                LfNetworkLoaderImpl.createPhaseControl(lfNetwork, ptc, t2wt.getId(), parameters);
            }
            for (ThreeWindingsTransformer threeWindingsTransformer : loadingContext.t3wtSet) {
                for (ThreeSides side : ThreeSides.values()) {
                    PhaseTapChanger ptc = threeWindingsTransformer.getLeg(side).getPhaseTapChanger();
                    LfNetworkLoaderImpl.createPhaseControl(lfNetwork, ptc, LfLegBranch.getId(side, threeWindingsTransformer.getId()), parameters);
                }
            }
        }
        for (HvdcLine hvdcLine : loadingContext.hvdcLineSet) {
            LfBus lfBus1 = LfNetworkLoaderImpl.getLfBus(hvdcLine.getConverterStation1().getTerminal(), lfNetwork, parameters.isBreakers());
            LfBus lfBus2 = LfNetworkLoaderImpl.getLfBus(hvdcLine.getConverterStation2().getTerminal(), lfNetwork, parameters.isBreakers());
            LfVscConverterStationImpl cs1 = (LfVscConverterStationImpl)lfNetwork.getGeneratorById(hvdcLine.getConverterStation1().getId());
            LfVscConverterStationImpl cs2 = (LfVscConverterStationImpl)lfNetwork.getGeneratorById(hvdcLine.getConverterStation2().getId());
            if (cs1 != null && cs2 != null) {
                LfHvdcImpl lfHvdc = new LfHvdcImpl(hvdcLine.getId(), lfBus1, lfBus2, lfNetwork, hvdcLine, parameters.isHvdcAcEmulation());
                lfHvdc.setConverterStation1(cs1);
                lfHvdc.setConverterStation2(cs2);
                lfNetwork.addHvdc(lfHvdc);
                continue;
            }
            LOGGER.warn("The converter stations of hvdc line {} are not in the same synchronous component: no hvdc link created to model active power flow.", (Object)hvdcLine.getId());
        }
    }

    private static void createTransformersVoltageControls(LfNetwork lfNetwork, LfNetworkParameters parameters, LoadingContext loadingContext, LfNetworkLoadingReport report) {
        for (Branch<?> branch : loadingContext.branchSet) {
            if (!(branch instanceof TwoWindingsTransformer)) continue;
            TwoWindingsTransformer t2wt = (TwoWindingsTransformer)branch;
            RatioTapChanger rtc = t2wt.getRatioTapChanger();
            LfNetworkLoaderImpl.createTransformerVoltageControl(lfNetwork, rtc, t2wt.getId(), parameters, report);
        }
        for (ThreeWindingsTransformer t3wt : loadingContext.t3wtSet) {
            for (ThreeSides side : ThreeSides.values()) {
                RatioTapChanger rtc = t3wt.getLeg(side).getRatioTapChanger();
                LfNetworkLoaderImpl.createTransformerVoltageControl(lfNetwork, rtc, LfLegBranch.getId(side, t3wt.getId()), parameters, report);
            }
        }
    }

    private static void createTransformerReactivePowerControls(LfNetwork lfNetwork, LfNetworkParameters parameters, LoadingContext loadingContext, LfNetworkLoadingReport report) {
        for (Branch<?> branch : loadingContext.branchSet) {
            if (!(branch instanceof TwoWindingsTransformer)) continue;
            TwoWindingsTransformer t2wt = (TwoWindingsTransformer)branch;
            RatioTapChanger rtc = t2wt.getRatioTapChanger();
            LfNetworkLoaderImpl.createTransformerReactivePowerControl(lfNetwork, rtc, t2wt.getId(), parameters, report);
        }
        for (ThreeWindingsTransformer t3wt : loadingContext.t3wtSet) {
            for (ThreeSides side : ThreeSides.values()) {
                RatioTapChanger rtc = t3wt.getLeg(side).getRatioTapChanger();
                LfNetworkLoaderImpl.createTransformerReactivePowerControl(lfNetwork, rtc, LfLegBranch.getId(side, t3wt.getId()), parameters, report);
            }
        }
    }

    private static void createSwitches(List<Switch> switches, LfNetwork lfNetwork, List<LfNetworkLoaderPostProcessor> postProcessors, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        if (switches != null) {
            for (Switch sw : switches) {
                VoltageLevel vl = sw.getVoltageLevel();
                Bus bus1 = vl.getBusBreakerView().getBus1(sw.getId());
                Bus bus2 = vl.getBusBreakerView().getBus2(sw.getId());
                LfBus lfBus1 = lfNetwork.getBusById(bus1.getId());
                LfBus lfBus2 = lfNetwork.getBusById(bus2.getId());
                LfSwitch lfSwitch = new LfSwitch(lfNetwork, lfBus1, lfBus2, sw, parameters);
                LfNetworkLoaderImpl.addBranch(lfNetwork, lfSwitch, report);
                postProcessors.forEach(pp -> pp.onBranchAdded(sw, lfSwitch));
            }
        }
    }

    private static void createPhaseControl(LfNetwork lfNetwork, PhaseTapChanger ptc, String controllerBranchId, LfNetworkParameters parameters) {
        if (ptc != null && ptc.isRegulating() && ptc.getRegulationMode() != PhaseTapChanger.RegulationMode.FIXED_TAP) {
            TwoSides controlledSide;
            LfBranch controlledBranch;
            String controlledBranchId = ptc.getRegulationTerminal().getConnectable().getId();
            Connectable connectable = ptc.getRegulationTerminal().getConnectable();
            if (connectable instanceof ThreeWindingsTransformer) {
                ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
                controlledBranchId = LfLegBranch.getId(twt.getSide(ptc.getRegulationTerminal()), controlledBranchId);
            }
            if ((controlledBranch = lfNetwork.getBranchById(controlledBranchId)) == null) {
                LOGGER.warn("Phase controlled branch '{}' is out of voltage or in a different synchronous component: phase control discarded", (Object)controlledBranchId);
                return;
            }
            if (!controlledBranch.isConnectedAtBothSides()) {
                LOGGER.warn("Phase controlled branch '{}' is open: phase control discarded", (Object)controlledBranch.getId());
                return;
            }
            LfBranch controllerBranch = lfNetwork.getBranchById(controllerBranchId);
            if (controllerBranch.getBus1() == null || controllerBranch.getBus2() == null) {
                LOGGER.warn("Phase controller branch '{}' is open: phase control discarded", (Object)controllerBranch.getId());
                return;
            }
            if (ptc.getRegulationTerminal().getBusView().getBus() == null) {
                LOGGER.warn("Regulating terminal of phase controller branch '{}' is out of voltage: phase control discarded", (Object)controllerBranch.getId());
                return;
            }
            LfBus controlledBus = LfNetworkLoaderImpl.getLfBus(ptc.getRegulationTerminal(), lfNetwork, parameters.isBreakers());
            TwoSides twoSides = controlledSide = controlledBus == controlledBranch.getBus1() ? TwoSides.ONE : TwoSides.TWO;
            if (controlledBranch instanceof LfLegBranch && controlledBus == controlledBranch.getBus2()) {
                throw new IllegalStateException("Leg " + controlledBranch.getId() + " has a non supported control at star bus side");
            }
            TransformerPhaseControl phaseControl = null;
            if (ptc.getRegulationMode() == PhaseTapChanger.RegulationMode.CURRENT_LIMITER) {
                if (controlledBranch == controllerBranch && controlledBus != null) {
                    double targetValue = ptc.getRegulationValue() / PerUnit.ib(controlledBus.getNominalV());
                    double targetDeadband = ptc.getTargetDeadband() / PerUnit.ib(controlledBus.getNominalV());
                    phaseControl = new TransformerPhaseControl(controllerBranch, controlledBranch, controlledSide, TransformerPhaseControl.Mode.LIMITER, targetValue, targetDeadband, TransformerPhaseControl.Unit.A);
                } else {
                    LOGGER.warn("Branch {} limits current limiter on remote branch {}: not supported yet", (Object)controllerBranch.getId(), (Object)controlledBranch.getId());
                }
            } else if (ptc.getRegulationMode() == PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL) {
                double targetValue = ptc.getRegulationValue() / 100.0;
                double targetDeadband = ptc.getTargetDeadband() / 100.0;
                phaseControl = new TransformerPhaseControl(controllerBranch, controlledBranch, controlledSide, TransformerPhaseControl.Mode.CONTROLLER, targetValue, targetDeadband, TransformerPhaseControl.Unit.MW);
            }
            controllerBranch.setPhaseControl(phaseControl);
            controlledBranch.setPhaseControl(phaseControl);
        }
    }

    private static void createTransformerVoltageControl(LfNetwork lfNetwork, RatioTapChanger rtc, String controllerBranchId, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        Double targetDeadband;
        if (rtc == null || !rtc.isRegulating() || !rtc.hasLoadTapChangingCapabilities() || rtc.getRegulationMode() != RatioTapChanger.RegulationMode.VOLTAGE) {
            return;
        }
        LfBranch controllerBranch = lfNetwork.getBranchById(controllerBranchId);
        if (!controllerBranch.isConnectedAtBothSides()) {
            LOGGER.trace("Voltage controller branch '{}' is open: voltage control discarded", (Object)controllerBranch.getId());
            ++report.transformerVoltageControlDiscardedBecauseControllerBranchIsOpen;
            return;
        }
        LfBus controlledBus = LfNetworkLoaderImpl.getLfBus(rtc.getRegulationTerminal(), lfNetwork, parameters.isBreakers());
        if (controlledBus == null) {
            LOGGER.warn("Regulating terminal of voltage controller branch '{}' is out of voltage or in a different synchronous component: voltage control discarded", (Object)controllerBranch.getId());
            return;
        }
        double regulatingTerminalNominalV = rtc.getRegulationTerminal().getVoltageLevel().getNominalV();
        double targetValue = rtc.getTargetV() / regulatingTerminalNominalV;
        Double d = targetDeadband = rtc.getTargetDeadband() > 0.0 ? Double.valueOf(rtc.getTargetDeadband() / regulatingTerminalNominalV) : null;
        if (!VoltageControl.checkTargetV(targetValue, controlledBus.getNominalV(), parameters)) {
            LOGGER.trace("RatioTapChanger on transformer '{}' has an inconsistent target voltage: {} pu: transformer voltage control discarded", (Object)controllerBranchId, (Object)targetValue);
            if (report != null) {
                ++report.transformersWithInconsistentTargetVoltage;
            }
            return;
        }
        controlledBus.getTransformerVoltageControl().ifPresentOrElse(vc -> {
            LOGGER.trace("Controlled bus '{}' already has a transformer voltage control: a shared control is created", (Object)controlledBus.getId());
            if (FastMath.abs((double)(vc.getTargetValue() - targetValue)) > 0.01) {
                LOGGER.warn("Controlled bus '{}' already has a transformer voltage control with a different target voltage: {} and {}", new Object[]{controlledBus.getId(), vc.getTargetValue(), targetValue});
            }
            vc.addControllerElement(controllerBranch);
            controllerBranch.setVoltageControl((TransformerVoltageControl)vc);
            if (targetDeadband != null) {
                Double oldTargetDeadband = vc.getTargetDeadband().orElse(null);
                if (oldTargetDeadband == null) {
                    vc.setTargetDeadband(targetDeadband);
                } else {
                    vc.setTargetDeadband(Math.min(oldTargetDeadband, targetDeadband));
                }
            }
        }, () -> {
            TransformerVoltageControl voltageControl = new TransformerVoltageControl(controlledBus, parameters.getVoltageTargetPriority(VoltageControl.Type.TRANSFORMER), targetValue, targetDeadband);
            voltageControl.addControllerElement(controllerBranch);
            controllerBranch.setVoltageControl(voltageControl);
            controlledBus.setTransformerVoltageControl(voltageControl);
        });
    }

    private static void createTransformerReactivePowerControl(LfNetwork lfNetwork, RatioTapChanger rtc, String controllerBranchId, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        LfBranch controlledBranch;
        if (rtc == null || !rtc.isRegulating() || !rtc.hasLoadTapChangingCapabilities() || rtc.getRegulationMode() != RatioTapChanger.RegulationMode.REACTIVE_POWER) {
            return;
        }
        LfBranch controllerBranch = lfNetwork.getBranchById(controllerBranchId);
        if (!controllerBranch.isConnectedAtBothSides()) {
            LOGGER.trace("Reactive power controller branch '{}' is open: transformer reactive power control discarded", (Object)controllerBranchId);
            ++report.transformerReactivePowerControlDiscardedBecauseControllerBranchIsOpen;
            return;
        }
        String controlledBranchId = rtc.getRegulationTerminal().getConnectable().getId();
        Connectable connectable = rtc.getRegulationTerminal().getConnectable();
        if (connectable instanceof ThreeWindingsTransformer) {
            ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
            controlledBranchId = LfLegBranch.getId(twt.getSide(rtc.getRegulationTerminal()), controlledBranchId);
        }
        if ((controlledBranch = lfNetwork.getBranchById(controlledBranchId)) == null) {
            LOGGER.warn("Reactive power controlled branch '{}' is out of voltage or in a different synchronous component: transformer reactive power control discarded", (Object)controlledBranchId);
            return;
        }
        if (!controlledBranch.isConnectedAtBothSides()) {
            LOGGER.warn("Reactive power controlled branch '{}' is open: transformer reactive power control discarded", (Object)controlledBranchId);
            return;
        }
        TwoSides controlledSide = LfNetworkLoaderImpl.getLfBus(rtc.getRegulationTerminal(), lfNetwork, parameters.isBreakers()) == controlledBranch.getBus1() ? TwoSides.ONE : TwoSides.TWO;
        double targetValue = rtc.getRegulationValue() / 100.0;
        double targetDeadband = rtc.getTargetDeadband() / 100.0;
        controlledBranch.getTransformerReactivePowerControl().ifPresentOrElse(transformerReactivePowerControl -> LOGGER.warn("Controlled branch '{}' already has a transformer reactive power control: not implemented yet.", (Object)controlledBranch.getId()), () -> {
            TransformerReactivePowerControl reactivePowerControl = new TransformerReactivePowerControl(controlledBranch, controlledSide, controllerBranch, targetValue, targetDeadband);
            controllerBranch.setTransformerReactivePowerControl(reactivePowerControl);
            controlledBranch.setTransformerReactivePowerControl(reactivePowerControl);
        });
    }

    private static void createShuntVoltageControl(LfNetwork lfNetwork, ShuntCompensator shuntCompensator, LfNetworkParameters parameters) {
        if (!shuntCompensator.isVoltageRegulatorOn()) {
            return;
        }
        LfBus controllerBus = LfNetworkLoaderImpl.getLfBus(shuntCompensator.getTerminal(), lfNetwork, parameters.isBreakers());
        if (controllerBus == null) {
            LOGGER.warn("Voltage controller shunt {} is out of voltage: no voltage control created", (Object)shuntCompensator.getId());
            return;
        }
        controllerBus.getControllerShunt().ifPresent(controllerShunt -> {
            LfBus controlledBus = LfNetworkLoaderImpl.getLfBus(shuntCompensator.getRegulatingTerminal(), lfNetwork, parameters.isBreakers());
            if (controlledBus == null) {
                LOGGER.warn("Regulating terminal of voltage controller shunt {} is out of voltage: no voltage control created", (Object)shuntCompensator.getId());
                controllerShunt.setVoltageControlCapability(false);
                return;
            }
            if (controllerShunt.getVoltageControl().isPresent()) {
                if (!controllerShunt.getVoltageControl().orElseThrow().getControlledBus().getId().equals(controlledBus.getId())) {
                    LOGGER.error("Controller shunt {} is already in a shunt voltage control. The second controlled bus {} is ignored", (Object)controllerShunt.getId(), (Object)controlledBus.getId());
                    Reports.reportControllerShuntAlreadyInVoltageControl(controllerBus.getNetwork().getReportNode(), controllerShunt.getId(), controlledBus.getId());
                }
                return;
            }
            double regulatingTerminalNominalV = shuntCompensator.getRegulatingTerminal().getVoltageLevel().getNominalV();
            double targetValue = shuntCompensator.getTargetV() / regulatingTerminalNominalV;
            Double targetDeadband = shuntCompensator.getTargetDeadband() > 0.0 ? Double.valueOf(shuntCompensator.getTargetDeadband() / regulatingTerminalNominalV) : null;
            controlledBus.getShuntVoltageControl().ifPresentOrElse(voltageControl -> {
                LOGGER.trace("Controlled bus {} has already a shunt voltage control: a shared control is created", (Object)controlledBus.getId());
                if (FastMath.abs((double)(voltageControl.getTargetValue() - targetValue)) > 0.01) {
                    LOGGER.warn("Controlled bus {} already has a shunt voltage control with a different target voltage: {} and {}", new Object[]{controlledBus.getId(), voltageControl.getTargetValue(), targetValue});
                }
                if (!voltageControl.getControllerElements().contains(controllerShunt)) {
                    voltageControl.addControllerElement(controllerShunt);
                    controllerShunt.setVoltageControl((ShuntVoltageControl)voltageControl);
                    controlledBus.setShuntVoltageControl((ShuntVoltageControl)voltageControl);
                    if (targetDeadband != null) {
                        Double oldTargetDeadband = voltageControl.getTargetDeadband().orElse(null);
                        if (oldTargetDeadband == null) {
                            voltageControl.setTargetDeadband(targetDeadband);
                        } else {
                            voltageControl.setTargetDeadband(Math.min(oldTargetDeadband, targetDeadband));
                        }
                    }
                }
            }, () -> {
                ShuntVoltageControl voltageControl = new ShuntVoltageControl(controlledBus, parameters.getVoltageTargetPriority(VoltageControl.Type.SHUNT), targetValue, targetDeadband);
                voltageControl.addControllerElement(controllerShunt);
                controllerShunt.setVoltageControl(voltageControl);
                controlledBus.setShuntVoltageControl(voltageControl);
            });
        });
    }

    private static LfBus getLfBus(Terminal terminal, LfNetwork lfNetwork, boolean breakers) {
        Bus bus = Networks.getBus(terminal, breakers);
        return bus != null ? lfNetwork.getBusById(bus.getId()) : null;
    }

    private LfNetwork create(int numCC, int numSC, Network network, List<Bus> buses, List<Switch> switches, LfTopoConfig topoConfig, LfNetworkParameters parameters, ReportNode reportNode) {
        LfNetwork lfNetwork = new LfNetwork(numCC, numSC, parameters.getSlackBusSelector(), parameters.getMaxSlackBusCount(), parameters.getConnectivityFactory(), parameters.getReferenceBusSelector(), reportNode);
        LoadingContext loadingContext = new LoadingContext();
        LfNetworkLoadingReport report = new LfNetworkLoadingReport();
        List<LfNetworkLoaderPostProcessor> postProcessors = this.postProcessorsSupplier.get().stream().filter(pp -> pp.getLoadingPolicy() == LfNetworkLoaderPostProcessor.LoadingPolicy.ALWAYS || pp.getLoadingPolicy() == LfNetworkLoaderPostProcessor.LoadingPolicy.SELECTION && parameters.getLoaderPostProcessorSelection().contains(pp.getName())).collect(Collectors.toList());
        ArrayList<LfBus> lfBuses = new ArrayList<LfBus>();
        LfNetworkLoaderImpl.createBuses(buses, parameters, lfNetwork, lfBuses, topoConfig, loadingContext, report, postProcessors);
        LfNetworkLoaderImpl.createBranches(lfBuses, lfNetwork, topoConfig, loadingContext, report, parameters, postProcessors);
        if (parameters.getLoadFlowModel() == LoadFlowModel.AC) {
            LfNetworkLoaderImpl.createVoltageControls(lfBuses, parameters);
            if (parameters.isGeneratorReactivePowerRemoteControl()) {
                LfNetworkLoaderImpl.createGeneratorReactivePowerControls(lfBuses);
            }
            if (parameters.isTransformerVoltageControl()) {
                LfNetworkLoaderImpl.createTransformersVoltageControls(lfNetwork, parameters, loadingContext, report);
            }
            if (parameters.isTransformerReactivePowerControl()) {
                LfNetworkLoaderImpl.createTransformerReactivePowerControls(lfNetwork, parameters, loadingContext, report);
            }
            if (parameters.isShuntVoltageControl()) {
                for (ShuntCompensator shunt : loadingContext.shuntSet) {
                    LfNetworkLoaderImpl.createShuntVoltageControl(lfNetwork, shunt, parameters);
                }
            }
        }
        if (parameters.isBreakers()) {
            LfNetworkLoaderImpl.createSwitches(switches, lfNetwork, postProcessors, parameters, report);
        }
        LfNetworkLoaderImpl.createSecondaryVoltageControls(network, parameters, lfNetwork);
        LfNetworkLoaderImpl.createVoltageAngleLimits(network, lfNetwork, parameters);
        if (parameters.isSimulateAutomationSystems()) {
            this.createAutomationSystems(network, lfNetwork);
        }
        if (report.generatorsDiscardedFromVoltageControlBecauseNotStarted > 0) {
            Reports.reportGeneratorsDiscardedFromVoltageControlBecauseNotStarted(reportNode, report.generatorsDiscardedFromVoltageControlBecauseNotStarted);
            LOGGER.warn("Network {}: {} generators have been discarded from voltage control because not started", (Object)lfNetwork, (Object)report.generatorsDiscardedFromVoltageControlBecauseNotStarted);
        }
        if (report.generatorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall > 0) {
            Reports.reportGeneratorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall(reportNode, report.generatorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall);
            LOGGER.warn("Network {}: {} generators have been discarded from voltage control because of a too small reactive range", (Object)lfNetwork, (Object)report.generatorsDiscardedFromVoltageControlBecauseReactiveRangeIsTooSmall);
        }
        if (report.generatorsDiscardedFromVoltageControlBecauseTargetPIsOutsideActiveLimits > 0) {
            Reports.reportGeneratorsDiscardedFromVoltageControlBecauseTargetPIsOutsideActiveLimits(reportNode, report.generatorsDiscardedFromVoltageControlBecauseTargetPIsOutsideActiveLimits);
            LOGGER.warn("Network {}: {} generators have been discarded from voltage control because targetP is outside active power limits", (Object)lfNetwork, (Object)report.generatorsDiscardedFromVoltageControlBecauseTargetPIsOutsideActiveLimits);
        }
        if (report.generatorsDiscardedFromActivePowerControlBecauseTargetEqualsToZero > 0) {
            LOGGER.warn("Network {}: {} generators have been discarded from active power control because of a targetP equals 0", (Object)lfNetwork, (Object)report.generatorsDiscardedFromActivePowerControlBecauseTargetEqualsToZero);
        }
        if (report.generatorsDiscardedFromActivePowerControlBecauseTargetPGreaterThanMaxP > 0) {
            LOGGER.warn("Network {}: {} generators have been discarded from active power control because of a targetP > maxP", (Object)lfNetwork, (Object)report.generatorsDiscardedFromActivePowerControlBecauseTargetPGreaterThanMaxP);
        }
        if (report.generatorsDiscardedFromActivePowerControlBecauseMaxPNotPlausible > 0) {
            LOGGER.warn("Network {}: {} generators have been discarded from active power control because of maxP not plausible", (Object)lfNetwork, (Object)report.generatorsDiscardedFromActivePowerControlBecauseMaxPNotPlausible);
        }
        if (report.generatorsDiscardedFromActivePowerControlBecauseMaxPEqualsMinP > 0) {
            LOGGER.warn("Network {}: {} generators have been discarded from active power control because of maxP equals to minP", (Object)lfNetwork, (Object)report.generatorsDiscardedFromActivePowerControlBecauseMaxPEqualsMinP);
        }
        if (report.branchesDiscardedBecauseConnectedToSameBusAtBothEnds > 0) {
            LOGGER.warn("Network {}: {} branches have been discarded because connected to same bus at both ends", (Object)lfNetwork, (Object)report.branchesDiscardedBecauseConnectedToSameBusAtBothEnds);
        }
        if (report.nonImpedantBranches > 0) {
            LOGGER.warn("Network {}: {} branches are non impedant", (Object)lfNetwork, (Object)report.nonImpedantBranches);
        }
        if (report.generatorsWithInconsistentTargetVoltage > 0) {
            Reports.reportGeneratorsDiscardedFromVoltageControlBecauseTargetVIsInconsistent(reportNode, report.generatorsWithInconsistentTargetVoltage);
            LOGGER.warn("Network {}: {} generators have an inconsistent target voltage and have been discarded from voltage control", (Object)lfNetwork, (Object)report.generatorsWithInconsistentTargetVoltage);
        }
        if (report.generatorsWithZeroRemoteVoltageControlReactivePowerKey > 0) {
            LOGGER.warn("Network {}: {} generators have a zero remote voltage control reactive power key", (Object)lfNetwork, (Object)report.generatorsWithZeroRemoteVoltageControlReactivePowerKey);
        }
        if (report.transformerVoltageControlDiscardedBecauseControllerBranchIsOpen > 0) {
            LOGGER.warn("Network {}: {} transformer voltage controls have been discarded because controller branch is open", (Object)lfNetwork, (Object)report.transformerVoltageControlDiscardedBecauseControllerBranchIsOpen);
        }
        if (report.transformerReactivePowerControlDiscardedBecauseControllerBranchIsOpen > 0) {
            LOGGER.warn("Network {}: {} transformer reactive power controls have been discarded because controller branch is open", (Object)lfNetwork, (Object)report.transformerReactivePowerControlDiscardedBecauseControllerBranchIsOpen);
        }
        if (report.transformersWithInconsistentTargetVoltage > 0) {
            Reports.reportTransformersDiscardedFromVoltageControlBecauseTargetVIsInconsistent(reportNode, report.transformersWithInconsistentTargetVoltage);
            LOGGER.warn("Network {}: {} transformer voltage controls have an inconsistent target voltage and have been discarded from voltage control", (Object)lfNetwork, (Object)report.transformersWithInconsistentTargetVoltage);
        }
        if (report.shuntsWithInconsistentTargetVoltage > 0) {
            Reports.reportShuntsDiscardedFromVoltageControlBecauseTargetVIsInconsistent(reportNode, report.shuntsWithInconsistentTargetVoltage);
            LOGGER.warn("Network {}: {} shunt voltage controls have an inconsistent target voltage and have been discarded from voltage control", (Object)lfNetwork, (Object)report.shuntsWithInconsistentTargetVoltage);
        }
        if (parameters.getDebugDir() != null) {
            Path debugDir = DebugUtil.getDebugDir(parameters.getDebugDir());
            String dateStr = ZonedDateTime.now().format(DebugUtil.DATE_TIME_FORMAT);
            lfNetwork.writeJson(debugDir.resolve("lfnetwork-" + dateStr + ".json"));
            lfNetwork.writeGraphViz(debugDir.resolve("lfnetwork-" + dateStr + ".dot"), parameters.getLoadFlowModel());
        }
        return lfNetwork;
    }

    private static void checkControlZonesAreDisjoints(LfNetwork lfNetwork) {
        HashMap<GeneratorVoltageControl, MutableInt> generatorVoltageControlCount = new HashMap<GeneratorVoltageControl, MutableInt>();
        for (LfSecondaryVoltageControl lfSecondaryVoltageControl : lfNetwork.getSecondaryVoltageControls()) {
            for (GeneratorVoltageControl generatorVoltageControl : lfSecondaryVoltageControl.getGeneratorVoltageControls()) {
                generatorVoltageControlCount.computeIfAbsent(generatorVoltageControl, k -> new MutableInt()).increment();
            }
        }
        for (Map.Entry entry : generatorVoltageControlCount.entrySet()) {
            if (((MutableInt)entry.getValue()).intValue() <= 1) continue;
            throw new PowsyblException("Generator voltage control of controlled bus '" + ((GeneratorVoltageControl)entry.getKey()).getControlledBus().getId() + "' is present in more that one control zone");
        }
    }

    private static Set<GeneratorVoltageControl> findControlZoneGeneratorVoltageControl(Network network, LfNetworkParameters parameters, LfNetwork lfNetwork, ControlZone controlZone) {
        return controlZone.getControlUnits().stream().flatMap(controlUnit -> Networks.getEquipmentRegulatingTerminal(network, controlUnit.getId()).stream()).flatMap(regulatingTerminal -> {
            Connectable connectable = regulatingTerminal.getConnectable();
            if (connectable.getType() != IdentifiableType.GENERATOR && !HvdcConverterStations.isVsc(connectable)) {
                throw new PowsyblException("Control unit '" + connectable.getId() + "' of zone '" + controlZone.getName() + "' is expected to be either a generator or a VSC converter station");
            }
            return Optional.ofNullable(LfNetworkLoaderImpl.getLfBus(regulatingTerminal, lfNetwork, parameters.isBreakers())).stream();
        }).filter(LfBus::isGeneratorVoltageControlled).flatMap(controlledBus -> controlledBus.getGeneratorVoltageControl().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void createSecondaryVoltageControls(Network network, LfNetworkParameters parameters, LfNetwork lfNetwork) {
        if (!parameters.isSecondaryVoltageControl()) {
            return;
        }
        SecondaryVoltageControl control = (SecondaryVoltageControl)network.getExtension(SecondaryVoltageControl.class);
        if (control == null) {
            return;
        }
        for (ControlZone controlZone : control.getControlZones()) {
            PilotPoint pilotPoint = controlZone.getPilotPoint();
            LfNetworkLoaderImpl.findPilotBus(network, parameters.isBreakers(), pilotPoint.getBusbarSectionsOrBusesIds()).ifPresentOrElse(pilotBus -> {
                LfBus lfPilotBus = lfNetwork.getBusById(pilotBus.getId());
                if (lfPilotBus != null) {
                    double targetV = pilotPoint.getTargetV() / lfPilotBus.getNominalV();
                    Set<GeneratorVoltageControl> generatorVoltageControls = LfNetworkLoaderImpl.findControlZoneGeneratorVoltageControl(network, parameters, lfNetwork, controlZone);
                    LOGGER.debug("{} control units of control zone '{}' have been mapped to {} generator voltage control (controlled buses are: {})", new Object[]{controlZone.getControlUnits().size(), controlZone.getName(), generatorVoltageControls.size(), generatorVoltageControls.stream().map(VoltageControl::getControlledBus).map(LfElement::getId).toList()});
                    if (!generatorVoltageControls.isEmpty()) {
                        Set<String> participatingControlUnitIds = controlZone.getControlUnits().stream().filter(ControlUnit::isParticipate).map(ControlUnit::getId).collect(Collectors.toSet());
                        LfSecondaryVoltageControl lfSvc = new LfSecondaryVoltageControl(controlZone.getName(), lfPilotBus, targetV, participatingControlUnitIds, generatorVoltageControls);
                        lfNetwork.addSecondaryVoltageControl(lfSvc);
                    }
                }
            }, () -> LOGGER.warn("None of the pilot buses of control zone '{}' are valid", (Object)controlZone.getName()));
        }
        LfNetworkLoaderImpl.checkControlZonesAreDisjoints(lfNetwork);
        LOGGER.info("Network {}: {} secondary control zones have been created ({})", new Object[]{lfNetwork, lfNetwork.getSecondaryVoltageControls().size(), lfNetwork.getSecondaryVoltageControls().stream().map(LfSecondaryVoltageControl::getZoneName).toList()});
    }

    private static Optional<Bus> findPilotBus(Network network, boolean breaker, List<String> busbarSectionsOrBusesId) {
        for (String busbarSectionOrBusId : busbarSectionsOrBusesId) {
            BusbarSection bbs = network.getBusbarSection(busbarSectionOrBusId);
            if (bbs != null) {
                return Optional.ofNullable(Networks.getBus(bbs.getTerminal(), breaker));
            }
            Bus configuredBus = network.getBusBreakerView().getBus(busbarSectionOrBusId);
            if (configuredBus == null) continue;
            return breaker ? Optional.of(configuredBus) : Optional.ofNullable(configuredBus.getVoltageLevel().getBusView().getMergedBus(configuredBus.getId()));
        }
        return Optional.empty();
    }

    private static void createVoltageAngleLimits(Network network, LfNetwork lfNetwork, LfNetworkParameters parameters) {
        network.getVoltageAngleLimits().forEach(voltageAngleLimit -> {
            LfBus from = LfNetworkLoaderImpl.getLfBus(voltageAngleLimit.getTerminalFrom(), lfNetwork, parameters.isBreakers());
            LfBus to = LfNetworkLoaderImpl.getLfBus(voltageAngleLimit.getTerminalTo(), lfNetwork, parameters.isBreakers());
            if (from != null && to != null) {
                lfNetwork.addVoltageAngleLimit(new LfNetwork.LfVoltageAngleLimit(voltageAngleLimit.getId(), from, to, Math.toRadians(voltageAngleLimit.getHighLimit().orElse(Double.NaN)), Math.toRadians(voltageAngleLimit.getLowLimit().orElse(Double.NaN))));
            }
        });
    }

    private static String getTrippingLfBranchId(OverloadManagementSystem.Tripping tripping) {
        String branchToOperateId = null;
        if (tripping.getType() == OverloadManagementSystem.Tripping.Type.SWITCH_TRIPPING) {
            OverloadManagementSystem.SwitchTripping switchTripping = (OverloadManagementSystem.SwitchTripping)tripping;
            branchToOperateId = switchTripping.getSwitchToOperateId();
        } else if (tripping.getType() == OverloadManagementSystem.Tripping.Type.BRANCH_TRIPPING) {
            OverloadManagementSystem.BranchTripping branchTripping = (OverloadManagementSystem.BranchTripping)tripping;
            branchToOperateId = branchTripping.getBranchToOperateId();
        }
        return branchToOperateId;
    }

    private static void addTripping(LfNetwork lfNetwork, LfOverloadManagementSystem lfOverloadManagementSystem, OverloadManagementSystem.Tripping tripping) {
        String branchToOperateId = LfNetworkLoaderImpl.getTrippingLfBranchId(tripping);
        LfBranch lfBranchToOperate = lfNetwork.getBranchById(branchToOperateId);
        if (lfBranchToOperate != null) {
            LfBus bus = lfOverloadManagementSystem.getMonitoredSide().equals((Object)TwoSides.ONE) ? lfOverloadManagementSystem.getMonitoredBranch().getBus1() : lfOverloadManagementSystem.getMonitoredBranch().getBus2();
            double threshold = tripping.getCurrentLimit() / PerUnit.ib(bus.getNominalV());
            lfOverloadManagementSystem.addLfBranchTripping(lfBranchToOperate, tripping.isOpenAction(), threshold);
        } else {
            LOGGER.warn("Invalid overload management system: branch to operate is '{}'", (Object)branchToOperateId);
        }
    }

    private static void createOverloadManagementSystem(LfNetwork lfNetwork, OverloadManagementSystem system) {
        if (system.isEnabled()) {
            LfBranch lfMonitoredElement = lfNetwork.getBranchById(system.getMonitoredElementId());
            if (system.getTrippings().stream().map(OverloadManagementSystem.Tripping::getType).anyMatch(type -> type == OverloadManagementSystem.Tripping.Type.THREE_WINDINGS_TRANSFORMER_TRIPPING)) {
                LOGGER.warn("Unsupported overload management system {}: three windings transformer tripping supported", (Object)system.getId());
                return;
            }
            if (lfMonitoredElement != null) {
                LfOverloadManagementSystem lfOverloadManagementSystem = new LfOverloadManagementSystem(lfMonitoredElement, system.getMonitoredSide().toTwoSides());
                system.getTrippings().forEach(tripping -> LfNetworkLoaderImpl.addTripping(lfNetwork, lfOverloadManagementSystem, tripping));
                if (!lfOverloadManagementSystem.getBranchTrippingList().isEmpty()) {
                    lfNetwork.addOverloadManagementSystem(lfOverloadManagementSystem);
                }
            } else {
                LOGGER.warn("Invalid overload management system: element to monitor is '{}'", (Object)system.getMonitoredElementId());
            }
        }
    }

    private void createAutomationSystems(Network network, LfNetwork lfNetwork) {
        for (Substation substation : network.getSubstations()) {
            for (OverloadManagementSystem system : substation.getOverloadManagementSystems()) {
                LfNetworkLoaderImpl.createOverloadManagementSystem(lfNetwork, system);
            }
        }
    }

    @Override
    public List<LfNetwork> load(Network network, LfTopoConfig topoConfig, LfNetworkParameters parameters, ReportNode reportNode) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(parameters);
        if (!network.getValidationLevel().equals((Object)ValidationLevel.STEADY_STATE_HYPOTHESIS)) {
            throw new PowsyblException("Only STEADY STATE HYPOTHESIS validation level of the network is supported");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        TreeMap<Pair, List> busesByCc = new TreeMap<Pair, List>();
        Iterable<Bus> buses = Networks.getBuses(network, parameters.isBreakers());
        for (Bus bus : buses) {
            Component cc = bus.getConnectedComponent();
            Component sc = bus.getSynchronousComponent();
            if (cc == null || sc == null) continue;
            busesByCc.computeIfAbsent(Pair.of((Object)cc.getNum(), (Object)sc.getNum()), k -> new ArrayList()).add(bus);
        }
        HashMap<Pair, List> switchesByCc = new HashMap<Pair, List>();
        if (parameters.isBreakers()) {
            for (VoltageLevel vl : network.getVoltageLevels()) {
                for (Switch sw : vl.getBusBreakerView().getSwitches()) {
                    if (sw.isOpen()) continue;
                    Bus bus1 = vl.getBusBreakerView().getBus1(sw.getId());
                    Component cc = bus1.getConnectedComponent();
                    Component sc = bus1.getSynchronousComponent();
                    if (cc == null || sc == null) continue;
                    switchesByCc.computeIfAbsent(Pair.of((Object)cc.getNum(), (Object)sc.getNum()), k -> new ArrayList()).add(sw);
                }
            }
        }
        Stream stream = parameters.isComputeMainConnectedComponentOnly() ? busesByCc.entrySet().stream().filter(e -> (Integer)((Pair)e.getKey()).getLeft() == 0) : busesByCc.entrySet().stream();
        List<LfNetwork> lfNetworks = stream.map(e -> {
            Pair networkKey = (Pair)e.getKey();
            int numCc = (Integer)networkKey.getLeft();
            int numSc = (Integer)networkKey.getRight();
            List lfBuses = (List)e.getValue();
            return this.create(numCc, numSc, network, lfBuses, (List)switchesByCc.get(networkKey), topoConfig, parameters, Reports.createRootLfNetworkReportNode(numCc, numSc));
        }).collect(Collectors.toList());
        stopwatch.stop();
        LOGGER.debug(Markers.PERFORMANCE_MARKER, "LF networks created in {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return lfNetworks;
    }

    static boolean participateToSlackDistribution(LfNetworkParameters parameters, Bus b) {
        return parameters.getCountriesToBalance().isEmpty() || b.getVoltageLevel().getSubstation().flatMap(Substation::getCountry).map(country -> parameters.getCountriesToBalance().contains(country)).orElse(false) != false;
    }

    private static /* synthetic */ void lambda$createBranches$14(Branch branch, LfBranchImpl lfBranch, LfNetworkLoaderPostProcessor pp) {
        pp.onBranchAdded(branch, lfBranch);
    }

    private static class LoadingContext {
        private final Set<Branch<?>> branchSet = new LinkedHashSet();
        private final List<DanglingLine> danglingLines = new ArrayList<DanglingLine>();
        private final Set<ThreeWindingsTransformer> t3wtSet = new LinkedHashSet<ThreeWindingsTransformer>();
        private final Set<ShuntCompensator> shuntSet = new LinkedHashSet<ShuntCompensator>();
        private final Set<HvdcLine> hvdcLineSet = new LinkedHashSet<HvdcLine>();

        private LoadingContext() {
        }
    }
}

