/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.iidm.network.MinMaxReactiveLimits;
import com.powsybl.iidm.network.ReactiveLimits;
import com.powsybl.iidm.network.ReactiveLimitsKind;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.extensions.StandbyAutomaton;
import com.powsybl.iidm.network.extensions.VoltagePerReactivePowerControl;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfStaticVarCompensator;
import com.powsybl.openloadflow.network.impl.AbstractLfBus;
import com.powsybl.openloadflow.network.impl.AbstractLfGenerator;
import com.powsybl.openloadflow.network.impl.LfNetworkLoadingReport;
import com.powsybl.openloadflow.network.impl.Ref;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LfStaticVarCompensatorImpl
extends AbstractLfGenerator
implements LfStaticVarCompensator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LfStaticVarCompensatorImpl.class);
    private final Ref<StaticVarCompensator> svcRef;
    private final ReactiveLimits reactiveLimits;
    double nominalV;
    private double slope = 0.0;
    double targetQ = 0.0;
    private LfStaticVarCompensator.StandByAutomaton standByAutomaton;
    private double b0 = 0.0;
    private LfShunt standByAutomatonShunt;

    private LfStaticVarCompensatorImpl(StaticVarCompensator svc, LfNetwork network, final AbstractLfBus bus, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        super(network, 0.0);
        this.svcRef = Ref.create(svc, parameters.isCacheEnabled());
        this.nominalV = svc.getTerminal().getVoltageLevel().getNominalV();
        this.reactiveLimits = new MinMaxReactiveLimits(){

            public double getMinQ() {
                double v = bus.getV() * LfStaticVarCompensatorImpl.this.nominalV;
                return LfStaticVarCompensatorImpl.this.svcRef.get().getBmin() * v * v;
            }

            public double getMaxQ() {
                double v = bus.getV() * LfStaticVarCompensatorImpl.this.nominalV;
                return LfStaticVarCompensatorImpl.this.svcRef.get().getBmax() * v * v;
            }

            public ReactiveLimitsKind getKind() {
                return ReactiveLimitsKind.MIN_MAX;
            }

            public double getMinQ(double p) {
                return this.getMinQ();
            }

            public double getMaxQ(double p) {
                return this.getMaxQ();
            }
        };
        switch (svc.getRegulationMode()) {
            case VOLTAGE: {
                this.setupVoltageControl(svc, parameters, report);
                break;
            }
            case REACTIVE_POWER: {
                this.targetQ = -svc.getReactivePowerSetpoint() / 100.0;
                break;
            }
            case OFF: {
                this.targetQ = 0.0;
            }
        }
    }

    private void setupVoltageControl(StaticVarCompensator svc, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        boolean svcWithStandbyAutomaton;
        this.setVoltageControl(svc.getVoltageSetpoint(), svc.getTerminal(), svc.getRegulatingTerminal(), parameters, report);
        VoltagePerReactivePowerControl voltagePerReactivePowerControl = (VoltagePerReactivePowerControl)svc.getExtension(VoltagePerReactivePowerControl.class);
        boolean svcWithVoltagePerReactivePowerControl = parameters.isVoltagePerReactivePowerControl() && voltagePerReactivePowerControl != null;
        StandbyAutomaton standbyAutomaton = (StandbyAutomaton)svc.getExtension(StandbyAutomaton.class);
        boolean bl = svcWithStandbyAutomaton = parameters.isSvcVoltageMonitoring() && standbyAutomaton != null;
        if (svcWithStandbyAutomaton && svcWithVoltagePerReactivePowerControl) {
            LOGGER.warn("Static var compensator {} has VoltagePerReactivePowerControl and StandbyAutomaton extensions: VoltagePerReactivePowerControl extension ignored", (Object)svc.getId());
            svcWithVoltagePerReactivePowerControl = false;
        }
        if (svcWithVoltagePerReactivePowerControl) {
            this.slope = voltagePerReactivePowerControl.getSlope() * 100.0 / this.nominalV;
        }
        if (svcWithStandbyAutomaton) {
            if (standbyAutomaton.getB0() != 0.0) {
                this.b0 = standbyAutomaton.getB0();
            }
            if (standbyAutomaton.isStandby()) {
                this.standByAutomaton = new LfStaticVarCompensator.StandByAutomaton(standbyAutomaton.getHighVoltageThreshold() / this.nominalV, standbyAutomaton.getLowVoltageThreshold() / this.nominalV, standbyAutomaton.getHighVoltageSetpoint() / this.nominalV, standbyAutomaton.getLowVoltageSetpoint() / this.nominalV);
                this.generatorControlType = LfGenerator.GeneratorControlType.MONITORING_VOLTAGE;
            }
        }
    }

    public static LfStaticVarCompensatorImpl create(StaticVarCompensator svc, LfNetwork network, AbstractLfBus bus, LfNetworkParameters parameters, LfNetworkLoadingReport report) {
        Objects.requireNonNull(svc);
        Objects.requireNonNull(network);
        Objects.requireNonNull(bus);
        Objects.requireNonNull(parameters);
        Objects.requireNonNull(report);
        return new LfStaticVarCompensatorImpl(svc, network, bus, parameters, report);
    }

    private StaticVarCompensator getSvc() {
        return this.svcRef.get();
    }

    @Override
    public String getId() {
        return this.getSvc().getId();
    }

    @Override
    public double getTargetQ() {
        return this.targetQ;
    }

    @Override
    public double getMinP() {
        return -1.7976931348623157E308;
    }

    @Override
    public double getMaxP() {
        return Double.MAX_VALUE;
    }

    @Override
    protected Optional<ReactiveLimits> getReactiveLimits() {
        return Optional.of(this.reactiveLimits);
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters) {
        double vSquare = this.bus.getV() * this.bus.getV() * this.nominalV * this.nominalV;
        double q = (Double.isNaN(this.calculatedQ) ? -this.targetQ : -this.calculatedQ) * 100.0;
        this.getSvc().getTerminal().setP(0.0).setQ(q - this.b0 * vSquare);
    }

    @Override
    public double getSlope() {
        return this.slope;
    }

    @Override
    public void setSlope(double slope) {
        this.slope = slope;
    }

    @Override
    public double getB0() {
        return this.b0;
    }

    @Override
    public Optional<LfStaticVarCompensator.StandByAutomaton> getStandByAutomaton() {
        return Optional.ofNullable(this.standByAutomaton);
    }

    @Override
    public Optional<LfShunt> getStandByAutomatonShunt() {
        return Optional.ofNullable(this.standByAutomatonShunt);
    }

    @Override
    public void setStandByAutomatonShunt(LfShunt standByAutomatonShunt) {
        this.standByAutomatonShunt = standByAutomatonShunt;
    }
}

