/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfNetworkParameters;
import com.powsybl.openloadflow.network.LfNetworkStateUpdateParameters;
import com.powsybl.openloadflow.network.LfNetworkUpdateReport;
import com.powsybl.openloadflow.network.PiModel;
import com.powsybl.openloadflow.network.SimplePiModel;
import com.powsybl.openloadflow.network.impl.AbstractImpedantLfBranch;
import com.powsybl.openloadflow.network.impl.OlfBranchResult;
import com.powsybl.openloadflow.network.impl.Ref;
import com.powsybl.openloadflow.network.impl.Transformers;
import com.powsybl.openloadflow.sa.LimitReductionManager;
import com.powsybl.openloadflow.util.PerUnit;
import com.powsybl.security.results.BranchResult;
import java.util.List;
import java.util.Objects;

public class LfTieLineBranch
extends AbstractImpedantLfBranch {
    private final Ref<DanglingLine> danglingLine1Ref;
    private final Ref<DanglingLine> danglingLine2Ref;
    private final String id;

    protected LfTieLineBranch(LfNetwork network, LfBus bus1, LfBus bus2, PiModel piModel, TieLine tieLine, LfNetworkParameters parameters) {
        super(network, bus1, bus2, piModel, parameters);
        this.danglingLine1Ref = Ref.create(tieLine.getDanglingLine1(), parameters.isCacheEnabled());
        this.danglingLine2Ref = Ref.create(tieLine.getDanglingLine2(), parameters.isCacheEnabled());
        this.id = tieLine.getId();
    }

    public static LfTieLineBranch create(TieLine line, LfNetwork network, LfBus bus1, LfBus bus2, LfNetworkParameters parameters) {
        Objects.requireNonNull(line);
        Objects.requireNonNull(network);
        Objects.requireNonNull(parameters);
        double nominalV2 = line.getDanglingLine2().getTerminal().getVoltageLevel().getNominalV();
        double zb = PerUnit.zb(nominalV2);
        SimplePiModel piModel = new SimplePiModel().setR1(1.0 / Transformers.getRatioPerUnitBase(line)).setR(line.getR() / zb).setX(line.getX() / zb).setG1(line.getG1() * zb).setG2(line.getG2() * zb).setB1(line.getB1() * zb).setB2(line.getB2() * zb);
        return new LfTieLineBranch(network, bus1, bus2, piModel, line, parameters);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getOriginalIds() {
        return List.of(this.id, this.danglingLine1Ref.get().getId(), this.danglingLine2Ref.get().getId());
    }

    @Override
    public LfBranch.BranchType getBranchType() {
        return LfBranch.BranchType.TIE_LINE;
    }

    public DanglingLine getHalf1() {
        return this.danglingLine1Ref.get();
    }

    public DanglingLine getHalf2() {
        return this.danglingLine2Ref.get();
    }

    @Override
    public List<BranchResult> createBranchResult(double preContingencyBranchP1, double preContingencyBranchOfContingencyP1, boolean createExtension) {
        double flowTransfer = Double.NaN;
        if (!Double.isNaN(preContingencyBranchP1) && !Double.isNaN(preContingencyBranchOfContingencyP1)) {
            flowTransfer = (this.p1.eval() * 100.0 - preContingencyBranchP1) / preContingencyBranchOfContingencyP1;
        }
        double nominalV1 = this.getHalf1().getTerminal().getVoltageLevel().getNominalV();
        double nominalV2 = this.getHalf2().getTerminal().getVoltageLevel().getNominalV();
        double currentScale1 = PerUnit.ib(nominalV1);
        double currentScale2 = PerUnit.ib(nominalV2);
        BranchResult branchResult = new BranchResult(this.getId(), this.p1.eval() * 100.0, this.q1.eval() * 100.0, currentScale1 * this.i1.eval(), this.p2.eval() * 100.0, this.q2.eval() * 100.0, currentScale2 * this.i2.eval(), flowTransfer);
        BranchResult half1Result = new BranchResult(this.getHalf1().getId(), this.p1.eval() * 100.0, this.q1.eval() * 100.0, currentScale1 * this.i1.eval(), Double.NaN, Double.NaN, Double.NaN, flowTransfer);
        BranchResult half2Result = new BranchResult(this.getHalf2().getId(), this.p2.eval() * 100.0, this.q2.eval() * 100.0, currentScale2 * this.i2.eval(), Double.NaN, Double.NaN, Double.NaN, flowTransfer);
        if (createExtension) {
            branchResult.addExtension(OlfBranchResult.class, (Extension)new OlfBranchResult(this.piModel.getR1(), this.piModel.getContinuousR1(), this.getV1() * nominalV1, this.getV2() * nominalV2, Math.toDegrees(this.getAngle1()), Math.toDegrees(this.getAngle2())));
            half1Result.addExtension(OlfBranchResult.class, (Extension)new OlfBranchResult(this.piModel.getR1(), this.piModel.getContinuousR1(), this.getV1() * nominalV1, Double.NaN, Math.toDegrees(this.getAngle1()), Double.NaN));
            half2Result.addExtension(OlfBranchResult.class, (Extension)new OlfBranchResult(this.piModel.getR1(), this.piModel.getContinuousR1(), Double.NaN, this.getV2() * nominalV2, Double.NaN, Math.toDegrees(this.getAngle2())));
        }
        return List.of(branchResult, half1Result, half2Result);
    }

    @Override
    public List<LfBranch.LfLimit> getLimits1(LimitType type, LimitReductionManager limitReductionManager) {
        switch (type) {
            case ACTIVE_POWER: {
                return this.getLimits1(type, this.getHalf1().getActivePowerLimits().orElse(null), limitReductionManager);
            }
            case APPARENT_POWER: {
                return this.getLimits1(type, this.getHalf1().getApparentPowerLimits().orElse(null), limitReductionManager);
            }
            case CURRENT: {
                return this.getLimits1(type, this.getHalf1().getCurrentLimits().orElse(null), limitReductionManager);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    @Override
    public List<LfBranch.LfLimit> getLimits2(LimitType type, LimitReductionManager limitReductionManager) {
        switch (type) {
            case ACTIVE_POWER: {
                return this.getLimits2(type, this.getHalf2().getActivePowerLimits().orElse(null), limitReductionManager);
            }
            case APPARENT_POWER: {
                return this.getLimits2(type, this.getHalf2().getApparentPowerLimits().orElse(null), limitReductionManager);
            }
            case CURRENT: {
                return this.getLimits2(type, this.getHalf2().getCurrentLimits().orElse(null), limitReductionManager);
            }
        }
        throw new UnsupportedOperationException(String.format("Getting %s limits is not supported.", type.name()));
    }

    @Override
    public double[] getLimitReductions(TwoSides side, LimitReductionManager limitReductionManager, LoadingLimits limits) {
        return new double[0];
    }

    @Override
    public void updateState(LfNetworkStateUpdateParameters parameters, LfNetworkUpdateReport updateReport) {
        this.updateFlows(this.p1.eval(), this.q1.eval(), this.p2.eval(), this.q2.eval());
    }

    @Override
    public void updateFlows(double p1, double q1, double p2, double q2) {
        this.getHalf1().getTerminal().setP(p1 * 100.0).setQ(q1 * 100.0);
        this.getHalf2().getTerminal().setP(p2 * 100.0).setQ(q2 * 100.0);
    }

    @Override
    public boolean hasPhaseControllerCapability() {
        return false;
    }
}

