/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.impl;

import com.google.common.collect.Sets;
import com.powsybl.commons.PowsyblException;
import com.powsybl.contingency.Contingency;
import com.powsybl.contingency.ContingencyElement;
import com.powsybl.contingency.ContingencyElementType;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DefaultTopologyVisitor;
import com.powsybl.iidm.network.HvdcConverterStation;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.extensions.LoadDetail;
import com.powsybl.iidm.network.util.HvdcUtils;
import com.powsybl.openloadflow.graph.GraphConnectivity;
import com.powsybl.openloadflow.network.AdmittanceShift;
import com.powsybl.openloadflow.network.DisabledBranchStatus;
import com.powsybl.openloadflow.network.DisabledNetwork;
import com.powsybl.openloadflow.network.LfBranch;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfContingency;
import com.powsybl.openloadflow.network.LfGenerator;
import com.powsybl.openloadflow.network.LfHvdc;
import com.powsybl.openloadflow.network.LfLoad;
import com.powsybl.openloadflow.network.LfLostLoad;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.LfShunt;
import com.powsybl.openloadflow.network.LfTopoConfig;
import com.powsybl.openloadflow.network.PowerShift;
import com.powsybl.openloadflow.network.impl.ContingencyTripping;
import com.powsybl.openloadflow.network.impl.LfLegBranch;
import com.powsybl.openloadflow.network.impl.Networks;
import com.powsybl.openloadflow.network.impl.PropagatedContingencyCreationParameters;
import com.powsybl.openloadflow.util.PerUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagatedContingency {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PropagatedContingency.class);
    private final Contingency contingency;
    private final int index;
    private final Set<Switch> switchesToOpen;
    private final Set<Terminal> terminalsToDisconnect;
    private final Set<String> busIdsToLose;
    private final Map<String, DisabledBranchStatus> branchIdsToOpen = new LinkedHashMap<String, DisabledBranchStatus>();
    private final Set<String> hvdcIdsToOpen = new HashSet<String>();
    private final Set<String> generatorIdsToLose = new HashSet<String>();
    private final Map<String, PowerShift> loadIdsToLoose = new HashMap<String, PowerShift>();
    private final Map<String, AdmittanceShift> shuntIdsToShift = new HashMap<String, AdmittanceShift>();

    public Contingency getContingency() {
        return this.contingency;
    }

    public int getIndex() {
        return this.index;
    }

    public Set<String> getBusIdsToLose() {
        return this.busIdsToLose;
    }

    public Map<String, DisabledBranchStatus> getBranchIdsToOpen() {
        return this.branchIdsToOpen;
    }

    public Set<String> getGeneratorIdsToLose() {
        return this.generatorIdsToLose;
    }

    public Map<String, PowerShift> getLoadIdsToLoose() {
        return this.loadIdsToLoose;
    }

    public PropagatedContingency(Contingency contingency, int index, Set<Switch> switchesToOpen, Set<Terminal> terminalsToDisconnect, Set<String> busIdsToLose) {
        this.contingency = Objects.requireNonNull(contingency);
        this.index = index;
        this.switchesToOpen = Objects.requireNonNull(switchesToOpen);
        this.terminalsToDisconnect = Objects.requireNonNull(terminalsToDisconnect);
        this.busIdsToLose = Objects.requireNonNull(busIdsToLose);
    }

    private static PowerShift getLoadPowerShift(Load load, boolean slackDistributionOnConformLoad) {
        LoadDetail loadDetail;
        double variableActivePower = slackDistributionOnConformLoad ? ((loadDetail = (LoadDetail)load.getExtension(LoadDetail.class)) == null ? 0.0 : Math.abs(loadDetail.getVariableActivePower())) : Math.abs(load.getP0());
        return new PowerShift(load.getP0() / 100.0, variableActivePower / 100.0, load.getQ0() / 100.0);
    }

    public static List<PropagatedContingency> createList(Network network, List<Contingency> contingencies, LfTopoConfig topoConfig, PropagatedContingencyCreationParameters creationParameters) {
        ArrayList<PropagatedContingency> propagatedContingencies = new ArrayList<PropagatedContingency>();
        for (int index = 0; index < contingencies.size(); ++index) {
            Contingency contingency = contingencies.get(index);
            PropagatedContingency propagatedContingency = PropagatedContingency.create(network, contingency, index, topoConfig, creationParameters);
            propagatedContingencies.add(propagatedContingency);
            topoConfig.getSwitchesToOpen().addAll(propagatedContingency.switchesToOpen);
            topoConfig.getBusIdsToLose().addAll(propagatedContingency.busIdsToLose);
        }
        return propagatedContingencies;
    }

    private static PropagatedContingency create(Network network, Contingency contingency, int index, final LfTopoConfig topoConfig, PropagatedContingencyCreationParameters creationParameters) {
        HashSet<Switch> switchesToOpen = new HashSet<Switch>();
        HashSet<Terminal> terminalsToDisconnect = new HashSet<Terminal>();
        HashSet<String> busIdsToLose = new HashSet<String>();
        block5: for (ContingencyElement element : contingency.getElements()) {
            Identifiable<?> identifiable = PropagatedContingency.getIdentifiable(network, element);
            switch (identifiable.getType()) {
                case BUS: {
                    Bus bus = (Bus)identifiable;
                    if (bus.getVoltageLevel().getTopologyKind() == TopologyKind.BUS_BREAKER) {
                        busIdsToLose.add(identifiable.getId());
                        bus.visitConnectedEquipments((TopologyVisitor)new DefaultTopologyVisitor(){

                            public void visitBranch(Branch<?> branch, TwoSides side) {
                                if (side == TwoSides.ONE) {
                                    topoConfig.getBranchIdsOpenableSide1().add(branch.getId());
                                } else {
                                    topoConfig.getBranchIdsOpenableSide2().add(branch.getId());
                                }
                            }

                            public void visitLine(Line line, TwoSides side) {
                                this.visitBranch((Branch<?>)line, side);
                            }

                            public void visitTwoWindingsTransformer(TwoWindingsTransformer transformer, TwoSides side) {
                                this.visitBranch((Branch<?>)transformer, side);
                            }

                            public void visitThreeWindingsTransformer(ThreeWindingsTransformer transformer, ThreeSides side) {
                                topoConfig.getBranchIdsOpenableSide1().add(LfLegBranch.getId(transformer.getId(), side.getNum()));
                            }
                        });
                        continue block5;
                    }
                    throw new UnsupportedOperationException("Unsupported contingency element type " + element.getType() + ": voltage level should be in bus/breaker topology");
                }
                case BUSBAR_SECTION: {
                    if (creationParameters.isContingencyPropagation()) {
                        ContingencyTripping.createContingencyTripping(network, identifiable).traverse(switchesToOpen, terminalsToDisconnect);
                    } else {
                        ContingencyTripping.createBusbarSectionMinimalTripping(network, (BusbarSection)identifiable).traverse(switchesToOpen, terminalsToDisconnect);
                    }
                    terminalsToDisconnect.addAll(PropagatedContingency.getTerminals(identifiable));
                    continue block5;
                }
                case SWITCH: {
                    switchesToOpen.add((Switch)identifiable);
                    continue block5;
                }
            }
            if (creationParameters.isContingencyPropagation()) {
                ContingencyTripping.createContingencyTripping(network, identifiable).traverse(switchesToOpen, terminalsToDisconnect);
            }
            terminalsToDisconnect.addAll(PropagatedContingency.getTerminals(identifiable));
        }
        PropagatedContingency propagatedContingency = new PropagatedContingency(contingency, index, switchesToOpen, terminalsToDisconnect, busIdsToLose);
        propagatedContingency.complete(topoConfig, creationParameters);
        return propagatedContingency;
    }

    private <K> void addBranchToOpen(K branchId, DisabledBranchStatus status, Map<K, DisabledBranchStatus> branchIdsToOpen) {
        DisabledBranchStatus oldStatus = branchIdsToOpen.get(branchId);
        if (oldStatus == null) {
            branchIdsToOpen.put(branchId, status);
        } else if (status == DisabledBranchStatus.BOTH_SIDES || status != oldStatus) {
            branchIdsToOpen.put(branchId, DisabledBranchStatus.BOTH_SIDES);
        }
    }

    private void complete(LfTopoConfig topoConfig, PropagatedContingencyCreationParameters creationParameters) {
        for (Switch sw : this.switchesToOpen) {
            this.addBranchToOpen(sw.getId(), DisabledBranchStatus.BOTH_SIDES, this.branchIdsToOpen);
        }
        block11: for (Terminal terminal : this.terminalsToDisconnect) {
            Connectable connectable = terminal.getConnectable();
            block0 : switch (connectable.getType()) {
                case LINE: 
                case TWO_WINDINGS_TRANSFORMER: {
                    Branch branch = (Branch)connectable;
                    if (terminal == branch.getTerminal1()) {
                        this.addBranchToOpen(connectable.getId(), DisabledBranchStatus.SIDE_1, this.branchIdsToOpen);
                        topoConfig.getBranchIdsOpenableSide1().add(connectable.getId());
                        break;
                    }
                    this.addBranchToOpen(connectable.getId(), DisabledBranchStatus.SIDE_2, this.branchIdsToOpen);
                    topoConfig.getBranchIdsOpenableSide2().add(connectable.getId());
                    break;
                }
                case DANGLING_LINE: {
                    DanglingLine dl = (DanglingLine)connectable;
                    if (dl.isPaired()) {
                        this.addBranchToOpen(((TieLine)dl.getTieLine().orElseThrow()).getId(), DisabledBranchStatus.BOTH_SIDES, this.branchIdsToOpen);
                        break;
                    }
                    this.addBranchToOpen(dl.getId(), DisabledBranchStatus.BOTH_SIDES, this.branchIdsToOpen);
                    break;
                }
                case GENERATOR: 
                case STATIC_VAR_COMPENSATOR: 
                case BATTERY: {
                    this.generatorIdsToLose.add(connectable.getId());
                    break;
                }
                case LOAD: {
                    Load load = (Load)connectable;
                    this.loadIdsToLoose.put(load.getId(), PropagatedContingency.getLoadPowerShift(load, creationParameters.isSlackDistributionOnConformLoad()));
                    break;
                }
                case SHUNT_COMPENSATOR: {
                    ShuntCompensator shunt = (ShuntCompensator)connectable;
                    if (creationParameters.isShuntCompensatorVoltageControlOn() && shunt.isVoltageRegulatorOn()) {
                        throw new UnsupportedOperationException("Shunt compensator '" + shunt.getId() + "' with voltage control on: not supported yet");
                    }
                    double zb = PerUnit.zb(shunt.getTerminal().getVoltageLevel().getNominalV());
                    this.shuntIdsToShift.put(shunt.getId(), new AdmittanceShift(shunt.getG() * zb, shunt.getB() * zb));
                    break;
                }
                case HVDC_CONVERTER_STATION: {
                    HvdcConverterStation station = (HvdcConverterStation)connectable;
                    this.hvdcIdsToOpen.add(station.getHvdcLine().getId());
                    if (connectable instanceof VscConverterStation) {
                        this.generatorIdsToLose.add(connectable.getId());
                        break;
                    }
                    LccConverterStation lcc = (LccConverterStation)connectable;
                    PowerShift lccPowerShift = new PowerShift(HvdcUtils.getConverterStationTargetP((HvdcConverterStation)lcc) / 100.0, 0.0, HvdcUtils.getLccConverterStationLoadTargetQ((LccConverterStation)lcc) / 100.0);
                    this.loadIdsToLoose.put(lcc.getId(), lccPowerShift);
                    break;
                }
                case BUSBAR_SECTION: {
                    break;
                }
                case THREE_WINDINGS_TRANSFORMER: {
                    ThreeWindingsTransformer twt = (ThreeWindingsTransformer)connectable;
                    for (ThreeSides side : ThreeSides.values()) {
                        if (twt.getTerminal(side) != terminal) continue;
                        this.addBranchToOpen(LfLegBranch.getId(side, connectable.getId()), DisabledBranchStatus.SIDE_1, this.branchIdsToOpen);
                        topoConfig.getBranchIdsOpenableSide1().add(LfLegBranch.getId(connectable.getId(), side.getNum()));
                        break block0;
                    }
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported by propagation contingency element type: " + connectable.getType());
                }
            }
        }
    }

    private static List<? extends Terminal> getTerminals(Identifiable<?> identifiable) {
        if (identifiable instanceof Connectable) {
            return ((Connectable)identifiable).getTerminals();
        }
        if (identifiable instanceof HvdcLine) {
            HvdcLine hvdcLine = (HvdcLine)identifiable;
            return List.of(hvdcLine.getConverterStation1().getTerminal(), hvdcLine.getConverterStation2().getTerminal());
        }
        if (identifiable instanceof TieLine) {
            TieLine line = (TieLine)identifiable;
            return List.of(line.getDanglingLine1().getTerminal(), line.getDanglingLine2().getTerminal());
        }
        if (identifiable instanceof Switch) {
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Unsupported contingency element type: " + identifiable.getType());
    }

    private static Identifiable<?> getIdentifiable(Network network, ContingencyElement element) {
        Branch identifiable;
        String identifiableType = switch (element.getType()) {
            case ContingencyElementType.BRANCH, ContingencyElementType.LINE, ContingencyElementType.TWO_WINDINGS_TRANSFORMER -> {
                identifiable = network.getBranch(element.getId());
                yield "Branch";
            }
            case ContingencyElementType.HVDC_LINE -> {
                identifiable = network.getHvdcLine(element.getId());
                yield "HVDC line";
            }
            case ContingencyElementType.DANGLING_LINE -> {
                identifiable = network.getDanglingLine(element.getId());
                yield "Dangling line";
            }
            case ContingencyElementType.GENERATOR -> {
                identifiable = network.getGenerator(element.getId());
                yield "Generator";
            }
            case ContingencyElementType.STATIC_VAR_COMPENSATOR -> {
                identifiable = network.getStaticVarCompensator(element.getId());
                yield "Static var compensator";
            }
            case ContingencyElementType.LOAD -> {
                identifiable = network.getLoad(element.getId());
                yield "Load";
            }
            case ContingencyElementType.SHUNT_COMPENSATOR -> {
                identifiable = network.getShuntCompensator(element.getId());
                yield "Shunt compensator";
            }
            case ContingencyElementType.SWITCH -> {
                identifiable = network.getSwitch(element.getId());
                yield "Switch";
            }
            case ContingencyElementType.THREE_WINDINGS_TRANSFORMER -> {
                identifiable = network.getThreeWindingsTransformer(element.getId());
                yield "Three windings transformer";
            }
            case ContingencyElementType.BUSBAR_SECTION -> {
                identifiable = network.getBusbarSection(element.getId());
                yield "Busbar section";
            }
            case ContingencyElementType.TIE_LINE -> {
                identifiable = network.getTieLine(element.getId());
                yield "Tie line";
            }
            case ContingencyElementType.BUS -> {
                identifiable = network.getBusBreakerView().getBus(element.getId());
                yield "Configured bus";
            }
            case ContingencyElementType.BATTERY -> {
                identifiable = network.getBattery(element.getId());
                yield "Battery";
            }
            default -> throw new UnsupportedOperationException("Unsupported contingency element type: " + element.getType());
        };
        if (identifiable == null) {
            throw new PowsyblException(identifiableType + " '" + element.getId() + "' not found in the network");
        }
        return identifiable;
    }

    public boolean hasNoImpact() {
        return this.branchIdsToOpen.isEmpty() && this.hvdcIdsToOpen.isEmpty() && this.generatorIdsToLose.isEmpty() && this.loadIdsToLoose.isEmpty() && this.shuntIdsToShift.isEmpty() && this.busIdsToLose.isEmpty();
    }

    private static boolean isSlackBusIsolated(GraphConnectivity<LfBus, LfBranch> connectivity, LfBus slackBus) {
        int number = connectivity.getComponentNumber(slackBus);
        if (number != 0) {
            return connectivity.getLargestConnectedComponent().size() != connectivity.getConnectedComponent(slackBus).size();
        }
        return false;
    }

    private Map<LfBranch, DisabledBranchStatus> findBranchToOpenDirectlyImpactedByContingency(LfNetwork network) {
        Map branchesToOpen = this.branchIdsToOpen.entrySet().stream().map(e -> Pair.of((Object)network.getBranchById((String)e.getKey()), (Object)((Object)((DisabledBranchStatus)((Object)((Object)e.getValue())))))).filter(e -> e.getKey() != null).collect(Collectors.toMap(Pair::getKey, Pair::getValue, (disabledBranchStatus, disabledBranchStatus2) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
        this.busIdsToLose.stream().map(network::getBusById).filter(Objects::nonNull).forEach(bus -> bus.getBranches().forEach(branch -> {
            DisabledBranchStatus status = branch.getBus1() == bus ? DisabledBranchStatus.SIDE_1 : DisabledBranchStatus.SIDE_2;
            this.addBranchToOpen(branch, status, branchesToOpen);
        }));
        return branchesToOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContingencyConnectivityLossImpact findBusesAndBranchesImpactedBecauseOfConnectivityLoss(LfNetwork network, Map<LfBranch, DisabledBranchStatus> branchesToOpen) {
        GraphConnectivity<LfBus, LfBranch> connectivity = network.getConnectivity();
        connectivity.startTemporaryChanges();
        try {
            branchesToOpen.keySet().stream().filter(LfBranch::isConnectedAtBothSides).forEach(connectivity::removeEdge);
            if (PropagatedContingency.isSlackBusIsolated(connectivity, network.getSlackBus())) {
                LOGGER.warn("Contingency '{}' leads to an isolated slack bus: relocate slack bus inside main component", (Object)this.contingency.getId());
                Sets.SetView excludedBuses = Sets.difference(Set.copyOf(network.getBuses()), connectivity.getLargestConnectedComponent());
                network.setExcludedSlackBuses((Set<LfBus>)excludedBuses);
                connectivity.setMainComponentVertex(network.getSlackBus());
            }
            int createdSynchronousComponents = connectivity.getNbConnectedComponents() - 1;
            Set<LfBus> busesToLost = connectivity.getVerticesRemovedFromMainComponent();
            HashSet<LfHvdc> hvdcsWithoutFlow = new HashSet<LfHvdc>();
            for (LfHvdc hvdcLine : network.getHvdcs()) {
                if (!this.checkIsolatedBus(hvdcLine.getBus1(), hvdcLine.getBus2(), busesToLost, connectivity) && !this.checkIsolatedBus(hvdcLine.getBus2(), hvdcLine.getBus1(), busesToLost, connectivity)) continue;
                hvdcsWithoutFlow.add(hvdcLine);
            }
            ContingencyConnectivityLossImpact contingencyConnectivityLossImpact = new ContingencyConnectivityLossImpact(true, createdSynchronousComponents, busesToLost, hvdcsWithoutFlow);
            return contingencyConnectivityLossImpact;
        }
        finally {
            connectivity.undoTemporaryChanges();
        }
    }

    private boolean checkIsolatedBus(LfBus bus1, LfBus bus2, Set<LfBus> busesToLost, GraphConnectivity<LfBus, LfBranch> connectivity) {
        return busesToLost.contains(bus1) && !busesToLost.contains(bus2) && Networks.isIsolatedBusForHvdc(bus1, connectivity);
    }

    private static boolean isConnectedAfterContingencySide1(Map<LfBranch, DisabledBranchStatus> branchesToOpen, LfBranch branch) {
        DisabledBranchStatus status = branchesToOpen.get(branch);
        return status == null || status == DisabledBranchStatus.SIDE_2;
    }

    private static boolean isConnectedAfterContingencySide2(Map<LfBranch, DisabledBranchStatus> branchesToOpen, LfBranch branch) {
        DisabledBranchStatus status = branchesToOpen.get(branch);
        return status == null || status == DisabledBranchStatus.SIDE_1;
    }

    public Optional<LfContingency> toLfContingency(LfNetwork network) {
        Map<LfBranch, DisabledBranchStatus> branchesToOpen = this.findBranchToOpenDirectlyImpactedByContingency(network);
        ContingencyConnectivityLossImpact connectivityLossImpact = this.findBusesAndBranchesImpactedBecauseOfConnectivityLoss(network, branchesToOpen);
        if (!connectivityLossImpact.ok) {
            return Optional.empty();
        }
        Set<LfBus> busesToLost = connectivityLossImpact.busesToLost();
        for (LfBus lfBus : busesToLost) {
            lfBus.getBranches().forEach(branch -> {
                boolean otherSideConnected;
                LfBus otherSideBus;
                if (branch.getBus1() == lfBus) {
                    otherSideBus = branch.getBus2();
                    otherSideConnected = branch.isConnectedSide2() && PropagatedContingency.isConnectedAfterContingencySide2(branchesToOpen, branch);
                } else {
                    otherSideBus = branch.getBus1();
                    boolean bl = otherSideConnected = branch.isConnectedSide1() && PropagatedContingency.isConnectedAfterContingencySide1(branchesToOpen, branch);
                }
                if (busesToLost.contains(otherSideBus) || !otherSideConnected) {
                    this.addBranchToOpen(branch, DisabledBranchStatus.BOTH_SIDES, branchesToOpen);
                }
            });
        }
        LinkedHashMap<LfShunt, AdmittanceShift> shunts = new LinkedHashMap<LfShunt, AdmittanceShift>(1);
        for (Map.Entry<String, AdmittanceShift> entry : this.shuntIdsToShift.entrySet()) {
            LfShunt lfShunt = network.getShuntById(entry.getKey());
            if (lfShunt == null) continue;
            shunts.computeIfAbsent(lfShunt, k -> new AdmittanceShift()).add(entry.getValue());
        }
        LinkedHashSet<LfGenerator> linkedHashSet = new LinkedHashSet<LfGenerator>(1);
        for (String string : this.generatorIdsToLose) {
            LfGenerator lfGenerator = network.getGeneratorById(string);
            if (lfGenerator == null) continue;
            linkedHashSet.add(lfGenerator);
        }
        LinkedHashMap<LfLoad, LfLostLoad> linkedHashMap = new LinkedHashMap<LfLoad, LfLostLoad>(1);
        for (Map.Entry<String, PowerShift> entry : this.loadIdsToLoose.entrySet()) {
            String loadId = entry.getKey();
            PowerShift powerShift = entry.getValue();
            LfLoad load = network.getLoadById(loadId);
            if (load == null) continue;
            LfLostLoad lostLoad = linkedHashMap.computeIfAbsent(load, k -> new LfLostLoad());
            lostLoad.getPowerShift().add(powerShift);
            lostLoad.getOriginalIds().add(loadId);
        }
        Set set = this.hvdcIdsToOpen.stream().map(network::getHvdcById).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        for (LfHvdc hvdcLine : network.getHvdcs()) {
            if (!busesToLost.contains(hvdcLine.getBus1()) && !busesToLost.contains(hvdcLine.getBus2())) continue;
            set.add(hvdcLine);
        }
        if (branchesToOpen.isEmpty() && busesToLost.isEmpty() && shunts.isEmpty() && linkedHashMap.isEmpty() && linkedHashSet.isEmpty() && set.isEmpty() && connectivityLossImpact.hvdcsWithoutPower().isEmpty()) {
            LOGGER.debug("Contingency '{}' has no impact", (Object)this.contingency.getId());
            return Optional.empty();
        }
        return Optional.of(new LfContingency(this.contingency.getId(), this.index, connectivityLossImpact.createdSynchronousComponents, new DisabledNetwork(busesToLost, branchesToOpen, (Set<LfHvdc>)set), shunts, linkedHashMap, linkedHashSet, connectivityLossImpact.hvdcsWithoutPower()));
    }

    record ContingencyConnectivityLossImpact(boolean ok, int createdSynchronousComponents, Set<LfBus> busesToLost, Set<LfHvdc> hvdcsWithoutPower) {
    }
}

