/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.openloadflow.network.util;

import com.powsybl.loadflow.LoadFlowParameters;
import com.powsybl.openloadflow.network.LfBus;
import com.powsybl.openloadflow.network.LfNetwork;
import com.powsybl.openloadflow.network.util.GenerationActivePowerDistributionStep;
import com.powsybl.openloadflow.network.util.LoadActivePowerDistributionStep;
import com.powsybl.openloadflow.network.util.ParticipatingElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ActivePowerDistribution {
    public static final double P_RESIDUE_EPS = Math.pow(10.0, -5.0);
    private final Step step;

    private ActivePowerDistribution(Step step) {
        this.step = Objects.requireNonNull(step);
    }

    public String getElementType() {
        return this.step.getElementType();
    }

    public Result run(LfNetwork network, double activePowerMismatch) {
        return this.run(network.getBuses(), activePowerMismatch);
    }

    public Result run(Collection<LfBus> buses, double activePowerMismatch) {
        List<ParticipatingElement> participatingElements = this.step.getParticipatingElements(buses);
        Map initialP = participatingElements.stream().collect(Collectors.toUnmodifiableMap(Function.identity(), ParticipatingElement::getTargetP));
        int iteration = 0;
        double remainingMismatch = activePowerMismatch;
        while (!participatingElements.isEmpty() && Math.abs(remainingMismatch) > P_RESIDUE_EPS && ParticipatingElement.participationFactorNorm(participatingElements) > 0.0) {
            double done = this.step.run(participatingElements, iteration, remainingMismatch);
            remainingMismatch -= done;
            ++iteration;
        }
        boolean movedBuses = initialP.entrySet().stream().anyMatch(e -> Math.abs(((ParticipatingElement)e.getKey()).getTargetP() - (Double)e.getValue()) > P_RESIDUE_EPS);
        return new Result(iteration, remainingMismatch, movedBuses);
    }

    public static ActivePowerDistribution create(LoadFlowParameters.BalanceType balanceType, boolean loadPowerFactorConstant, boolean useActiveLimits) {
        return new ActivePowerDistribution(ActivePowerDistribution.getStep(balanceType, loadPowerFactorConstant, useActiveLimits));
    }

    public static Step getStep(LoadFlowParameters.BalanceType balanceType, boolean loadPowerFactorConstant, boolean useActiveLimits) {
        return switch (balanceType) {
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_LOAD, LoadFlowParameters.BalanceType.PROPORTIONAL_TO_CONFORM_LOAD -> new LoadActivePowerDistributionStep(loadPowerFactorConstant);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P_MAX -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.MAX, useActiveLimits);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_P -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.TARGET, useActiveLimits);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_PARTICIPATION_FACTOR -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.PARTICIPATION_FACTOR, useActiveLimits);
            case LoadFlowParameters.BalanceType.PROPORTIONAL_TO_GENERATION_REMAINING_MARGIN -> new GenerationActivePowerDistributionStep(GenerationActivePowerDistributionStep.ParticipationType.REMAINING_MARGIN, useActiveLimits);
            default -> throw new UnsupportedOperationException("Unknown balance type mode: " + balanceType);
        };
    }

    public static interface Step {
        public String getElementType();

        public List<ParticipatingElement> getParticipatingElements(Collection<LfBus> var1);

        public double run(List<ParticipatingElement> var1, int var2, double var3);
    }

    public record Result(int iteration, double remainingMismatch, boolean movedBuses) {
    }
}

